//----------------------------------------------------------------------------
// 	31 for Windows  version 95.5  Copyright 1993-1999 Meusesoft
//
//		Windows 1.0: 8 july 1995 -  3 september 1995
//		version 1.1: 2 player version Windows: 7 january 1996 - 12 january 1996
//		version 1.2: Different names and better abort 2 player
//				 			: 8 august 1996 - 9 august 1996
//		version 1.3: Multi-language (Dutch and English) & Card Animation
//							: 18 september 1996 - 13 october 1996
//		version 2.0: Same as 95.3 except from multiplayer
//							: 14 august 1997 - 19 september 1997
//
//		version 95.1: Multi-player by using network in stead of com-ports.
//						  Windows 95 version.
//                  Second variant added.
//						  Multiple card-backsides possible.
//							: 24 december 1996 - 9 februari 1997
//		version 95.2: Bug floating cards removed
//							: 19 april 1997 - 31 may 1997
//		version 95.3: Floating of cards further improved
//							: 1 august 1997 - 14 september 1997
//		version 95.4: Cheats
//						  Real multiplayer in stead of twoplayer
//						  Buttons Change & Pass exchanged
//						  Improved options dialog (card preview)
//						  : 25 september 1997 - 28 march 1998
//		version 95.5: User definable variations
//							Improved graphics
//						  : september 1999 - 29 november 1999
//
//		version 95.5.2: Added keystrokes for selecting cards
//						    Changed link for registrating
//							 Updated help files to HTML Help
//						  : 9 juli 2002 - 13 juli 2002
//
//
//		version 95.5.3: Added internet play
//						  : 25 juli 2002 - 27 december 2002
//
//		version 95.5.4: Free ware and open source
//						  : june 2008
//
//		Original MSX: 12 november 1993 - 2 december 1993
//		Adjusted version MSX: 26 march 1994	- 5 april 1995
//		2 player version MSX: 10 january 1995 - 17 january 1995
//----------------------------------------------------------------------------
#include "main.h"
#pragma 	hdrstop
#include "t31but.h"
#include "31win.h"
#include "dynarray.h"

#include "31windlg.h"
#include "tinternetwaitplayersdlg.h"
#include "31winprg.h"                  
//#include "htmlhelp.h"                                            

#define MaxName 17
#define ToolTipID1 21
#define ToolTipID2 22
#define ToolTipID3 23
#define ToolTipID4 24
#define ToolTipID5 25
#define IDC_CHEAT 31
#define IDC_CHEAT2 32
#define IDC_REGISTRATE 33

uint CardX[]={205,285,365,30,45,60,270,285,300,510,525,540,205,285,365};
uint CardY[]={335,335,335,181,174,181,22,15,22,181,174,181,174,174,174};

const int TimerId=250;
bool engels;

DEFINE_RESPONSE_TABLE1(TCardGame, TWindow)
	EV_WM_TIMER,
	EV_COMMAND(ID_STOP,TerminateGame),
	EV_COMMAND(ID_START,IdStart),
	EV_COMMAND(IDC_PRESSCARD1,CmPressCard1),
	EV_COMMAND(IDC_PRESSCARD2,CmPressCard2),
	EV_COMMAND(IDC_PRESSCARD3,CmPressCard3),
	EV_COMMAND(IDC_PRESSCARD4,CmPressCard4),
	EV_COMMAND(IDC_PRESSCARD5,CmPressCard5),
	EV_COMMAND(IDC_PRESSCARD6,CmPressCard6),
	EV_COMMAND(CM_NOVICE,SetNovice),
	EV_COMMAND(CM_ADVANCED,SetAdvanced),
	EV_COMMAND(CM_EXPERT,SetExpert),
   EV_COMMAND(CM_OPTIONS, Opties),
   EV_COMMAND(CM_STARTINTERNET, CmStartInternetGame),
	EV_COMMAND(ID_CHANGEPLAYER,ChangePlayer),
	EV_COMMAND(IDC_ChangeCard,ChangeCard),
	EV_COMMAND(IDC_Pass,Pass),
	EV_COMMAND(IDC_ChangeAll,ChangeAll),
  	EV_COMMAND(ID_ABOUT, IdAbout),
	EV_COMMAND(IDC_Deal,Deal),
	EV_COMMAND(IDC_Hold,Hold2),
	EV_COMMAND(IDC_Switch,Switch),
	EV_COMMAND(ID_CONTENTS,StartHelp),
	EV_COMMAND(ID_STAT,ShowStats),
   EV_COMMAND(CM_DUTCH, WisselNL),
   EV_COMMAND(CM_ENGLISH, WisselEN),
	EV_COMMAND_ENABLE(CM_NOVICE, CeLevel),
	EV_COMMAND_ENABLE(CM_ADVANCED, CeLevel),
	EV_COMMAND_ENABLE(CM_EXPERT, CeLevel),
	EV_COMMAND_ENABLE(ID_CHANGEPLAYER, CeLevel),
	#if defined(BI_PLAT_WIN32)
   EV_COMMAND(IDC_Send, SendMessage),
	EV_COMMAND_ENABLE(CM_TWOPLAYER, CeLevel),
	EV_COMMAND(CM_TWOPLAYER, SetupNetworkGame),
   #endif
	EV_COMMAND_ENABLE(ID_START, CeLevel),
	EV_COMMAND_ENABLE(CM_STARTINTERNET, CeLevel),
	EV_COMMAND_ENABLE(ID_STOP, CeStop),
	EV_COMMAND_ENABLE(ID_HELP, CeTurn),
   EV_COMMAND(IDC_CHEAT, ShowCheat),
   EV_COMMAND(IDC_CHEAT2, CheckCheat),
   EV_COMMAND(IDC_REGISTRATE, RegisterThis),
   EV_MESSAGE(WM_USER, NewPlayer),
	EV_TTN_NEEDTEXT(ToolTipID1, HandleTooltipText),
	EV_TTN_NEEDTEXT(ToolTipID2, HandleTooltipTextLinks),
	EV_TTN_NEEDTEXT(ToolTipID3, HandleTooltipTextBoven),
	EV_TTN_NEEDTEXT(ToolTipID4, HandleTooltipTextRechts),
	EV_TTN_NEEDTEXT(ToolTipID5, HandleTooltipTextPot),
	EV_WM_ERASEBKGND,
	EV_WM_LBUTTONDOWN,
	EV_WM_CTLCOLOR,
   EV_MESSAGE(WM_USER+1, CmUser1Message),
   EV_MESSAGE(WM_USER+2, CmUser2Message),
   EV_MESSAGE(WM_USER+3, CmUser3Message),
   EV_MESSAGE(WM_USER+4, CmUser4Message),
END_RESPONSE_TABLE;


TCardGame::TCardGame(TWindow* parent): kwast(TColor(0,128,0))
{
	Init(parent, 0, 0);

   bDebug = false;

   if (bDebug) {
   	::CreateDirectory("Debug", NULL);

      FILE* hFile;

      hFile = fopen("Debug\\ReadBlock.txt", "w");
      fclose (hFile);

      hFile = fopen("Debug\\WriteBlock.txt", "w");
      fclose (hFile);

      hFile = fopen("Debug\\ReceivedEvents.txt", "w");
      fclose (hFile);

      hFile = fopen("Debug\\AckReadBlock.txt", "w");
      fclose (hFile);
      }

  	ChangeBt=new T31Button (this, IDC_ChangeCard, "&Change",105,375,80,25,true);
	PassBt= 	new T31Button (this, IDC_Pass, "&Pass",105,345,80,25,true);
	ChgAllBt=new T31Button (this, IDC_ChangeAll, "&Take Pot",105,405,80,25,true);
	DealBt= 	new T31Button (this, IDC_Deal, "&Deal",455,345,80,25,false);
	HoldBt= 	new T31Button (this, IDC_Hold, "&Hand",455,375,80,25,false);
	SwitchBt=new T31Button (this, IDC_Switch, "P&ot",455,405,80,25,false);
   SendBt=	new T31Button (this, IDC_Send, "", 560,370,35,35,false);

   CheatField=new TEdit(this, 33, "",2,380,80,20, 15);
   CheatField->Attr.Style|=ES_PASSWORD;
   OkCheat=new TButton(this, IDC_CHEAT2, "",82,380,20,20);

	NamePlayer1= new TStatic (this, -1, "",35,155,240,16,0);
	#if defined(DenOudstenVersie)
   NamePlayer2= new TStatic (this, -1, "",390,15,55,16,0);
	#else
   NamePlayer2= new TStatic (this, -1, "",390,15,200,16,0);
	#endif
	NamePlayer3= new TStatic (this, -1, "",515,155,125,16,0);
   strcpy(Name1," ");
   strcpy(Name2," ");
   strcpy(Name3," ");

	for (int i=1; i<36; i++)
		{
		Cardbits[i]=new TBitmap(*GetApplication(), Ruiten_7-1+i);
		}

   #if defined(DenOudstenVersie)
   AchterkantKaart=new TDib(*GetApplication(), (TResId)DenOudstenKaart);
   #else
   AchterkantKaart=new TDib(*GetApplication(), (TResId)33);
   #endif

   MarkBtm[0]=new TBitmap(*GetApplication(), GreenMark);
   MarkBtm[1]=new TBitmap(*GetApplication(), YellowMark);
   MarkBtm[2]=new TBitmap(*GetApplication(), RedMark);
   MarkBtm[3]=new TBitmap(*GetApplication(), EzelMark);
   Sound31=new TMciWaveAudio("sound1.wav");
   SoundWin=new TMciWaveAudio("sound2.wav");
   SoundLoose=new TMciWaveAudio("sound3.wav");
   SoundDeal=new TMciWaveAudio("sound4.wav");
   SoundYawn=new TMciWaveAudio("sound5.wav");

	for (int i=0; i<4; i++)
		{
		Part[i]=4; //4
      Status[i]=0;
		}

	for (int i=0; i<48; i++)
		{
		CardData[i]=0;
		}
	Card1=Card2=GameTypeIcon=0;

	action[0]=0;
	Ezel[4]=exp=nov=adv=play=Leider=TwoPlayer=Master=Knipper=starting=bWaitForPlChoice=false;
   strcpy(NamePlayer," ");
	Yawn=false;
   VariationArray = new TDynamicArray(sizeof(VariationData), 2);
   for (int i=0; i<4; i++) {
   	ReadBuffer[i] = new TDynamicArray(MAX_COMPUTERNAME_LENGTH + 101, 5);
      WriteBuffer[i] = new TDynamicArray(MAX_COMPUTERNAME_LENGTH + 101, 5);
      iReadPointer[i]=0;
      iWritePointer[i]=0;
      }
   TVariationDlg::LoadRules(VariationArray);


   oSockets = new TWinSockets();
   oSockets->bDebugMode = false;
}

bool TCardGame::PreProcessMsg( MSG &m )
{
	#if !defined(DenOudstenVersie)
   tooltip->RelayEvent( m );
   #endif
   
  	return TWindow::PreProcessMsg( m );
}

TCardGame::~TCardGame()
 {
   if (hSlot1!= INVALID_HANDLE_VALUE) CloseHandle(hSlot1);
   if (hSlot2!= INVALID_HANDLE_VALUE) CloseHandle(hSlot2);

   delete oSockets;
	for (int i=1; i<36; i++) delete Cardbits[i];
	for (int i=1; i<4; i++) delete MarkBtm[i];
   #if !defined (DenOudstenVersie)
   delete tooltip;
	#endif
   delete VariationArray;
   for (int i=0; i<4; i++) {
   	ReadBuffer[i]->Clear();
   	delete ReadBuffer[i];
      WriteBuffer[i]->Clear();
      delete WriteBuffer[i];
   	}
   delete Sound31;
   delete SoundWin;
   delete SoundLoose;
   delete SoundDeal;
   delete SoundYawn;
	delete ChangeBt;
	delete PassBt;
	delete ChgAllBt;
	delete DealBt;
	delete HoldBt;
	delete SwitchBt;
   delete SendBt;
	delete NamePlayer1;
	delete NamePlayer2;
	delete NamePlayer3;
   delete AchterkantKaart;
   #if defined(BI_PLAT_WIN32)
   if (MessageDlg) delete MessageDlg;
   #endif
	KillTimer (TimerId);
}

void TCardGame::SetSettings()
{
	char string[4];
   hSlot1=hSlot2=INVALID_HANDLE_VALUE;
   #if defined(BI_PLAT_WIN32)
	strcpy(string, ReadRegistryString(OptionName,"Level","Nov",string,4));
	#else
	GetPrivateProfileString(OptionName,"Level","Nov", string, sizeof(string), "31win.ini");
	#endif
   nov=adv=exp=false;
	if (strcmp(string,"Nov")==0)
		{
		nov=true;
		}
	if (strcmp(string,"Adv")==0)
		{
		adv=true;
		}
	if (strcmp(string,"Exp")==0)
		{
		exp=true;
		}
	if (!TestRegistration())
   	{
   	adv=exp=false;
      nov=true;
      }
   #if defined(BI_PLAT_WIN32)
	strcpy(string, ReadRegistryString(OptionName,"Language","EN",string,4));
	#else
	GetPrivateProfileString(OptionName,"Language","EN",string, sizeof(string), "31win.ini");
	#endif
   if (strcmp(string,"Nl")==0) WisselNL(); else WisselEN();

   #if defined(BI_PLAT_WIN32)
   strcpy(Names[0],ReadRegistryString(OptionName, "Name1", "Rainier", Names[0],17));
   strcpy(Names[1],ReadRegistryString(OptionName, "Name2", "Lucil", Names[1],17));
   strcpy(Names[2],ReadRegistryString(OptionName, "Name3", "Gerard", Names[2],17));
   strcpy(Names[3],ReadRegistryString(OptionName, "Name4", "Leo", Names[3],17));
	#else
	GetPrivateProfileString(OptionName, "Name1", "Rainier", Names[0],17, "31win.ini");
	GetPrivateProfileString(OptionName, "Name2", "Lucil", Names[1],17, "31win.ini");
	GetPrivateProfileString(OptionName, "Name3", "Gerard", Names[2],17, "31win.ini");
	GetPrivateProfileString(OptionName, "Name4", "Leo", Names[3],17, "31win.ini");
	#endif

   sp=ReadRegistryInt(OptionName,"Speed",1);
   if (sp>3) sp=1; // for compatibility with previous releases

   if (ReadRegistryInt(OptionName,"Sound",1)==1) Sound=true;
   	else Sound=false;
   UserAchterkant=((ReadRegistryInt(OptionName,"StandardBackside",0)==0) ? false : true);
   
   #if defined(DenOudstenVersie)
   UserAchterkant=false;
   #endif
 	wonses=0;
	lostses=0;
   won=ReadRegistryInt(NamePlayer, "won",0);
	lost=ReadRegistryInt(NamePlayer, "lost",0);
	last=ReadRegistryInt(NamePlayer, "last",0);
	lastnumber=ReadRegistryInt(NamePlayer,"lastserie",0);
	wonrec=ReadRegistryInt(NamePlayer, "wonrec",0);
	lostrec=ReadRegistryInt(NamePlayer, "lostrec",0);
}


void TCardGame::SetupWindow()
{
	TWindow::SetupWindow();
	char buffer[MaxName];
   GetCurrentDirectory(MAX_PATH, StartDir);

   CheatField->Show(SW_HIDE);
   OkCheat->Show(SW_HIDE);
	Cheat=false;
   FirstTime=true;
   SendBt->Show(false);
  	SendBt->SetGlyph(new TBtnBitmap(*GetApplication(), SendBtn_On, TColor(0,255,0)));
  	SendBt->SetGlyph(new TBtnBitmap(*GetApplication(), SendBtn_Off, TColor(0,255,0)),T31Button::gtDown);
	ChangeBt->EnableWindow(false);
	PassBt->EnableWindow(false);
	ChgAllBt->EnableWindow(false);
	DealBt->EnableWindow(false);
	HoldBt->EnableWindow(false);
	SwitchBt->EnableWindow(false);
   #if defined(BI_PLAT_WIN32)
   strcpy(OptionName, ReadRegistryString("LastPlayer","LastPlayer1","",buffer,MaxName));
	#else
	GetPrivateProfileString("LastPlayer","LastPlayer1","",OptionName,MaxName, "31win.ini");
	#endif
   strcat(OptionName,"\\Options");

   SetSettings();

   AantalGames=0;
	PlayerTurn=false;
	ChooseSet=false;

	#if !defined (DenOudstenVersie)
	tooltip = new TTooltip(this);
   tooltip->Create();
	TRect rect(592,16,624,48);
	TToolInfo ti(*this, rect, ToolTipID1);
	tooltip->AddTool(ti);

	rect=TRect(30,174,131,277);
	ti=TToolInfo(*this, rect, ToolTipID2); //links
	tooltip->AddTool(ti);

	rect=TRect(270,15,371,118);
	ti=TToolInfo(*this, rect, ToolTipID3); //boven
	tooltip->AddTool(ti);

	rect=TRect(510,174,611,277);
	ti=TToolInfo(*this, rect, ToolTipID4); //rechts
	tooltip->AddTool(ti);

	rect=TRect(205,174,441,270);
	ti=TToolInfo(*this, rect, ToolTipID5); //pot
	tooltip->AddTool(ti);
   #endif

	CreateTimer();
   PostMessage(WM_USER, 0, 0);
}

bool TCardGame::EvEraseBkgnd(HDC hDC)
{
  	TDC dc(hDC);
  	dc.TextRect(GetClientRect(), TColor(0,128,0));

  	if (dc.GetDeviceCaps(BITSPIXEL)<=8)
   	{
      TDib BackPic(*GetApplication(), (TResId)BITMAP_35);
  		dc.SetDIBitsToDevice(TRect(205,162,231+205,126+162), TPoint(0,0), BackPic);
      }
   else
   	{
      TDib BackPic(*GetApplication(), (TResId)BITMAP_48);
  		dc.SetDIBitsToDevice(TRect(205,162,231+205,126+162), TPoint(0,0), BackPic);
      }

  #if defined(DenOudstenVersie)
  TDib BackPic(*GetApplication(), (TResId)DenOudsten);
  TPalette BackPicPal(BackPic);

  dc.SelectObject(BackPicPal);
  dc.RealizePalette();
  dc.SetDIBitsToDevice(TRect(448,2,182+448,143+2), TPoint(0,0), BackPic);

  dc.RestorePalette();
  #endif
  return true;
}

HBRUSH TCardGame::EvCtlColor(HDC hDC, HWND, UINT ctlType)
{
  switch (ctlType) {
    case CTLCOLOR_BTN:
      SetBkMode(hDC, TRANSPARENT);
		return (HBRUSH)GetStockObject(NULL_BRUSH);

	 case CTLCOLOR_STATIC:
		SetTextColor(hDC, TColor::Black);
		SetBkMode(hDC, TRANSPARENT);
		return (HBRUSH)kwast;
  }
	return NULL;
}

void TCardGame::ChangePlayer()
{
 	WriteRegistryInt(NamePlayer,"won",won);
	WriteRegistryInt(NamePlayer,"lost",lost);
	WriteRegistryInt(NamePlayer,"wonrec",wonrec);
	WriteRegistryInt(NamePlayer,"lostrec",lostrec);
	WriteRegistryInt(NamePlayer,"last",last);
	WriteRegistryInt(NamePlayer,"lastserie",lastnumber); 
	NewPlayer(0,0);
}

void TCardGame::Opties()
{
   memset(&OptieStruct, 0, sizeof(OptieStruct));

   SetCurrentDirectory(StartDir);

   strcpy(OptieStruct.PName1, Names[0]);
   strcpy(OptieStruct.PName2, Names[1]);
   strcpy(OptieStruct.PName3, Names[2]);
   strcpy(OptieStruct.PName4, Names[3]);

  	#if defined(BI_PLAT_WIN32)
	OptieStruct.SpeedBar.HighValue=3;
   OptieStruct.SpeedBar.LowValue=0;
	OptieStruct.SpeedBar.Position=sp;
   #else
	GetPrivateProfileString(OptionName, "Picture", "", OptieStruct.PFile, sizeof(OptieStruct.PFile), "31win.ini");
   OptieStruct.Slow=(sp==0) ? 1 : 0;
   OptieStruct.Medium=(sp==1) ? 1 : 0;
   OptieStruct.Fast=(sp==2) ? 1 : 0;
   #endif

   OptieStruct.SoundOn=OptieStruct.SoundOff=0;

	char string[50];
   VariationData VarData;
   VariationArray->ReadEntry(0, &VarData);

	strcpy(string, ReadRegistryString(OptionName, "GameType", VarData.VarName, string, 50));


   if (Sound) OptieStruct.SoundOn=1; else OptieStruct.SoundOff=1;

	TOptieDlg *pTDlg = new TOptieDlg(this,(engels ? OptionsDlgEN : OptionsDlgNL), engels, OptionName, OptieStruct, VariationArray);
   strcpy(pTDlg->VarSelName, string);
   pTDlg->Play=play;

  	if (pTDlg->Execute() == IDOK) {
		WriteRegistryString(OptionName, "Name1", OptieStruct.PName1);
		WriteRegistryString(OptionName, "Name2", OptieStruct.PName2);
		WriteRegistryString(OptionName, "Name3", OptieStruct.PName3);
		WriteRegistryString(OptionName, "Name4", OptieStruct.PName4);

  		#if defined(BI_PLAT_WIN32)
      sp=OptieStruct.SpeedBar.Position;
   	#else
   	if (OptieStruct.Slow==1) sp=0;
   	if (OptieStruct.Medium==1) sp=1;
   	if (OptieStruct.Fast==1) sp=2;
   	#endif
		WriteRegistryInt(OptionName,"Speed",sp);

		WriteRegistryString(OptionName, "GameType", pTDlg->VarSelName);
		WriteRegistryInt(OptionName,"Sound",1-OptieStruct.SoundOff);

      if (OptieStruct.SoundOn==1) Sound=true; else Sound=false;
   	UserAchterkant=((ReadRegistryInt(OptionName,"StandardBackside",0)==0) ? false : true);
		strcpy(Names[0],OptieStruct.PName1);
		strcpy(Names[1],OptieStruct.PName2);
		strcpy(Names[2],OptieStruct.PName3);
		strcpy(Names[3],OptieStruct.PName4);
      if (play)
      	{
  			ChangeBackSide();
         PaintCards();
         } 
	}
   delete pTDlg;
}

TResult TCardGame::NewPlayer(TParam1 id, TParam2)
{
   if (id==2)
   	{
      //::MessageBox(NULL,"test1","test",MB_OK);
      LoopFunction();
      }

	if (id==3)
   	{

      if (ReadRegistryInt(OptionName, "ShowStartDlg", 0)==0)
      	{
         WizardStruct.Single=1;
      	WizardStruct.Network=0;
         WizardStruct.Show=0;

			if (TWizardDlg(this,(engels ? StartWizardDlgEN : StartWizardDlgNL), WizardStruct).Execute()==IDOK)
      		{
         	if (WizardStruct.Single!=0) IdStart();
         	if (WizardStruct.Network!=0) SetupNetworkGame();
         	if (WizardStruct.Internet!=0) CmStartInternetGame();
				if (WizardStruct.Show) WriteRegistryInt(OptionName, "ShowStartDlg", 1);
         	}
         }
      }

   if (id==1)
   	{
      SendMessageToOthers();
      }

   if (id==0)
   	{
   #if defined(DenOudstenVersie)
  	if (FirstTime)
   	{
      IdAbout();
      FirstTime=false;
      }
	#endif
   if ((FirstTime) && (!TestRegistration()))
   	{
   	FirstTime=false;
      TOrderDlg(this, engels ? OrderDlgEN : OrderDlgNL, engels).Execute();
      }

	char buffer[MaxName],ComboNames[4][MaxName];
   bool Found=false;
   Cheat=false;
  	#if defined(BI_PLAT_WIN32)
      NameStruct.NameData.Clear();
      strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer1","",buffer,MaxName));
      NameStruct.NameData.AddString(buffer);
      strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer2","",buffer,MaxName));
      NameStruct.NameData.AddString(buffer);
      strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer3","",buffer,MaxName));
      NameStruct.NameData.AddString(buffer);
      strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer","",buffer,MaxName));
      NameStruct.NameData.SelectString(buffer);
	#else
	NameStruct.NameData.Clear();
	GetPrivateProfileString("LastPlayer", "LastPlayer1", "", buffer, MaxName, "31win.ini");
	NameStruct.NameData.AddString(buffer);
	GetPrivateProfileString("LastPlayer", "LastPlayer2", "", buffer, MaxName, "31win.ini");
	NameStruct.NameData.AddString(buffer);
	GetPrivateProfileString("LastPlayer", "LastPlayer3", "", buffer, MaxName, "31win.ini");
	NameStruct.NameData.AddString(buffer);
	GetPrivateProfileString("LastPlayer", "LastPlayer", "", buffer, MaxName, "31win.ini");
  	NameStruct.NameData.SelectString(buffer);
   #endif

  	if (TNameDlg(this,(engels ? Name_DlgEN : Name_DlgNL), NameStruct).Execute() == IDOK)
   {
      NameStruct.NameData.GetSelString(buffer,MaxName);
      strcpy(NamePlayer,buffer);
 	  	WriteRegistryString("LastPlayer","LastPlayer",NamePlayer);

   	#if defined(BI_PLAT_WIN32)
      strcpy(ComboNames[0], ReadRegistryString("LastPlayer","LastPlayer1","",ComboNames[0],MaxName));
      strcpy(ComboNames[1], ReadRegistryString("LastPlayer","LastPlayer2","",ComboNames[1],MaxName));
      strcpy(ComboNames[2], ReadRegistryString("LastPlayer","LastPlayer3","",ComboNames[2],MaxName));
		#else
		GetPrivateProfileString("LastPlayer","LastPlayer1","",ComboNames[0],MaxName, "31win.ini");
		GetPrivateProfileString("LastPlayer","LastPlayer2","",ComboNames[1],MaxName, "31win.ini");
		GetPrivateProfileString("LastPlayer","LastPlayer3","",ComboNames[2],MaxName, "31win.ini");
		#endif

      for (int i=0; i<3; i++)
      	{
         if (strcmp(NamePlayer, ComboNames[i])==0) Found=true;
         }

      if (!Found)
      	{
 	  		WriteRegistryString("LastPlayer","LastPlayer1",NamePlayer);
 	  		WriteRegistryString("LastPlayer","LastPlayer2",ComboNames[0]);
 	  		WriteRegistryString("LastPlayer","LastPlayer3",ComboNames[1]);
			}
      }
   strcpy(OptionName, NamePlayer);
   strcat(OptionName,"\\Options");
	SetSettings();
   PrintScoreName(NamePlayer,0);
   if (MessageDlg)
   	{
      strcpy(MessageDlg->PlayerName, NamePlayer);
      }
   PostMessage(WM_USER,3,0);

	}
   return true;
}

void TCardGame::PaintCards()
{
	TClientDC DC(*this);
	TMemoryDC bits(DC);
	for (int i=0; i<15; i++)
		{
		if (CardData[i*3]!=0)
			{
      	if (CardData[i*3+2]==33)
      		{
         	//bits.SelectObject(*AchterkantKaart);
            bool Pal=true;
            TPalette* CardPicPal;
            try
            	{
               CardPicPal= new TPalette(*AchterkantKaart);
            	}
            catch (...)
            	{
               Pal=false;
               }

            if (Pal)
            	{
               DC.SelectObject(*CardPicPal);
  					DC.RealizePalette();
            	}
  				DC.SetDIBitsToDevice(TRect(CardData[i*3],CardData[i*3+1],CardData[i*3]+71,CardData[i*3+1]+96), TPoint(0,0), *AchterkantKaart);
            if (Pal)
            	{
               DC.RestorePalette();
               delete CardPicPal;
               }
         	}
      	else
      		{
         	bits.SelectObject(*Cardbits[CardData[i*3+2]]);
				DC.BitBlt(CardData[i*3],CardData[i*3+1],71,96,bits,0,0,SRCCOPY);
         	}
			}
		}
}

void TCardGame::Paint(TDC&, bool, TRect&)
{
	PaintCards();
	PaintScoreRectangles();
	for (int i=0; i<4; i++)
		{
		PrintStreep(i,Part[i]);
   	}
	for (int i=0; i<4; i++)
		{
   	PrintStatus(i, Status[i]);
   	}
	PrintScoreName(NamePlayer, 0);
	PrintScoreName(Name1,1);
	PrintScoreName(Name2,2);
	PrintScoreName(Name3,3);

	PutGameTypeIcon();
}

void TCardGame::PrintStatus(int PlayNum, int Stat, bool Lost)
{
   // St=0: Leeg: St=1: Turn, St=2: Pass, St=32: 31)
   TClientDC WindowDC(*this);
   TMemoryDC bits(WindowDC);
	int x,y,w,h;
   char string[4];
   TRect TextRect;
   int dx=110;
   int dy=60;

   switch(PlayNum)
   	{
      case 0:  {x=445; y=320; TextRect = TRect(265, 335+18, 265+dx, 335+dy+18); break;}
      case 1:	{x=135; y=175; TextRect = TRect(25, 181+18, 25+dx, 181+dy+18); break;}
      case 2:  {x=235; y=15;	TextRect = TRect(265, 22+18, 265+dx, 22+dy+18); break;}
      case 3:  {x=475; y=175; TextRect = TRect(505, 181+18, 505+dx, 181+dy+18); break;}
      };

   if (Stat==-1) return;

   if (Stat==3)
   	{
     	WindowDC.FillRect(TextRect, TBrush(TColor(0,128,0)));
      return;
      }

   if (Status[PlayNum]!=0)
   	{
     	WindowDC.FillRect(x,y,x+30,y+17, TBrush(TColor(0,128,0)));
      }
   Status[PlayNum]=Stat;

	if (((Stat>6) && (Stat<34)))
   {
		if (Stat!=31) itoa(Stat,string,10);
   		else strcpy(string,"30");
      if (Stat==33) strcpy(string, "32");
      if (Stat==32) strcpy(string, "31");
      WindowDC.SetBkMode(TRANSPARENT);
		TPen	TekstKleur(TColor(255,0,0),1,PS_SOLID);
      TFont NaamFont("Arial", 60,0,0,0,FW_BOLD,DEFAULT_PITCH|FF_DONTCARE,true);


   	WindowDC.SelectObject(NaamFont);
		WindowDC.SetTextColor(TColor::LtGray);
      WindowDC.DrawText(string, -1, TextRect, DT_CENTER	| DT_VCENTER);

		if (!Lost)
      	{
         WindowDC.SetTextColor(TColor::Black);
         }
      else
      	{
         WindowDC.SetTextColor(TColor(128,0,0));
         }
      TextRect.Offset(-2,-2);
      WindowDC.DrawText(string, -1, TextRect, DT_CENTER	| DT_VCENTER);
   }
   else
   	{
      switch(Stat)
   		{
      	case 0:
      		{
         	return;
          	}
      	case 1:
      		{
         	bits.SelectObject(TBitmap(*GetApplication(),Turn));
         	x=x+10;
         	w=10;
         	h=10;
         	break;
         	}
      	case 2:
      		{
         	bits.SelectObject(TBitmap(*GetApplication(),BM_Pass));
         	x=x+5;
         	w=20;
         	h=16;
         	break;
         	}
      	}
   	WindowDC.BitBlt(x,y,w,h,bits,0,0,SRCCOPY);
      }
}

void TCardGame::ShowStats()
{
	int n;
	if ((lostses+wonses)!=0) n=(wonses*100)/(lostses+wonses); else n=0;
	itoa(n,StatStruct.SesPer,10);
	strcat(StatStruct.SesPer,"%");
	itoa(wonses,StatStruct.SesWon,10);
	itoa(lostses,StatStruct.SesLost,10);
	if ((lost+won)!=0) n=(won*100)/(lost+won); else n=0;
	itoa(n,StatStruct.TotPer,10);
	strcat(StatStruct.TotPer,"%");
	itoa(won,StatStruct.TotWon,10);
	itoa(lost,StatStruct.TotLost,10);
	itoa(wonrec,StatStruct.SerWon,10);
	itoa(lostrec,StatStruct.SerLost,10);
	char buffer[6];
   if (engels)
   	{
		if (last==0) strcpy(StatStruct.Serrow,"lost ");
			else
				strcpy(StatStruct.Serrow,"won ");
		itoa(lastnumber,buffer,10);
		strcat(StatStruct.Serrow,buffer);
		}
   else
   	{
		itoa(lastnumber,buffer,10);
		strcpy(StatStruct.Serrow,buffer);
		if (last==0) strcat(StatStruct.Serrow," verloren");
			else
				strcat(StatStruct.Serrow," gewonnen");
		}
	if (TStatDlg(this,(engels ? Stat_DlgEN : Stat_DlgNL), StatStruct).Execute()!=IDOK) {
	 switch(MessageBoxes(0)) {
		case IDYES:
			{
			wonses=0;lostses=0;lost=0;won=0;wonrec=0;lostrec=0;lastnumber=0;
			}
	 }
	}
}

void TCardGame::ChangeCard()
{
int n;

	if (!(ChangeBt->IsWindowEnabled())) return;

	if (Card1!=0)
		{
		if (Card2!=0)
			{
			n=Cards[Card1-1];
			Cards[Card1-1]=Cards[11+Card2];
			Cards[Card2+11]=n;
			RemoveCard(Card1-1);
			PrintPlayer();
			RemoveCard(11+Card2);
			PrintPot(0);
			InitButtons();
			#if defined(BI_PLAT_WIN32)
			if (TwoPlayer)
				{
            strcpy(WriteDataBlock,"PlChoice");
				WriteDataBlock[10]=1;
				WriteDataBlock[11]=(char)(Card1-1);
				WriteDataBlock[12]=(char)(Card2-1);
				if (Leider)
        		 	{
     		     	AckWriteAllPlayers();
    		     	}
    		   else
      			{
            	AckWriteBlock(0);
      		   }
				}
         #endif
			action[0]=15;
  			PostMessage(WM_USER,2,0);
			}
		}
}

void TCardGame::Pass()
{
	if (!(PassBt->IsWindowEnabled())) return;

	if (Card1!=0)
		{
		RemoveCard(Card1-1);
		PrintPlayer();
		}
	if (Card2!=0)
		{
		RemoveCard(11+Card2);
		PrintPot(0);
		}
   Pas[0]=true;
   PrintStatus(0,2);
	InitButtons();
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
			strcpy(WriteDataBlock,"PlChoice");
			WriteDataBlock[10]=3;
			WriteDataBlock[11]=0;
			WriteDataBlock[12]=0;
			if (Leider)
         	{
            AckWriteAllPlayers();
            }
         else
         	{
            AckWriteBlock(0);
            }
		}
   #endif
	action[0]=15;
   PostMessage(WM_USER,2,0);
}

void TCardGame::ChangeAll()
{
	int m;

	if (!(ChgAllBt->IsWindowEnabled())) return;

	for (int n=0; n<3; n++)
		{
		m=Cards[n];
		Cards[n]=Cards[n+12];
		Cards[n+12]=m;
		}
	if (Card1!=0)
		{
		RemoveCard(Card1-1);
		Card1=0;
		}
	PrintPlayer();
	if (Card2!=0)
		{
		RemoveCard(11+Card2);
      Card2=0;
		}
	PrintPot(0);
	if (Card1!=0)
		{
		RemoveCard(Card1-1);
		PrintPlayer();
		}
	if (Card2!=0)
		{
		RemoveCard(11+Card2);
		PrintPot(0);
		}
   Pas[0]=true;
   PrintStatus(0,2);
	InitButtons();
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
			strcpy(WriteDataBlock,"PlChoice");
			WriteDataBlock[10]=2;
			WriteDataBlock[11]=0;
			WriteDataBlock[12]=0;
			if (Leider)
         	{
            AckWriteAllPlayers();
            }
         else
         	{
            AckWriteBlock(0);
            }
		}
   #endif
	action[0]=15;
   PostMessage(WM_USER,2,0);
}

void TCardGame::Deal()
{
   SetYawn(false);
	if (!(DealBt->IsWindowEnabled())) return;

	DealBt->EnableWindow(false);
	Setup_New_Game();
}

void TCardGame::Hold2()
{
	if (!(HoldBt->IsWindowEnabled())) return;

	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
		strcpy(WriteDataBlock,"HandOrPot");
		strcat(WriteDataBlock,"H");
		if (!Leider)
      	{
         AckWriteBlock(0);
         }
      else
      	{
         AckWriteAllPlayers();
         }
		}
   #endif
	Hold();
}

void TCardGame::Hold()
{
	HoldBt->EnableWindow(false);
	SwitchBt->EnableWindow(false);
	PrintPot(0);
	ChooseSet=false;

	action[0]=1;

	if (GameStyle.OneTurnAfterPass)
   	{
   	for (int i=0; i<4; i++)
			{
			if ((Part[i]!=0) && (CalcPoints(i)>=32)) action[0]=4;
      	}
      }
   PostMessage(WM_USER,2,0);
}

void TCardGame::Switch()
{
	int m;

	if (!(SwitchBt->IsWindowEnabled())) return;

	for (int n=0; n<3; n++)
		{
		m=Cards[n];
		Cards[n]=Cards[n+12];
		Cards[n+12]=m;
		}
	PrintPlayer();
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
		strcpy(WriteDataBlock,"HandOrPot");
		strcat(WriteDataBlock,"P");
		if (!Leider)
      	{
         AckWriteBlock(0);
         }
      else
      	{
         AckWriteAllPlayers();
         }
		}
   #endif
	Hold();
}

void TCardGame::StartHelp()
{
  #if defined(BI_PLAT_WIN32)
  //HtmlHelp(HWindow, engels ? "31WIN-EN.CHM" : "31WIN-NL.CHM", HH_HELP_FINDER , 0);
  #endif
  #if defined(BI_PLAT_WIN16)
  WinHelp(engels ? "31WIN-EN.HLP" : "31WIN-NL.HLP",  HELP_INDEX, 0);
  #endif
}

void TCardGame::CeTurn(TCommandEnabler& ce)
{
  ce.Enable((PlayerTurn!=0) || (ChooseSet!=0));
}

void TCardGame::CeLevel(TCommandEnabler& ce)
{
  ce.Enable(!((play) || (starting)));
}

void TCardGame::CeStop(TCommandEnabler& ce)
{
	ce.Enable(play);
}
// Game Procedures

void TCardGame::ChangeBackSide()
{
	char buffer[10];
   delete AchterkantKaart;
	if (UserAchterkant)
   	{
      char name[MAX_PATH];
      bool Use=true;
      ffblk findblok;

   	#if defined(BI_PLAT_WIN32)
   	strcpy (name, ReadRegistryString(OptionName,"Picture","",name,sizeof(name)));
		#else
		GetPrivateProfileString(OptionName,"Picture","",name,sizeof(name), "31win.ini");
		#endif
      if (strlen(name)==0) Use=false;
      if (findfirst(name, &findblok, 0)!=0) Use=false;
      if (Use)
      	{
         TFile DibFile(name);
         DibFile.Read(buffer,2);
         buffer[2]=0;
         if (strcmp(buffer, "BM")!=0) Use=false;
         }

      if (!Use)
      	{
         MessageBoxes(9);
         #if defined(DenOudstenVersie)
      	AchterkantKaart= new TDib(*GetApplication(), (TResId)DenOudstenKaart);
         #else
      	AchterkantKaart= new TDib(*GetApplication(), (TResId)33);
         #endif
         }
      else
      	{
			AchterkantKaart=new TDib(name);
         }
      }
   else
   	{
      #if defined(DenOudstenVersie)
     	AchterkantKaart= new TDib(*GetApplication(), (TResId)DenOudstenKaart);
      #else
    	AchterkantKaart= new TDib(*GetApplication(), (TResId)33);
      #endif
      }
}

void TCardGame::IdStart()
{
   AantalGames++;
   if ((AantalGames>1) && (!TestRegistration()))
   	{
      TOrderDlg(this, engels ? OrderDlgEN : OrderDlgNL, engels).Execute();
      }
	time_t t;

   ChangeBackSide();

	deal=3;
	srand((unsigned) time(&t));
	play=true;
   IQuit=GameTerminated=Quit=final=Ezel[4]=false;
   KeepStat=((exp) && (!TwoPlayer));
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
		if (Leider)
			{
         if (bInternet) {
            //welke variatie gaan we spelen?
            //geldt alleen voor internet, bij Network spel is deze info
            //al uitgewisseld
            char string[50];
            VariationData VarData;
            VariationArray->ReadEntry(0, &GameStyle);
            strcpy(string, ReadRegistryString(OptionName, "GameType", GameStyle.VarName, string, 50));

            for (int n=0; n<VariationArray->nUsed; n++)
               {
               VariationArray->ReadEntry(n, &VarData);
               if (strcmp(VarData.VarName, string)==0)
                  {
                  VariationArray->ReadEntry(n, &GameStyle);
                  }
               }

            for (int i=1; i<4; i++)
               {
					strcpy(WriteDataBlock,"GameType....");
           		memcpy(WriteDataBlock+12, &GameStyle, sizeof(VariationData));
               AckWritePlayer(i);
               }
         	}


         deal = random(4);
         for (int i=1; i<4; i++)
         	{
				strcpy(WriteDataBlock,"DealTurn");
				WriteDataBlock[9]=(char)Omrekenen(deal,i);
            WriteDataBlock[10]=(char)Omrekenen(0,i);
				AckWritePlayer(i);
            HostNumber=0;
            }
			}
		else
			{
			if (bInternet) {
            AckReadBlock("GameType....");
            memcpy(&GameStyle, ReadDataBlock+12, sizeof(VariationData));
         	}


         AckReadBlock("DealTurn");
			deal=0;
			if (!GameTerminated)
         	{
            deal=ReadDataBlock[9];
            HostNumber=ReadDataBlock[10];
            }
			}
		}
   else
   #endif			// geen twee-speler spel
   	{
  		VariationArray->ReadEntry(0, &GameStyle);
      VariationData VarData;
		char string[50];
		strcpy(string, ReadRegistryString(OptionName, "GameType", GameStyle.VarName, string, 50));

		for (int n=0; n<VariationArray->nUsed; n++)
      	{
         VariationArray->ReadEntry(n, &VarData);
         if (strcmp(VarData.VarName, string)==0)
         	{
            VariationArray->ReadEntry(n, &GameStyle);
            }
         }
      }
   GameTypeIcon=1;
   PutGameTypeIcon();



	RemoveCardsOnTable();

	for (int n=0; n<32; n++)
		CardPack[n]=n+1;

	for (int n=0; n<4 ; n++)
		{
      Ezel[n]=false;
      Pas[n]=false;
		Part[n]=(GameStyle.NumberOfMarks);
     // Part[n]=1;
 		PrintStreep(n,Part[n]);
		PrintStatus(n,0);
		}

   PrintName(NamePlayer,0);
   MakeNameList();

	DealBt->EnableWindow(true);
   SetYawn(true);
   PostMessage(WM_USER,2,0);
}

int TCardGame::Omrekenen(int i, int s)
{
// omrekenen getal i naar speler s
	return ((i+4-s)%4);
}

void TCardGame::TerminateGame()
{
char mem=action[0];

	 action[0]=0;

	 switch(MessageBoxes(1)) {
		case IDNO:
			{
			action[0]=mem;
         break;
			}

		case IDYES:
			{
			#if defined(BI_PLAT_WIN32)
         if (TwoPlayer)
         	{
         	GameTerminated=true;
            IQuit=true;
            strcpy(WriteDataBlock,"GameEnd");
            if (Leider)
            	{
               for (int i=1; i<4; i++)
               	{
                  if (HumanPl[i])
                  	{
                     strcpy(OpponentName, CNames[i]);
               		WriteBlock(i);
                     }
               	}
               }
            else
            	{
               WriteBlock(0);
               }
         	}
         #endif
 			ResetGame();
         break;
			}
	 }
}

void TCardGame::Reset2Game()
{
   IQuit=true;
   GameTerminated=true;
	ResetGame();
}


void TCardGame::ResetGame()
{
	if (KeepStat) UpdateLostIni();
	play=PlayerTurn=ChooseSet=false;
   EndTwoPlayer();
	ChooseSet=false;
	ChangeBt->EnableWindow(false);
	PassBt->EnableWindow(false);
	ChgAllBt->EnableWindow(false);
	DealBt->EnableWindow(false);
	HoldBt->EnableWindow(false);
	SwitchBt->EnableWindow(false);
	Quit=true;
   EndKnipper();
}

void TCardGame::Setup_New_Game()
{

	stop=false;
   EndKnipper();
   AantalTurns=NormalTurn=0;

	Dealplayers();
	RemoveCardsOnTable();
	if (GameTerminated)
   	{
      MessageBoxes(Leider ? 2 : 12);
      Reset2Game();
      return;
      }

   for (int n=0; n<4; n++)
   	{
      PrintStatus(n,3);
		Status[n]=-1;
      Pas[n]=false;
      if (Part[n]==0) PrintName("",n,true);
      }

	// Hand of Pot Kiezen na het delen door Speler of Computer

	do {
		deal++;
		if (deal>3) deal=0;
		}
		while (Part[deal]==0);

	turn=deal;

	AnimateDeal();
   

   if (!Quit)   // voor als delen onderbroken wordt...
   	{
		if (turn!=0)
			{
      	PrintStatus(turn, 1);
			ChooseHandOrPot(turn);
			Hold();
			}
		else
			{
      	PrintStatus(turn, 1);
      	ChooseSet=true;
			HoldBt->EnableWindow(true);
			SwitchBt->EnableWindow(true);
      	SetYawn(true);
			}
   	}

}

// DealPlayers: Schud de kaarten en deel ze uit

void TCardGame::Dealplayers()
{
	int a=32,CardPack2[32];
	int kn,c,o,m;
	time_t t;

if ((TwoPlayer) && (!Leider))
	{
	#if defined(BI_PLAT_WIN32)
   AckReadBlock("Cards");

 	for (m=0; m<15; m++)
		{
		Cards[m]=ReadDataBlock[m+5];
		}
   #endif
	}
else
	{
	srand((unsigned) time(&t));

	for (m=0; m<32; m++)
		{
		kn = random(a); // generates 0 to a-1 (max 31)
		CardPack2[m]=CardPack[kn];

		for (o=kn; o<a; o++)
			{
			CardPack[o]=CardPack[o+1];
			}
		a--;
	}

	for (m=0; m<32; m++)
		{
		CardPack[m]=CardPack2[m];
		}

	a=32;
	for (m=0; m<15; m++)
		{
		kn = random(a); // generates 0 to a-1 (max 31)
		c=(((m+1)*3)%15)+m/5;
		Cards[c]=CardPack2[kn];
		Color[(Cards[c]-1)/8]++;
		for (o=kn; o<a; o++)
			{
			CardPack2[o]=CardPack2[o+1];
			}
		a--;
		}
/*   Cards[0]=1;
   Cards[1]=5;
   Cards[2]=10;

   Cards[3]=1;
   Cards[4]=5;
   Cards[5]=10; */
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer && Leider)
		{
      for (int i=1; i<4; i++)
      	{
         if (HumanPl[i])
         	{
            strcpy(WriteDataBlock,"Cards");
				for (m=0; m<4; m++)
					{
               for(int ii=0; ii<3; ii++)
               	{
						WriteDataBlock[m*3+ii+5]=(char)Cards[((i+m)%4)*3+ii];
                  }
					}
				for (m=0; m<3; m++)
					{
					WriteDataBlock[m+17]=(char)Cards[m+12];
					}
				AckWritePlayer(i);
            }
         }
		}
   #endif
	}
}

void TCardGame::ChooseHandOrPot(int n)
{
	int l;

	if (!TwoPlayer)
		{
		l=ChooseHandOrPotAction(n);
		}
	#if defined(BI_PLAT_WIN32)
	else
		{
		if ((Leider) && (!HumanPl[turn]))
			{
			l=ChooseHandOrPotAction(n);
			strcpy(WriteDataBlock,"HandOrPot");
			if (l==1)
				{
				strcat(WriteDataBlock,"P");
				}
			else
				{
				strcat(WriteDataBlock,"H");
				}
			AckWriteAllPlayers();
			}
		else
      	{
         AckReadBlock("HandOrPot", turn);
			if (ReadDataBlock[9]==72) l=0; else l=1;
         if (Leider)
         	{
            strcpy(WriteDataBlock,"HandOrPot");
            strcat(WriteDataBlock, (l==1) ? "P" : "H");
            for (int i=1; i<4; i++)
            	{
               if ((HumanPl[i]) && (turn!=i)) AckWritePlayer(i);
               }
            }
			}
		}
   #endif

	if (l==1)
	{
	for (int i=0; i<3; i++)
		{
		l=Cards[(n*3)+i];
		Cards[(n*3)+i]=Cards[i+12];
		Cards[i+12]=l;
		}
	}
}

int TCardGame::ChooseHandOrPotAction(int n)
{
int h=CalcPoints(n);
int Kl[3],Wa[3],i,l;

//if (n==1) return 0;

if (h>=19) goto label_end;

for (i=0; i<3; i++)
	{
	Kl[i]=(Cards[(n*3)+i]-1)/8;
	Wa[i]=((Cards[(n*3)+i]-1)%8)+7;
	}

if (((Wa[0]==Wa[1]) || (Wa[1]==Wa[2]) || (Wa[0]==Wa[2])) && (h>17))
	{
	goto label_end;
	}

	l=5;
for (i=0; i<4; i++)
	{
	if ((Part[i]!=0) && (l>Part[i])) l=Part[i];
	}

if (l+2<Part[n])
	{
	if (((Wa[0]==14)&&(Wa[1]==14)) || ((Wa[1]==14)&&(Wa[2]==14))
		|| ((Wa[0]==14)&&(Wa[2]==14))) goto label_end;
	}

return 1;

label_end:
return 0;
}

// Bereken de waarde in de hand van speler n
//  (0=Speler, 4=Pot)
//  31=30 en een half, 32=31, 33=fire (3xAas)

int TCardGame::CalcPoints(int n)
{
int Kleur[3],Waarde[3],w;

for (int i=0; i<3; i++)
	{
	Kleur[i]=(Cards[(n*3)+i]-1)/8;
	Waarde[i]=((Cards[(n*3)+i]-1)%8)+7;
	if (Waarde[i]==14)
		{
		Waarde[i]=11;
		}
	else
		{
		if (Waarde[i]>10)
			{
			Waarde[i]=10;
			}
		}
	}

if ((Kleur[0]!=Kleur[1]) && (Kleur[1]!=Kleur[2]) && (Kleur[0]!=Kleur[2]))
	{
	if ((((Cards[n*3]-1)%8)==((Cards[(n*3)+1]-1)%8)) && (((Cards[(n*3)+1]-1)%8)==((Cards[(n*3)+2]-1)%8)))
		{
		if ((GameStyle.Fire) && (Waarde[0]==11))
      	{
         return 33;
         }
      else
      	{
         return 31;
         }
		}
	else
		{
		w=Waarde[0];
		for (int i=1; i<3; i++)
			{
			if (w<Waarde[i]) w=Waarde[i];
			}
		return w;
		}
	}
else
	{
	if ((Kleur[0]!=Kleur[1]) && (Kleur[0]!=Kleur[2]))
		{
		return Waarde[1]+Waarde[2];
		}
	else
		{
		w=Waarde[0];
		for (int i=1; i<3; i++)
			{
			if (Kleur[0]==Kleur[i])
				{
				w=w+Waarde[i];
				}
			}
		if (w==31) w=32;
		return w;
		}
	}
}

// Geef kleur van hoogste kaart terug.
//  (0=Speler, 4=Pot)
//  31=30 en een half, 32=31, 33=fire (3xAas)

int TCardGame::GetHighSkat(int n)
{
int Kleur[3],Waarde[3],w,k;

for (int i=0; i<3; i++)
	{
	Kleur[i]=(Cards[(n*3)+i]-1)/8;
	Waarde[i]=((Cards[(n*3)+i]-1)%8)+7;
	if (Waarde[i]==14)
		{
		Waarde[i]=11;
		}
	else
		{
		if (Waarde[i]>10)
			{
			Waarde[i]=10;
			}
		}
	}

if ((Kleur[0]!=Kleur[1]) && (Kleur[1]!=Kleur[2]) && (Kleur[0]!=Kleur[2]))
	{
	// Alle Kleuren verschillend, 1 hoogste kaart.
	w=Waarde[0];
   k=0;
	for (int i=1; i<3; i++)
		{
		if (w<Waarde[i])
        	{
         w=Waarde[i];
         k=i;
         }
		}
   return Kleur[k];
	}
else
	{
   // Niet alle kleuren verschillend

   // Kleur 0 valt buiten de boot.
	if ((Kleur[0]!=Kleur[1]) && (Kleur[0]!=Kleur[2]))
		{
		return Kleur[1];
		}
	else
		{
      // Kleur 0 hoort bij de hoogste score
      return Kleur [0];
		}
	}
}

// Plaats Streepjes in vakjes (n=speler, i=aantal streepjes);

void TCardGame::PrintStreep(int n, int i, bool ShowEzel)
{
	TClientDC dc(*this);
	int m,k;

   k=GameStyle.NumberOfMarks;

	TMemoryDC bits(dc);
	for (int j=0; j<(k-i); j++)
     	{
      m=3-k+j;
      if (m<0) m=0;
     	bits.SelectObject(*MarkBtm[m]);
      dc.BitBlt(133+j*9, 26+(n*20), 8, 8, bits, 0, 0, SRCCOPY);
      }
	for (int j=(k-i); j<k; j++)
     	{
		TBrush WhiteBrush(TColor(255,255,255));
      dc.FillRect(133+j*9, 26+(n*20), 141+j*9, 34+(n*20), WhiteBrush);
      }

   if (GameStyle.BonusMark)
      {
      if ((ShowEzel) && (Ezel[4]) && (Ezel[n]))
   		{
     		bits.SelectObject(*MarkBtm[3]);
      	dc.BitBlt(133+3*9, 26+(n*20), 8, 8, bits, 0, 0, SRCCOPY);
      	}
   	else
   		{
			TBrush WhiteBrush(TColor(255,255,255));
      	dc.FillRect(133+3*9, 26+(n*20), 141+3*9, 34+(n*20), WhiteBrush);
			}
      }
}

void TCardGame::InitButtons()
{
	ChangeBt->EnableWindow(false);
	PassBt->EnableWindow(false);
	ChgAllBt->EnableWindow(false);
	HoldBt->EnableWindow(false);
	SwitchBt->EnableWindow(false);
   GetApplication()->PumpWaitingMessages();
	PlayerTurn=false;
}

// Computerspeler denkt en maakt keuze
// 1=wissel kaart, 2=wissel allen en 3=passen
// action[4]=wissel kaart uit hand
// action[5]=wissel kaart uit pot
int TCardGame::ComputerAction()
{
int h,y,i,j,k,c1=1,c2=1,n=turn,Kl[3],Wa[3],Kl2[3],Wa2[3],a,b,c,d,h3;
int h1=CalcPoints(turn),h2=CalcPoints(4),Ka[3],Ka2[3],z;
bool Novice,Advanced,Expert,Gepast;

/*if (turn==1)
	{
   k=3;
   goto End_ComputerAction;
   }  */

if (AantalTurns==5)
	{
   k=3;
   goto End_ComputerAction;
   }

Gepast=((Pas[0] || Pas[1] || Pas[2] || Pas[3]) && (GameStyle.OneTurnAfterPass));
if (!TwoPlayer)
	{
	Novice=nov;
	Advanced=adv;
	Expert=exp;
	}
else
	{
	Novice=false;
	Advanced=false;
	Expert=true;
	}

if (h2>=32)
	{
	k=2;
	goto End_ComputerAction;
	}

for (i=0; i<3; i++)
	{
	Kl[i]=(Cards[(n*3)+i]-1)/8;
	Kl2[i]=(Cards[12+i]-1)/8;
	Ka[i]=((Cards[(n*3)+i]-1)%8)+7;
	Ka2[i]=((Cards[12+i]-1)%8)+7;
	Wa[i]=Ka[i];
	Wa2[i]=Ka2[i];
	if (Ka[i]>=10)
		{
		if (Ka[i]!=14) Wa[i]=10; else Wa[i]=11;
		}
	if (Ka2[i]>=10)
		{
		if (Ka2[i]!=14) Wa2[i]=10; else Wa2[i]=11;
		}
	}

// Kijken of 31 mogelijk is met 1 kaart wisselen.

if (!Novice)
	{
	if ((Kl[0]==Kl[1]) | (Kl[1]==Kl[2]) | (Kl[0]==Kl[2]))
		{
		if (Kl[0]==Kl[1])
			{b=Kl[0];} else {b=Kl[1];}
		h3=0;
		a=0;
		for (i=0; i<3; i++)
			{
			if ((Ka[i]==14) && (Kl[i]==b)) a=1;
			if ((Ka2[i]==14) && (Kl2[i]==b)) a=1;
			if (Kl[i]==b) h3=h3+Wa[i];
			if (Kl2[i]==b) h3=h3+Wa2[i];
			}
		if ((h3>30) && (h1>19) && (a==1))
			{
			a=0;
			c=20;
			if ((Kl[0]==Kl[1]) && (Kl[1]==Kl[2]))
				{
				for (i=0; i<3; i++)
					{
					if (c>Wa[i])
						{
						c=Wa[i];
						a=i;
						}
					}
				if ((h1-c)<20) goto Geen_31;
				c1=a;
				for (i=0; i<3; i++)
					{
					if (((h1-c)+Wa2[i]==31) && (Kl2[i]==b))
						{
						c2=i;
						k=1;
						goto End_ComputerAction;
						}
					}
				}
			else
				{
				if (h1<20) goto Geen_31;
				for (i=0; i<3; i++)
					{
					if (Kl[i]!=b) c1=i;
					}
				for (i=0; i<3; i++)
					{
					if ((h1+Wa2[i]==31) && (Kl2[i]==b))
						{
						c2=i;
						k=1;
						goto End_ComputerAction;
						}
					}
				}
			}
		}
	}

Geen_31:
if (h1==31)
	{
	if ((h2==31) && (Ka[0]<Ka2[0]) && (!Novice))
		{
		k=2;
		goto End_ComputerAction;
		}
	else
		{
		k=3;
		goto End_ComputerAction;
		}
	}

//k=1;   /* Kijken of 30.5 mogelijk is */

if (Ka[0]==Ka[1])
	{
	k=1;
	c1=2;
	c2=Wa_Aanwezig(Ka[0],Ka2);
	if (c2!=3) goto End_ComputerAction;
	}

if (Ka[2]==Ka[1])
	{
	k=1;
	c1=0;
	c2=Wa_Aanwezig(Ka[1],Ka2);
	if (c2!=3) goto End_ComputerAction;
	}

if (Ka[0]==Ka[2])
	{
	k=1;
	c1=1;
	c2=Wa_Aanwezig(Ka[0],Ka2);
	if (c2!=3) goto End_ComputerAction;
	}

if ((h2>29) && (h1<h2) && (!Novice))
	{
	k=2;
	goto End_ComputerAction;
	}


/* Drie verschillende kleuren in handen */
if ((Kl[0]!=Kl[1]) && (Kl[1]!=Kl[2]) && (Kl[0]!=Kl[2]))
	{
	if ((Kl2[0]==Kl2[1]) && (Kl2[1]==Kl2[2]))
		{
		k=2;
		goto End_ComputerAction;
		}
	else
		{
		a=0;
		b=0;
		c=0;
		k=1;
		for (i=0; i<3; i++)
			{
			for (j=0; j<3; j++)
				{
			if (!Expert)
					{
					if ((Kl[i]==Kl2[j]) && (Wa[i]+Wa2[j]>c))
						{
						c=Wa[i]+Wa2[j];
						h=i;
						a=(i+1)%3;
						b=j;
						}
					}

				if ((Kl[i]==Kl2[j]) && (Expert))
					{
					if (Wa[i]+Wa2[j]>c)
						{
						c=Wa[i]+Wa2[j];
						b=j;
						z=20;
						h3=30;
						for (int y=0; y<3; y++)
							{
							if (((Ka[y]<z) || (Ka[y]==Ka[i])) && (y!=i))
								{
								if (Ka[y]==Ka[i])
									{
									h3=y;
									}
								else
									{
									a=y;
									z=Ka[y];
									}
								}
							}
						if (Ka2[j]==Ka[a])
							{
							if ((h3!=30) && ((Ka2[j]<Ka[h3]) || (Ka2[j]==14))) a=h3;
							else
								{
								if (h3==30)
									{
									y=a;
									for (z=0; z<3; z++)
										{
										if ((z!=i) && (z!=y)) a=z;
										}
									}
								}
							}
						else
							{
							if (h3!=30)
								{
								for (z=0; z<3; z++)
									{
									if ((z!=i) && (z!=h3)) a=z;
									}
								}
							}
						}
					}
				}
			}

		if ((h2>c) && (Gepast) && (!Novice))
			{
			k=2;
			goto End_ComputerAction;
			}
		if ((Expert) && (Gepast))
			{
			if (((Ka2[(b+1)%3]==Ka[c1]) && (Ka2[(b+2)%3]==Ka[c1])) ||
			((Kl2[(b+1)%3]==Kl[c1]) && (Kl2[(b+2)%3]==Kl[c1])))
					{
					for (i=0; i<3; i++)
						{
						if ((i!=h) && (i!=c1)) a=i;
						}
					}
			}
		}
	c1=a;
	c2=b;
	goto End_ComputerAction;
	}

/* Bepaal laagste kaart in hand */
a=0; /* Laagste Kaart */
b=0; /* Kleur Laagste Kaart */
if ((Kl[0]==Kl[1]) && (Kl[1]==Kl[2]))
	{
	b=Kl[0];
	for (i=1; i<3; i++)
		{
		if (Ka[a]>Ka[i]) a=i;
		}
	goto HoogsteKaart;
	}
if (Kl[0]==Kl[1])
	{
	a=2;
	b=Kl[0];
	}
if (Kl[0]==Kl[2])
	{
	a=1;
	b=Kl[0];
	}
if (Kl[2]==Kl[1])
	{
	a=0;
	b=Kl[1];
	}

/* Bepaal hoogste kaart uit pot */
HoogsteKaart:
c=0;
d=0;
for (i=0; i<3; i++)
	{
	if (Kl2[i]==b)
		{
		if (Ka2[i]>d)
			{
			d=Ka2[i];
			c=i;
			}
		}
	}

/* Bepalen wat de doen met hiervoor verzamelde informatie */

if ((Kl2[c]==b) && (Kl2[c]==Kl[a]) && (Wa2[c]<=Wa[a]))
	{
	k=3;
	goto End_ComputerAction;
	}
if (Kl2[c]==b)
	{
	if (Kl[a]==b) h3=h1-Wa[a]+Wa2[c]; else h3=h1+Wa2[c];
	if (h3<h2)
		{
		k=2;
		goto End_ComputerAction;
		}
	else
		{
		c1=a;
		c2=c;
		k=1;
		goto End_ComputerAction;
		}
	}
if ((Kl2[c]!=b) && (Gepast) && (!Novice))
	{
	h3=Wa[a];
	for (i=0; i<3; i++)
		{
		if ((Kl2[i]==Kl[a]) && (h3<Wa2[i]+Wa[a]))
			{
			h3=Wa2[i]+Wa[a];
			c1=(a+1)%3;
			c2=i;
			}
		}
	k=3;
	if ((h3>h2) && (h3>h1))
		{
		if ((Ka2[(c2+1)%3]==Ka[c1]) && (Ka2[(c2+2)%3]==Ka[c1]) && (Expert))
			{
			c1=(a+2)%3;
			}
		k=1;
		}
	if ((h2>h1) && (h2>=h3)) k=2;
	goto End_ComputerAction;
	}

if ((Kl2[c]!=b) && (h1>23) && (h2>h1))
	{
	k=2;
	goto End_ComputerAction;
	}
if ((Kl2[c]!=b) && (h1>23))
	{
	k=3;
	goto End_ComputerAction;
	}
if ((Kl2[c]!=b) && (h2>h1) && (h2>=25))
	{
	k=2;
	goto End_ComputerAction;
	}


if (Novice)
	{
	k=1;
	c1=a;
	c2=c;
	goto End_ComputerAction;
	}

if (Advanced)
	{
	k=1;
	c1=a;
	c2=c;
	for (i=0; i<3; i++)
		{
		if (Ka2[i]==Ka[(b+1)%3]) c2=i;
		if (Ka2[i]==Ka[(b+2)%3]) c2=i;
		}
	goto End_ComputerAction;
	}

	h3=Wa[a];
	for (i=0; i<3; i++)
		{
		if ((Kl2[i]==Kl[a]) && (h3<Wa2[i]+Wa[a]))
			{
			h3=Wa2[i]+Wa[a];
			c1=(a+1)%3;
			if (Ka[c1]==Ka[a])
				{
				if ((Ka[(c1+1)%3]==Ka2[i]) && ((Ka2[i]<Ka[a]) || (Ka[a]==14)))
					c1=c1;
					else
					c1=(c1+1)%3;
				}
			c2=i;
			}
		}
	if (h3>h1)
		{
		k=1;
		goto End_ComputerAction;
		}
	if ((h3==h1) && ((Kl2[c2]==Kl2[(c2+1)%3]) || (Kl2[c2]==Kl2[(c2+2)%3])))
		{
		k=1;
		goto End_ComputerAction;
		}


	k=1;
	c1=a;
	h3=0;
	for (i=0; i<3; i++)
		{
		if (h3<Ka2[i])
			{
			c2=i;
			h3=Ka2[i];
			}
		}

	h3=100;
	for (i=0; i<3; i++)
		{
		for (j=0; j<3; j++)
			{
			if ((Ka[i]==Ka2[j]) && (i!=c1))
				{
				if (((Ka[i]<h3) && (h3!=14)) | (Ka[i]==14))
					{
					h3=Ka[i];
					c2=j;
					}
				}
			}
		}

End_ComputerAction:
	action[4]=(char)c1;
	action[5]=(char)c2;
	return k;
}

int TCardGame::Wa_Aanwezig(int W, int W2[3])
{
int z=3;

for (int i=0; i<3; i++)
	{
	if (W==W2[i]) z=i;
	}
return z;
}

void TCardGame::SetYawn(bool on)
{
   Yawn=on;
	YawnTeller=0;
}

void TCardGame::DoPlayerChoice() {

	//action array is ingesteld voordat deze functie wordt aangeroepen.
   if ((action[1]==1) && (!GameTerminated))
    	{
     	AnimateSwitchCard(205+80*action[5],174,action[5],turn);
     	action[0]=3;
       }
   if ((action[1]==2) && (!GameTerminated))
     	{
     	AnimateSwitchPot(turn);
     	action[0]=3;
     	}
  	if ((action[1]==3) && (!GameTerminated))
  		{
      Pas[turn]=true;
		PrintStatus(turn,2);
		action[0]=3;
		}
	}

// LoopFunction

void TCardGame::LoopFunction()
{
int w,i,l,a,pnt[4];

//while ((play) && (!Quit) && (!GameTerminated))
if ((play) && (!Quit) && (!GameTerminated))
{
if (action[0]==0) return ; //goto End_Loop;

// Action 1: Speler maakt keuze
if ((action[0]==1) && (CalcPoints(turn)>=32) && (Part[turn]!=0))
	{
	action[0]=4;
	}

if (action[0]==1)
	{
   if (Status[turn]==1) PrintStatus(turn,0);

	turn++;
	if (turn==4)
     {
     turn=0;
     //beperk het aantal acties van de computerspelers als de menselijke
     //speler eruit is. Geen oneindige loop er in!
     if ((!GameStyle.OneTurnAfterPass) && (Pas[0])) AantalTurns++;
     }

	if ((!GameStyle.OneTurnAfterPass) && (CalcPoints(turn)>=32) && (Part[turn]!=0))
		{
		action[0]=4;
      goto End_Loop;
		}

	if ((Pas[turn]) && (GameStyle.OneTurnAfterPass))  // bepalen bij tough-game of het spel teneinde is
		{
		action[0]=4;
		goto End_Loop;
		}
	if ((turn!=0) && (Part[turn]!=0) && (!Pas[turn]))
		{
		action[0]=0;
		PrintStatus(turn, 1);

		if (!TwoPlayer)
   		{
			action[1]=(char)ComputerAction();
         action[2]=0;
         action[3]=0;
         action[0]=2;
         DoPlayerChoice();
			}
		#if defined(BI_PLAT_WIN32)
		else
			{
         if ((Leider) && (!HumanPl[turn]))
            {
            action[1]=(char)ComputerAction();
            strcpy(WriteDataBlock,"PlChoice");
            WriteDataBlock[10]=action[1];
            WriteDataBlock[11]=action[4];
            WriteDataBlock[12]=action[5];
            AckWriteAllPlayers();
            action[2]=0;
            action[3]=0;
            action[0]=2;
            DoPlayerChoice();
            }
         else
            {
            //if (!bInternet) {
               AckReadBlock("PlChoice", turn);
               action[1]=ReadDataBlock[10];
               action[4]=ReadDataBlock[11];
               action[5]=ReadDataBlock[12];
               if (Leider)
                  {
                  strcpy(WriteDataBlock, "PlChoice");
                  WriteDataBlock[10]=ReadDataBlock[10];
                  WriteDataBlock[11]=ReadDataBlock[11];
                  WriteDataBlock[12]=ReadDataBlock[12];
                  for (int i=1; i<4; i++)
                     {
                     if ((HumanPl[i]) && (i!=turn)) AckWritePlayer(i);
                     }
                  }
               action[2]=0;
               action[3]=0;
               action[0]=2;
               DoPlayerChoice();
            //   }
            //else {
            //   bWaitForPlChoice=true;
            //	}
            }
			}
      #endif
		}
	else
		{
		if ((turn==0) && (Part[turn]!=0) && (!Pas[turn]))
			{
         PrintStatus(turn,1);
			PlayerTurn=true;
			Card1=0;
			Card2=0;
			ChangeBt->EnableWindow(false);
			PassBt->EnableWindow(true);
			ChgAllBt->EnableWindow(true);
         SetYawn(true);
			action[0]=0;
			}
		}
	goto End_Loop;
	}

// Aktie 3 Afhandelen actie computerspeler

if (action[0]==3)
	{
	PrintPot(0);
	action[0]=1;
	if (CalcPoints(turn)>=32) action[0]=4;
	goto End_Loop;
	}


// Aktie 4 Einde Spel

if (action[0]==4)
	{
	action[0]=0;
	PrintApponents(0);
	for (i=12; i<15; i++)
		{
		RemoveCard(i);
		}

   bool High31=false;
   bool Fire=false;

	for (i=0; i<4; i++)
		{
		if (Part[i]!=0)
			{
			pnt[i]=CalcPoints(i);
			if (pnt[i]>=32) High31=true;
         if (pnt[i]==33) Fire=true;
//			PrintStatus(i,pnt[i]);
			}
		}


	if ((High31) && (Sound) && (Sound31))
   	{
  		Sound31->Play(MCI_NOTIFY);
      }

		/* Bepalen wie een streepje krijgt */

		l=10000;
		a=0;

		for (i=0; i<4; i++)
			{
         pnt[i]=pnt[i]*52;

			if ((pnt[i]==31*52) && (GameStyle.NeverTieWithLowest31))
         	{
            pnt[i]=pnt[i]+(((Cards[(i*3)]-1)%8)+7);
            }

			if ((pnt[i]<31*52) && (GameStyle.NeverTieWithLowestHand))
         	{
            //Bepalen welke kaart het hoogst is in de hand.
            // Van hoog naar laag: Klaver, Schoppen, Harten, Ruiten
            pnt[i]=pnt[i]+GetHighSkat(i);
            }
			}


		for (i=0; i<4; i++)
			{
			if (Part[i]!=0)
				{
				a++;
				if (pnt[i]<l)
					{
					l=pnt[i];
					}
				}
			}

		w=a;

         for (i=0; i<4; i++)
				{
				if (Part[i]!=0) PrintStatus(i, CalcPoints(i), (pnt[i]==l));
				if ((Part[i]!=0) && (pnt[i]==l))
					{
					if (Part[i]==1) a--;
					}
            }

		if ((!GameStyle.AlwaysAWinner) ||
      		((a!=0) && (GameStyle.AlwaysAWinner))) // a mag niet nul worden->Anders geen speler meer over
			{
			Ezel[5]=false;
         for (i=0; i<4; i++)
				{
            KnipperStreep[i]=false;

 				if (((Part[i]!=0) && (pnt[i]==l)) ||
               ((GameStyle.Fire) && (GameStyle.FireEveryOneLoses) && (Fire) && Part[i]!=0 && (pnt[i]!=33*52)))
					{
               if ((GameStyle.BonusMark) && (!Ezel[4]) && (Part[i]==1))
               	{
                  Ezel[i]=true;
                  Ezel[5]=true; // er mag nu worden geknipperd
                  }
               else
               	{
                  Part[i]--;
						KnipperStreep[i]=true;
                  }
					}
				}
			Teller=9;
   		KnipperStatus=0;
   		Knipper=true;
			if ((Ezel[0]) || (Ezel[1]) || (Ezel[2]) || (Ezel[3])) Ezel[4]=true;

         a=0;
         for (int i=0; i<4; i++)
         	{
            if (Part[i]!=0) a++;
            }
			}
      else
			{
			a=w;
			}

      if ((TwoPlayer) && (Part[HostNumber]==0) && (!bInternet))  // change Host!!! He is outty.
      	{
         if (Leider)
         	{
            for (int i=1; i<4; i++)
            	{
               if ((HumanPl[i]) && (Part[i]!=0)) HostNumber=i;
               }
         	for (int i=1; i<4; i++)
         		{
               if (HumanPl[i])
               	{
               	strcpy(WriteDataBlock,"NewHost");
						WriteDataBlock[7]=(char)Omrekenen(HostNumber,i);
                  strcpy(WriteDataBlock+8, CNames[HostNumber]);
						AckWritePlayer(i);
                  }
            	}
            if (HostNumber!=0)
            	{
               for (int i=0; i<4; i++)
               	{
                  strcpy(WriteDataBlock, "PlayerName");
                  WriteDataBlock[10]=(HumanPl[Omrekenen(i,HostNumber)] ? 1 : 0);
                  strcpy(WriteDataBlock+11, CNames[Omrekenen(i,HostNumber)]);
      				strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, PlNames[Omrekenen(i,HostNumber)]);
                  AckWritePlayer(HostNumber);
                  }
               strcpy(WriteDataBlock,"Acks");
               for (int m=0; m<4; m++)
                 	{
                  WriteDataBlock[4+m]=(char)AckArray[Omrekenen(m,HostNumber)];
                  }
					AckWritePlayer(HostNumber);
               AckNumber=AckArray[0];
               strcpy(HostName, CNames[HostNumber]);
               Leider=false;
               }
            }
         else
         	{
            AckReadBlock("NewHost");
            HostNumber=ReadDataBlock[7];
            strcpy(HostName, ReadDataBlock+8);
            if (HostNumber==0)
            	{
               for (int i=0; i<4; i++)
               	{
                  AckReadBlock("PlayerName");
                  HumanPl[i]=(ReadDataBlock[10]==1 ? true : false);
                  strcpy(CNames[i], ReadDataBlock+11);
                  strcpy(PlNames[i], ReadDataBlock+MAX_COMPUTERNAME_LENGTH+12);
                  }
               AckReadBlock("Acks");
               for (int m=0; m<4; m++)
               	{
                  AckArray[m]=ReadDataBlock[4+m];
                  }
               Leider=true;
               }
            }
         strcpy(OpponentName, HostName);
         }

		if (((a>1) && (Part[0]!=0) && (!TwoPlayer)) ||
				((a>1) && (TwoPlayer) && (!((Part[0]==0) && (Part[HostNumber]==0)))))
			{
			if (a==2) final=true;
			if (Part[0]!=0)
         	{
            DealBt->EnableWindow(true);
            SetYawn(true);
            }
				else Setup_New_Game();
			}
		else
			{
			if (Part[0]!=0)
				{
				Winner();
				}
			else
				{
				Loser();
				}
			}
  		goto End_Loop;
	}

End_Loop:
	PostMessage(WM_USER,2,0);
	//if (!GameTerminated) GetApplication()->PumpWaitingMessages();

   if (action[0]==15)
   	{
      action[0]=1;
      SetYawn(false);
      }

	if ((!GameStyle.OneTurnAfterPass) && (action[0]==1)) // kijken bij normaal spel of het is afgelopen
   	{
      int n=0;
      for (i=0; i<4; i++)
      	{
         if ((!Pas[i]) && (Part[i]!=0)) n++;
         }

      if ((n==0) || ((n==1) && (Part[turn]!=0) && (!Pas[turn])))
      	{
			action[0]=4;
			//goto End_Loop;
         }
      }
	}
else
	{
	if (GameTerminated)
   	{
      action[0]=0;
      if (!IQuit) MessageBoxes(2);
		play=PlayerTurn=ChooseSet=KeepStat=false;
      }

	if ((Quit) && (play))
		{
		play=false;
		this->CloseWindow();
		}
   }
}

// Event Timer Handler

void TCardGame::EvTimer(UINT)
{

	TimeOutTeller++;

	if (Yawn)
   	{
      YawnTeller++;
      if (YawnTeller==300)
      	{
         if ((Sound) && (SoundYawn))
         	{
            SoundYawn->Play();
   			}
         }
      }

      if (Knipper)
			{
   		Teller++;
   		if (Teller==10)
   			{
      		Teller=0;
      		for (int i=0; i<4; i++)
         	   {
         		if (KnipperStreep[i]) PrintStreep(i,Part[i]+KnipperStatus);
         	   if ((Ezel[i]) && (Ezel[5])) PrintStreep(i,Part[i],
            			(KnipperStatus==0 ? true : false));
         	   }
      		KnipperStatus=1-KnipperStatus;
      		}
   		}
		#if defined(BI_PLAT_WIN32)
		char Buffer[MAX_COMPUTERNAME_LENGTH + 101];

		if (TwoPlayer) ReadMessage();

      if (TwoPlayer && bInternet) {
         if (Leider) {
         	for (int i=1; i<4; i++) {
            	if (HumanPl[i]) {
               	iWaitCycle[i]++;
                  if (iWaitCycle[i]>300) {
                  	iWaitCycle[i]=0;

   		            strcpy(Buffer, "NEEDMESSAGE.");
               		memcpy(Buffer+12, &iReadPointer[i], sizeof(iReadPointer[i]));

               		oPlayer[i]->SendMessage(Buffer, 12+sizeof(iReadPointer[i]));
                  	}
               	}
            	}
         	}
         else {
             	iWaitCycle[0]++;
               if (iWaitCycle[0]>300) {
                 	iWaitCycle[0]=0;

   		         strcpy(Buffer, "NEEDMESSAGE.");
               	memcpy(Buffer+12, &iReadPointer[0], sizeof(iReadPointer[0]));

               	oPlayer[0]->SendMessage(Buffer, 12+sizeof(iReadPointer[0]));
                 	}
         	}
        	}
		#endif
}

void TCardGame::CreateTimer()
{
  if (SetTimer(TimerId, 1, 0) == 0) {
		MessageBox("No Timers Left, please terminate program", "31 for Windows",
					MB_OK | MB_ICONEXCLAMATION);

		this->CloseWindow();
		}
}

void TCardGame::EndKnipper()
{
	Knipper=false;
   for (int i=0; i<4; i++) PrintStreep(i, Part[i]);
}

void TCardGame::Winner()
{
   if (Sound31->IsBusy())
   	{
      Sound31->Stop();
      }
   if ((Sound) && (SoundWin)) SoundWin->Play(MCI_NOTIFY);
	play=false;
	EndKnipper();
	EndTwoPlayer();
	if (KeepStat)
   	{
      KeepStat=false;
      wonses++;
		won++;
		if (last==1)
			{
			lastnumber++;
			}
		else
			{
			last=1;
			lastnumber=1;
			}
		if (lastnumber>wonrec) wonrec=lastnumber;
		}
	TDialog *pTDlg = new CenterDialog(this,(engels ? Winner_DlgEN : Winner_DlgNL));
	pTDlg->Execute();
}

void TCardGame::Loser()
{
   if (Sound31->IsBusy())
   	{
      Sound31->Stop();
      }
   if ((Sound) && (SoundLoose)) SoundLoose->Play(MCI_NOTIFY);
	play=false;
	EndKnipper();

	if (KeepStat) UpdateLostIni();
/*	if (TwoPlayer)
		{

		strcpy(LoserStruct.AppName,ReadDataBlock+6);
		strcat(LoserStruct.AppName,engels ? " wins" : " heeft gewonnen");
		TAppWinDlg(this,ApponWinDlgEN, LoserStruct).Execute();
		}
	else  */
		{
		TDialog *pTDlg = new CenterDialog(this,(engels ? Loser_DlgEN : Loser_DlgNL));
		pTDlg->Execute();
		}
   	EndTwoPlayer();
}

bool TCardGame::CanClose()
{
	char mem=action[0];

	action[0]=0;

 	WriteRegistryInt(NamePlayer,"won",won);
	WriteRegistryInt(NamePlayer,"lost",lost);
	WriteRegistryInt(NamePlayer,"wonrec",wonrec);
	WriteRegistryInt(NamePlayer,"lostrec",lostrec);
	WriteRegistryInt(NamePlayer,"last",last);
	WriteRegistryInt(NamePlayer,"lastserie",lastnumber); 

  	if (play)
  		{
      TerminateGame();
      }
	if (play)
   	{
      action[0]=mem;
      return false;
      }
	if (!TestRegistration())
   	{
      TOrderDlg(this, engels ? OrderDlgEN : OrderDlgNL, engels).Execute();
      }

   return true;
}

void TCardGame::UpdateLostIni()
{
	if (KeepStat)
		{
      KeepStat=false;
		lostses++;
		lost++;
		if (last==0)
			{
			lastnumber++;
			}
		else
			{
			lastnumber=1;
			last=0;
			}
		if (lastnumber>lostrec) lostrec=lastnumber;
	}
}

void TCardGame::PrintCard(int x,int y,int n,int c,int s)
{
	TClientDC windowDC(*this);
	TMemoryDC bits(windowDC);
	if (s==0)
		{
		bits.SelectObject(*Cardbits[c]);
		windowDC.BitBlt(x,y,71,96,bits,0,0,SRCCOPY);
		}
	else
		{
		//bits.SelectObject(*AchterkantKaart);
      bool Pal=true;
      TPalette* CardPicPal;

      try
      	{
         CardPicPal= new TPalette(*AchterkantKaart);
      	}
      catch (...)
      	{
         Pal=false;
         }

  		if (Pal)
      	{
      	windowDC.SelectObject(*CardPicPal);
  			windowDC.RealizePalette();
      	}
  		windowDC.SetDIBitsToDevice(TRect(x,y,x+71,y+96), TPoint(0,0), *AchterkantKaart);
  		if (Pal)
      	{
         windowDC.RestorePalette();
         delete CardPicPal;
      	}
		c=33;
		}

	if (c!=34)
		{
		CardData[n*3]=x;
		CardData[n*3+1]=y;
		CardData[n*3+2]=c;
		}
}

void TCardGame::AnimateSwitchCard(int x, int y, int Cardnum, int Playnum)
{
	int i=0;
	int AnimI,AnimN,AnimDx,AnimDy,AnimX,AnimY,AnimCount;

	AnimDC=new TClientDC(this->HWindow);
   AnimBits=new TMemoryDC(*AnimDC);
   AnimBits2=new TMemoryDC(*AnimDC);
   AnimBits3=new TMemoryDC(*AnimDC);
   BkgBitmap=new TBitmap(*AnimDC, 640, 325);
   Tussen=new TBitmap(*AnimDC, 640, 325);

   AnimX=x;
   AnimY=y;

   AnimBits->SelectObject(*BkgBitmap);
   AnimBits->BitBlt(0,0,640,325,*AnimDC,0,0,SRCCOPY);

  	if (AnimBits->GetDeviceCaps(BITSPIXEL)<=8)
   	{
		AnimBits2->SelectObject(*Cardbits[35]);
		AnimBits->BitBlt(TRect(AnimX, AnimY, 71+AnimX, 96+AnimY), *AnimBits2,TPoint(AnimX-205, AnimY-162), SRCCOPY);
      }
   else
   	{
   	TDib BackPic(*GetApplication(), (TResId)BITMAP_48);
		AnimBits->SetDIBitsToDevice(TRect(AnimX, AnimY, 71+AnimX, 96+AnimY), TPoint(AnimX-205, 126-96-(AnimY-162)), BackPic);
      }

   switch (Playnum) {
      case 1: {
      	AnimDy=0;
         switch(Cardnum) {
            case 0: {AnimDx=-2; break;}
            case 1: {AnimDx=-3; break;}
            case 2: {AnimDx=-4; break;}
         	}
         break;
         }

   	case 2: {
      	AnimDy=-2;
         switch(Cardnum) {
         	case 0: {AnimDx=1; break;}
            case 1: {AnimDx=0; break;}
            case 2: {AnimDx=-1; break;}
          	}
      	break;
         }

		case 3:{
      	AnimDy=0;
         switch (Cardnum) {
         	case 0: {AnimDx=4; break;}
            case 1: {AnimDx=3; break;}
            case 2: {AnimDx=2; break;}
            }
         break;
         }

      }

		AnimBits->SelectObject(*BkgBitmap);
   	AnimBits2->SelectObject(*Cardbits[Cards[12+action[5]]]);
   	AnimBits3->SelectObject(*Tussen);

   DWORD v;
 //  sp=100 -> t=3 seconden
 //  sp=1 -> zo snel mogelijk

	//int wait=((3000/90)*(sp-10))/90;
   int wait;
   int n=80;
   switch (sp)
   	{
      case 0:
      	{
         wait=20;
         break;
         }
      case 1:
      	{
         wait=8;
         break;
         }
      case 2:
      	{
         wait=3;
         break;
         }
      case 3:
      	{
     		n=40;
      	wait=0;
      	AnimDx=AnimDx*2;
      	AnimDy=AnimDy*2;
         break;
         }
       }

   while (i<n)
   	{
      i++;

      v=GetTickCount();
      while (GetTickCount()-v<wait);

      AnimCount=i;
		//for (AnimI=1; AnimI<=20*sp; AnimI++)
      AnimBits3->BitBlt(AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,91,116,*AnimBits,AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,SRCCOPY);
  		AnimBits3->BitBlt(AnimX+AnimDx*AnimCount,AnimY+AnimDy*AnimCount,71,96,*AnimBits2,0,0,SRCCOPY);
      AnimDC->BitBlt(AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,91,116,*AnimBits3,AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,SRCCOPY);
   	}

  	AnimI=(turn*3)+action[4];
	AnimN=Cards[AnimI];
	Cards[AnimI]=Cards[12+action[5]];
	Cards[12+action[5]]=AnimN;

  	AnimBits2->SelectObject(*Cardbits[Cards[12+action[5]]]);

   i=0;
   while (i<n)
   	{
      i++;

      v=GetTickCount();
      while (GetTickCount()-v<wait);

   	AnimCount=n-i;
      AnimBits3->BitBlt(AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,91,116,*AnimBits,AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,SRCCOPY);
  		AnimBits3->BitBlt(AnimX+AnimDx*AnimCount,AnimY+AnimDy*AnimCount,71,96,*AnimBits2,0,0,SRCCOPY);
      AnimDC->BitBlt(AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,71+20,96+20,*AnimBits3,AnimX-10+AnimDx*AnimCount,AnimY-10+AnimDy*AnimCount,SRCCOPY);
      }

  	PrintStatus(turn,0);
  	delete AnimDC;
  	delete AnimBits;
  	delete AnimBits2;
  	delete AnimBits3;
  	delete BkgBitmap;
  	delete Tussen;
}

void TCardGame::AnimateSwitchPot(int Playnum)
{
	int j,w,g,dx[4],dy[4],x[4],y[4],AnimCount;
	TClientDC windowDC(this->HWindow);
   TMemoryDC bits(windowDC);
   TMemoryDC bits2(windowDC);
   TMemoryDC bits3(windowDC);
   TBitmap	 BkgBitmap(CreateCompatibleBitmap(windowDC,640,325), AutoDelete);
   TBitmap	 Tussen(CreateCompatibleBitmap(windowDC,640,325), AutoDelete);
   bits.SelectObject(BkgBitmap);
   bits.BitBlt(0,0,640,325,windowDC,0,0,SRCCOPY);

  	if (bits.GetDeviceCaps(BITSPIXEL)<=8)
   	{
		bits2.SelectObject(*Cardbits[35]);
//		bits.BitBlt(205,162,231,126,bits2,0,0,SRCCOPY);
		bits.BitBlt(TRect(205,162,231+205,126+162), bits2, TPoint(0, 0), SRCCOPY);
      }
   else
   	{
	   TDib BackPic(*GetApplication(), (TResId)BITMAP_48);
		bits.SetDIBitsToDevice(TRect(205,162,231+205,126+162), TPoint(0, 0), BackPic);
      }

   y[1]=y[2]=y[3]=174;
   x[1]=205;
   x[2]=285;
   x[3]=365;

   switch (Playnum) {
      case 1: {
      	dy[1]=dy[2]=dy[3]=0;
			dx[1]=-2;
         dx[2]=-3;
         dx[3]=-4;
         break;
         }

   	case 2: {
      	dy[1]=dy[2]=dy[3]=-2;
         dx[1]=1;
         dx[3]=-1;
         dx[2]=0;
         break;
         }

		case 3:{
      	dy[1]=dy[2]=dy[3]=0;
         dx[1]=4;
         dx[2]=3;
         dx[3]=2;
         break;
         }
      }
	bits.SelectObject(BkgBitmap);
   bits3.SelectObject(Tussen);


   DWORD v;
 //  sp=100 -> t=3 seconden
 //  sp=1 -> zo snel mogelijk

   int i=0;
	int wait=((3000/90)*(sp-10))/90;
   int n=80;

   switch (sp)
   	{
      case 0:
      	{
         wait=12;
         break;
         }
      case 1:
      	{
         wait=6;
         break;
         }
      case 2:
      	{
         wait=2;
         break;
         }
      case 3:
      	{
      	n=40;
      	wait=0;
      	for (j=1; j<4; j++)
      		{
         	dx[j]=dx[j]*2;
      		dy[j]=dy[j]*2;
         	}
      	}
      }

   while (i<n)
   	{
      i++;

      v=GetTickCount();
      while (GetTickCount()-v<wait);

      AnimCount=i;
      for (j=1; j<=3; j++)
      	{
         bits3.BitBlt(x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,135,160,bits,x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,SRCCOPY);
         }
      for (j=1; j<=3; j++)
      	{
   		bits2.SelectObject(*Cardbits[Cards[11+j]]);
         bits3.BitBlt(x[j]+dx[j]*AnimCount,y[j]+dy[j]*AnimCount,71,96,bits2,0,0,SRCCOPY);
         }
      for (j=1; j<=3; j++)
      	{
         windowDC.BitBlt(x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,134,160,bits3,x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,SRCCOPY);
      	}
      }

 	for (g=0; g<3; g++)
 		{
 		w=((Playnum*3)+g);
  		int nn=Cards[w];
  		Cards[w]=Cards[12+g];
		Cards[12+g]=nn;
		}

   i=0;
   while (i<n)
   	{
      i++;

      v=GetTickCount();
      while (GetTickCount()-v<wait);

   	AnimCount=n-i;
      for (j=1; j<=3; j++)
      	{
         bits3.BitBlt(x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,135,160,bits,x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,SRCCOPY);
         }
      for (j=1; j<=3; j++)
      	{
   		bits2.SelectObject(*Cardbits[Cards[11+j]]);
         bits3.BitBlt(x[j]+dx[j]*AnimCount,y[j]+dy[j]*AnimCount,71,96,bits2,0,0,SRCCOPY);
         }
      for (j=1; j<=3; j++)
      	{
         windowDC.BitBlt(x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,135,160,bits3,x[j]-32+dx[j]*AnimCount,y[j]-32+dy[j]*AnimCount,SRCCOPY);
      	}
      }

 	action[0]=3;
   Pas[turn]=true;
	PrintStatus(turn,2);
}

void TCardGame::RemoveCard(int n)
{

	if (CardData[n*3]!=0)
		{
		int x=CardData[n*3];
		int y=CardData[n*3+1];
		if (n<12)
			{
			PrintCard(x,y,n,34,0);
			}
		else
			{
			TClientDC windowDC(*this);
			TMemoryDC bits(windowDC);

      	if (windowDC.GetDeviceCaps(BITSPIXEL)<=8)
      		{
				bits.SelectObject(*Cardbits[35]);
				windowDC.BitBlt(TRect(x,y,71+x,96+y), bits, TPoint(x-205, y-162), SRCCOPY);
         	}
      	else
      		{
   			TDib BackPic(*GetApplication(), (TResId)BITMAP_48);
				windowDC.SetDIBitsToDevice(TRect(x,y,71+x,96+y), TPoint(x-205, 126-96-(y-162)), BackPic);
         	}
			}
		CardData[n*3]=0;
		CardData[n*3+1]=0;
		CardData[n*3+2]=0;
		}
}

void TCardGame::AnimateDeal()
{
	int c1,c2,c,m;
   bool CardDeal;

	if (Sound31->IsBusy())
   	{
   	Sound31->Stop();
   	}

   m=0;
   while ((m<15) && (!Quit))
   	{

      c1=deal+1+m%5;
      c2=m/5;
      if (c1>3) c1=c1-4;
      if ((m==4) || (m==9) || (m==14)) c1=4;
      c=(c1*3)+c2;

      CardDeal=false;
      if (c>11)
      	{
         PrintCard(CardX[c], CardY[c], c, Cards[c], (c<3) ? 0 : 1);
         CardDeal=true;
         }
      else
      	{
         if (Part[c/3]!=0)
         	{
            PrintCard(CardX[c], CardY[c], c, Cards[c], (c<3) ? 0 : 1);
            CardDeal=true;
            }
         }

 		if ((Sound) && (CardDeal) && (SoundDeal))
 	    	{
         if (SoundDeal->Play(MCI_NOTIFY)==0)
         	{
            while (SoundDeal->IsBusy())
        			{
           		GetApplication()->PumpWaitingMessages();
            	}
           	}
         else
         	{
            SoundDeal->Stop();
            }
         }
      m++;
      }
}

void TCardGame::PrintPlayer()
{
	PrintCard(CardX[0],CardY[0],0,Cards[0],0);
	PrintCard(CardX[1],CardY[1],1,Cards[1],0);
	PrintCard(CardX[2],CardY[2],2,Cards[2],0);
}

void TCardGame::PrintPot(int s)
{
	PrintCard(CardX[12],CardY[12],12,Cards[12],s);
	PrintCard(CardX[13],CardY[13],13,Cards[13],s);
	PrintCard(CardX[14],CardY[14],14,Cards[14],s);
}

void TCardGame::PrintApponents(int s)
{

if (Part[2]!=0)
	{
	PrintCard(CardX[6],CardY[6],6,Cards[6],s);
	PrintCard(CardX[7],CardY[7],7,Cards[7],s);
	PrintCard(CardX[8],CardY[8],8,Cards[8],s);
	}

if (Part[1]!=0)
	{
	PrintCard(CardX[3],CardY[3],3,Cards[3],s);
	PrintCard(CardX[4],CardY[4],4,Cards[4],s);
	PrintCard(CardX[5],CardY[5],5,Cards[5],s);
	}

if (Part[3]!=0)
	{
	PrintCard(CardX[9],CardY[9],9,Cards[9],s);
	PrintCard(CardX[10],CardY[10],10,Cards[10],s);
	PrintCard(CardX[11],CardY[11],11,Cards[11],s);
	}
}

void TCardGame::RemoveCardsOnTable()
{
for (int i=0; i<15; i++)
	{
	RemoveCard(i);
	}
}

void TCardGame::CmPressCard1() {
	if (PlayerTurn) {
		SelectPlayerCard(1);
   	}
	}

void TCardGame::CmPressCard2() {
	if (PlayerTurn) {
		SelectPlayerCard(2);
      }
	}

void TCardGame::CmPressCard3() {
	if (PlayerTurn) {
		SelectPlayerCard(3);
    	}
	}

void TCardGame::CmPressCard4() {
	if (PlayerTurn) {
      SelectPotCard(1);
   	}
	}

void TCardGame::CmPressCard5() {
	if (PlayerTurn) {
      SelectPotCard(2);
   	}
	}

void TCardGame::CmPressCard6() {
	if (PlayerTurn) {
      SelectPotCard(3);
   	}
	}

void TCardGame::SelectPotCard(int iCard) {

	int c = Card2;
   Card2 = iCard;

   if ((c!=0) && (c!=Card2))
      {
      RemoveCard(11+c);
      PrintCard(125+80*c,174,11+c,Cards[11+c],0);
      }
   if (c!=Card2)
      {
      RemoveCard(11+Card2);
      PrintCard(125+80*Card2,162,11+Card2,Cards[11+Card2],0);
      }
   if (c==Card2)
      {
      RemoveCard(11+Card2);
      PrintCard(125+80*Card2,174,11+Card2,Cards[11+Card2],0);
      Card2=0;
      }
	if ((Card1==0) && (Card2==0))
   	{
		PassBt->EnableWindow(true);
		ChgAllBt->EnableWindow(true);
      }
   else
   	{
		PassBt->EnableWindow(false);
		ChgAllBt->EnableWindow(false);
      }
	if ((Card1!=0) && (Card2!=0))
   	{
      ChangeBt->EnableWindow(true);
      }
   else
   	{
      ChangeBt->EnableWindow(false);
      }
}

void TCardGame::SelectPlayerCard(int iCard) {

	int d = Card1;
   Card1 = iCard;

   if ((d!=0) && (d!=Card1))
      {
      RemoveCard(d-1);
      PrintCard(125+80*d,335,d-1,Cards[d-1],0);
      }
   if (d!=Card1)
      {
      RemoveCard(Card1-1);
      PrintCard(125+80*Card1,320,Card1-1,Cards[Card1-1],0);
      }
   if (d==Card1)
      {
      RemoveCard(Card1-1);
      PrintCard(125+80*Card1,335,Card1-1,Cards[Card1-1],0);
      Card1=0;
      }

	if ((Card1==0) && (Card2==0))
   	{
		PassBt->EnableWindow(true);
		ChgAllBt->EnableWindow(true);
      }
   else
   	{
		PassBt->EnableWindow(false);
		ChgAllBt->EnableWindow(false);
      }
	if ((Card1!=0) && (Card2!=0))
   	{
      ChangeBt->EnableWindow(true);
      }
   else
   	{
      ChangeBt->EnableWindow(false);
      }
}

void TCardGame::EvLButtonDown(uint, TPoint& p)
{
int c=Card2;
int d=Card1;

if ((p.x>592) && (p.x<624) && (p.y>16) && (p.y<48) && (play))
	{
	TVariationDlg* VarDlg;

   VarDlg = new TVariationDlg(this, engels ? VariationDlgEN : VariationDlgNL, engels, GameStyle);

   VarDlg->Execute();

   delete VarDlg;
   }

if (PlayerTurn)
	{
	if ((p.x>204) && (p.x<435) && (p.y>174) && (p.y<273))
		{
		SelectPotCard(1+(p.x-204)/77);
		}

	if ((p.x>204) && (p.x<435) && (p.y>335) && (p.y<431))
		{
		SelectPlayerCard(1+(p.x-204)/77);
		}
      
	}
}

void TCardGame::PaintScoreRectangles()
{
	TClientDC dc(*this);

	TBrush WhiteBrush(TColor(255,255,255));
   TPen WhitePen(TColor(255,255,255));
	TPen DarkPen(TColor(0,64,0));
   TPen GreenPen(TColor(0,128,0));
   TPen LightPen(TColor(0,192,0));
   TPen ShadowPen(TColor(192,192,192));
   TRect	r(19,19,169,98);

   for (int i=0; i<4; i++)
   	{
      r.top=20+i*20;
      r.bottom=r.top+17;

      dc.SelectObject(WhiteBrush);
      dc.SelectObject(WhitePen);
      dc.FillRect(r, WhiteBrush);
      dc.Ellipse(r.right-7, r.top, r.right+7, r.bottom);


      dc.SelectObject(ShadowPen);
      dc.MoveTo(r.left+1, r.bottom-1);
      dc.LineTo(r.left+1, r.top+1);
      dc.LineTo(r.right+1, r.top+1);
      dc.Arc(r.right-7, r.top+1, r.right+7, r.bottom, r.right+7, r.top+1, r.right, r.top+1);
		dc.SelectObject(LightPen);
  	 	dc.MoveTo(r.left, r.bottom);
  	 	dc.LineTo(r.right, r.bottom);
      dc.Arc(r.right-7, r.top, r.right+7, r.bottom, r.right, r.bottom, r.right, r.top);
		dc.SelectObject(DarkPen);
      dc.MoveTo(r.right, r.top);
   	dc.LineTo(r.left, r.top);
   	dc.LineTo(r.left, r.bottom);
      dc.Arc(r.right-7, r.top, r.right+7, r.bottom, r.right+7, r.top, r.right, r.top);

      dc.SelectObject(DarkPen);
      dc.MoveTo(r.left+107, r.top+1);
      dc.LineTo(r.left+111, r.top+1);
      dc.SelectObject(ShadowPen);
      dc.MoveTo(r.left+107, r.top+2);
      dc.LineTo(r.left+111, r.top+2);
      dc.SelectObject(LightPen);
      dc.MoveTo(r.left+107, r.bottom-1);
      dc.LineTo(r.left+111, r.bottom-1);
		dc.SelectObject(GreenPen);
      dc.MoveTo(r.left+107, r.top);
      dc.LineTo(r.left+111, r.top);
      dc.MoveTo(r.left+107, r.bottom);
      dc.LineTo(r.left+111, r.bottom);
      }
}

void TCardGame::PrintScoreName(char string[17], int n)
{
	TClientDC dc(*this);
   int m;

   m=strlen(string);
   if (m==0)
   	{
      strcpy(string,"X");
      }
   TRect	r(23,22+(n*20),125,36+(n*20));
   TFont NaamFont("MS Sans Serif", 12,0,0,0,FW_BOLD);
   dc.SelectObject(NaamFont);

	TBrush Color(TColor(255,255,255));
 	dc.SelectObject(Color);
	TPen	Omtrek(TColor(255,255,255),1,PS_SOLID);
	dc.SelectObject(Omtrek);
   dc.Rectangle(r);
	TPen	Omtrek2(TColor(0,0,0),1,PS_SOLID);
	dc.SelectObject(Omtrek2);
	dc.DrawText(string,m,r,DT_LEFT | DT_VCENTER);
}

void TCardGame::PrintName(char string[17], int n, bool clear)
{
   if (!clear) PrintScoreName(string, n);
   if ((!clear) && (strlen(string)==0))
   	{
      strcpy(string,"X");
      }

	switch (n){
      case 0: break;
   	case 1: NamePlayer1->SetText(string); break;
      case 2: NamePlayer2->SetText(string); break;
      case 3: NamePlayer3->SetText(string); break;
      };
}

void TCardGame::MakeNameList()
{
   bool NameFound;
   int n;

	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
   	{
      if (!Leider)   // Je bent gejoined en wacht op namen
   		{
			AckReadBlock("N1");
			strcpy(Name1,ReadDataBlock+3);
   		PrintName(Name1,1);
			AckReadBlock("N2");
			strcpy(Name2,ReadDataBlock+3);
   		PrintName(Name2,2);
			AckReadBlock("N3");
			strcpy(Name3,ReadDataBlock+3);
   		PrintName(Name3,3);
      	}
      else
      	{
         for (int i=1; i<4; i++)
         	{
            if (!HumanPl[i])
            	{
               NameFound=false;
               n=0;
               while (!NameFound)
               	{
               	for (int j=0; j<4; j++)
               		{
                  	if (strcmp(PlNames[j], Names[n])==0)
                    		{
                     	NameFound=true;
                     	}
                  	}
               	if ((NameFound) && (n<4))
                  	{
                     n++;
                     NameFound=false;
                     }
                  else
                  	{
               		strcpy(PlNames[i], Names[n]);
                     NameFound=true;
                     }
                  }
               }
            }
         // namen afdrukken
         strcpy(Name1, PlNames[1]);
         strcpy(Name2, PlNames[2]);
         strcpy(Name3, PlNames[3]);
   		PrintName(Name1,1);
   		PrintName(Name2,2);
   		PrintName(Name3,3);
         // stuur de namen door
         for (int i=1; i<4; i++)
         	{
            if (HumanPl[i])
            	{
      			strcpy(WriteDataBlock,"N1");
					strcpy(WriteDataBlock+3,PlNames[(i+1)%4]);
					AckWritePlayer(i);
      			strcpy(WriteDataBlock,"N2");
					strcpy(WriteDataBlock+3,PlNames[(i+2)%4]);
					AckWritePlayer(i);
      			strcpy(WriteDataBlock,"N3");
					strcpy(WriteDataBlock+3,PlNames[(i+3)%4]);
					AckWritePlayer(i);
               }
            }
         }
      }
   else // 1 speler spel
   #endif
   	{
      n=0;
      NameFound=false;
      while (!NameFound)
      	{
         if (strcmp(Names[n],NamePlayer)!=0)
         	{
            strcpy(Name2,Names[n]);
            NameFound=true;
            }
         else n++;
         }
   	PrintName(Name2,2);

		n=0;
   	NameFound=false;
   	while (!NameFound)
   		{
      	if ((strcmp(Names[n],NamePlayer)!=0) && (strcmp(Names[n],Name2)!=0))
      		{
      		strcpy(Name1,Names[n]);
         	NameFound=true;
         	}
      	else n++;
      	}
   	PrintName(Name1,1);

   	n=0;
   	NameFound=false;
   	while (!NameFound)
   		{
      	if ((strcmp(Names[n],NamePlayer)!=0) && (strcmp(Names[n],Name2)!=0) &&
      		(strcmp(Names[n],Name1)!=0))
      		{
      		strcpy(Name3,Names[n]);
         	NameFound=true;
         	}
      	else n++;
      	}
   	PrintName(Name3,3);
      }
   /*
	else
   #endif
   {
	if (!TwoPlayer)
   	{
      while (!NameFound)
      	{
         if (strcmp(Names[n],NamePlayer)!=0)
         	{
            strcpy(Name2,Names[n]);
            NameFound=true;
            }
         else n++;
         }
      }
   PrintName(Name2,2);
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
      strcpy(WriteDataBlock,"N1");
		strcpy(WriteDataBlock+3,NamePlayer);
		AckWriteBlock();
		}
   #endif
	n=0;
   NameFound=false;
   while (!NameFound)
   	{
      if ((strcmp(Names[n],NamePlayer)!=0) && (strcmp(Names[n],Name2)!=0))
      	{
      	strcpy(Name1,Names[n]);
         NameFound=true;
         }
      else n++;
      }
   PrintName(Name1,1);
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
      strcpy(WriteDataBlock,"N2");
		strcpy(WriteDataBlock+3,Name1);
		AckWriteBlock();
		}
   #endif
   n=0;
   NameFound=false;
   while (!NameFound)
   	{
      if ((strcmp(Names[n],NamePlayer)!=0) && (strcmp(Names[n],Name2)!=0) &&
      		(strcmp(Names[n],Name1)!=0))
      	{
      	strcpy(Name3,Names[n]);
         NameFound=true;
         }
      else n++;
      }
   PrintName(Name3,3);
	#if defined(BI_PLAT_WIN32)
	if (TwoPlayer)
		{
      strcpy(WriteDataBlock,"N3");
		strcpy(WriteDataBlock+3,Name3);
		AckWriteBlock();
		}
   #endif
	} */
}

// Menu Functions


void TCardGame::SetMenuItems(bool a, bool b,bool c)
{
nov=a;
adv=b;
exp=c;
CheckMenuItem(Parent->GetMenu(), CM_NOVICE, nov ? MF_CHECKED : MF_UNCHECKED);
CheckMenuItem(Parent->GetMenu(), CM_ADVANCED, adv ? MF_CHECKED : MF_UNCHECKED);
CheckMenuItem(Parent->GetMenu(), CM_EXPERT, exp ? MF_CHECKED : MF_UNCHECKED);
}

void TCardGame::SetNovice()
{
	SetMenuItems(true,false,false);
	MessageBoxes(4);
	WriteRegistryString(OptionName,"Level","Nov");
}

void TCardGame::SetAdvanced()
{
	if (TestRegistration())
   	{
		SetMenuItems(false,true,false);
		MessageBoxes(5);
		WriteRegistryString(OptionName,"Level","Adv");
      }
   else
   	{
      TOrderDlg(this, engels ? NotAvailableDlgEN : NotAvailableDlgNL, engels).Execute();
      }
}

void TCardGame::SetExpert()
{
	if (TestRegistration())
   	{
		SetMenuItems(false,false,true);
		MessageBoxes(6);
  		WriteRegistryString(OptionName,"Level","Exp");
      }
   else
   	{
      TOrderDlg(this, engels ? NotAvailableDlgEN : NotAvailableDlgNL, engels).Execute();
      }
}

TResult TCardGame::CmUser1Message(TParam1 id, TParam2 id2) {
   DoUserMessage(0, oPlayer[0], id, id2);
	return NULL;
	}

TResult TCardGame::CmUser2Message(TParam1 id, TParam2 id2) {
   DoUserMessage(1, oPlayer[1], id, id2);
	return NULL;
	}

TResult TCardGame::CmUser3Message(TParam1 id, TParam2 id2) {
   DoUserMessage(2, oPlayer[2], id, id2);
	return NULL;
	}

TResult TCardGame::CmUser4Message(TParam1 id, TParam2 id2) {
	DoUserMessage(3, oPlayer[3], id, id2);
	return NULL;
 	}

void TCardGame::DoUserMessage(int nPlayer, TWinSocket* poSocket, TParam1 id, TParam2 id2) {

	char Buffer[MAX_COMPUTERNAME_LENGTH + 101];
 	char TempDataBlock[MessageSize];
   char cNumber[4];
   int  iTempReadPointer;

   FILE* hLogFile;

   switch (WSAGETSELECTEVENT(id2)) {

      case FD_READ: {

			if (poSocket!=NULL) {

            iWaitCycle[nPlayer]=0;

         	recv(poSocket->hConnection, Buffer, sizeof(Buffer), 0);

            memcpy(TempDataBlock, Buffer+12+MAX_COMPUTERNAME_LENGTH+1, 88);
            memcpy(&iTempReadPointer, Buffer+12, sizeof(iTempReadPointer));

            if (bDebug) {
            	hLogFile = fopen("Debug\\ReceivedEvents.txt", "a");
               itoa(iTempReadPointer, cNumber, 10);

               if (hLogFile!=NULL) {
                  fwrite(Buffer, 1, strlen(Buffer)>10 ? 10 : strlen(Buffer), hLogFile);
                  fwrite(" - ", 1, 1, hLogFile);
                  fwrite(TempDataBlock, 1, strlen(TempDataBlock)>12 ? 12 : strlen(TempDataBlock), hLogFile);
                  fwrite(" - ", 1, 1, hLogFile);
                  fwrite(cNumber, 1, strlen(cNumber)>4 ? 4 : strlen(cNumber), hLogFile);
                  fwrite("\n", 1, 1, hLogFile);
                  fclose(hLogFile);
               	}
            	}

            if (strncmp(Buffer, "NEEDMESSAGE.", 12)==0) {
            	//blijkbaar heeft de andere partij een bericht niet ontvangen
               //we sturen die berichten nogmaals

					memcpy(&iTempReadPointer, Buffer+12, sizeof(iTempReadPointer));

               for(int i=iTempReadPointer; i<WriteBuffer[nPlayer]->nUsed; i++) {

		         	WriteBuffer[nPlayer]->ReadEntry(i, &Buffer);
                  poSocket->SendMessage(Buffer, sizeof(Buffer));
               	}
            	}


            if (strncmp(Buffer, "CHATMESSAGE.", 12)==0) {
               if (!MessageDlg)
                  {
                  MessageDlg= new TMessageDlg(this, (engels ? Message_DlgEN : Message_DlgNL), MessageStruct);
                  MessageDlg->Create();
                  strcpy(MessageDlg->OpponentName,OpponentName);
                  strcpy(MessageDlg->PlayerName,NamePlayer);
                  }
               MessageDlg->AddMessage(Buffer+12);
            	if (Leider)
            		{
               	for (int i=1; i<4; i++)
               		{
                  	SendMessageToPlayer(i, Buffer+12);
                  	}
               	}
					}

            //even een sneakpeak voor chat messages en voor
            //keuzes gemaakt door spelers.

            if (strcmp(Buffer,"31Win95_1.5")==0)
               {
               if (iTempReadPointer>ReadBuffer[nPlayer]->nUsed) {
                  //ik heb er een paar gemist merk ik, even aan de host vragen
                  //of ik die nogmaals kan ontvangen.
                  strcpy(Buffer, "NEEDMESSAGE.");
                  iTempReadPointer = ReadBuffer[nPlayer]->nUsed;
                  memcpy(Buffer+12, &iTempReadPointer, sizeof(iTempReadPointer));

                  poSocket->SendMessage(Buffer, 12+sizeof(iTempReadPointer));
                  break;
                  }

               if (iTempReadPointer<ReadBuffer[nPlayer]->nUsed) {
                  // oud bericht, negeren
                  break;
                  }

               ReadBuffer[nPlayer]->AddEntry(&Buffer);

               if (bDebug) {
                  hLogFile = fopen("Debug\\ReceivedEvents.txt", "a");
                  itoa(iTempReadPointer, cNumber, 10);

                  if (hLogFile!=NULL) {
                     fwrite("   Add: ", 8, 1, hLogFile);
	                  fwrite(cNumber, 1, strlen(cNumber)>4 ? 4 : strlen(cNumber), hLogFile);
                     fwrite("\n", 1, 1, hLogFile);
                     fclose(hLogFile);
                     }
               	}

               /*if (strcmp(TempDataBlock,"PlChoice")==0 && !GameTerminated && bWaitForPlChoice && iReadPointer[nPlayer] == ReadBuffer[nPlayer]->nUsed-1) {
                  if ((play) && (!Quit) && (!GameTerminated)) {

                     iReadPointer[nPlayer] = ReadBuffer[nPlayer]->nUsed;

                     action[0]=2;
                     action[1]=TempDataBlock[10];
                     action[2]=0;
                     action[3]=0;
                     action[4]=TempDataBlock[11];
                     action[5]=TempDataBlock[12];
                     DoPlayerChoice();

                     if (Leider) {
                        memcpy(WriteDataBlock, Buffer, sizeof(WriteDataBlock));
                        for (int i=1; i<4; i++)
                           {
                           if ((HumanPl[i]) && (i!=turn)) AckWritePlayer(i);
                           }
                        }
                     bWaitForPlChoice= false;
                     PostMessage(WM_USER,2,0);
                     }
                  break;
                  } */    
               }
 				}
         break;
         }
      };
   }

void TCardGame::CmStartInternetGame() {

	TInternetGameStruct InternetGameStruct;
   char buffer[MaxName];
   char cMessage[1024];
   GameTerminated=false;
   starting=true;


	//Fill dialog struct
   InternetGameStruct.NameData.Clear();
  	strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer1","",buffer,MaxName));
   InternetGameStruct.NameData.AddString(buffer);
   strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer2","",buffer,MaxName));
   InternetGameStruct.NameData.AddString(buffer);
   strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer3","",buffer,MaxName));
   InternetGameStruct.NameData.AddString(buffer);
   strcpy(buffer, ReadRegistryString("LastPlayer","LastPlayer","",buffer,MaxName));
   InternetGameStruct.NameData.SelectString(buffer);

   InternetGameStruct.bHost = true;
   InternetGameStruct.bClient = false;

   InternetGameStruct.IPData.Clear();
    //Get local IPADresses
    WSAData wsaData;
    if(!WSAStartup(MAKEWORD(1,1),&wsaData))
        {
        char ac[80];
        if(gethostname(ac,sizeof(ac)) != SOCKET_ERROR)
            {
            hostent *phe = gethostbyname(ac);
            if(phe)
                {
                in_addr addr;
                for(int i = 0; phe->h_addr_list[i] != 0; ++i)
                    {
                    CopyMemory(&addr, phe->h_addr_list[i], sizeof(in_addr));

                    InternetGameStruct.IPData.AddString(inet_ntoa(addr));
						  }

                InternetGameStruct.IPData.SelectString(inet_ntoa(addr));
					 }
				}
		  }
	 WSACleanup();

	strcpy(InternetGameStruct.cHostIP, ReadRegistryString("InternetGame","LastHost","",InternetGameStruct.cHostIP,sizeof(InternetGameStruct.cHostIP)));
 
   //toon dialog
	if (TStartInternetDlg(this,(engels ? DlgStartInternetEN : DlgStartInternetNL), InternetGameStruct).Execute() == IDOK) {

      if (!InternetGameStruct.bHost) {
         //maak connectie met host
          oPlayer[0]=oSockets->NewConnection(InternetGameStruct.cHostIP, 10033);
          if (oPlayer[0]==NULL) {
            MessageBoxes(15); //cannot connect to host
            }
          else {
				 if (oPlayer[0]->ReadMessage(cMessage, sizeof(cMessage))) {
					if (strncmp(cMessage, "GAMEFULL....", 12)==0) {
                  MessageBoxes(10); //game is full
						delete oPlayer[0];
						oPlayer[0]=NULL;
						}

               if (strncmp(cMessage, "OK..........", 12)==0) {
                  //we kunnen verder, geef mijn naam door.

						strcpy(cMessage, "MYNAMEIS....");
                  InternetGameStruct.NameData.GetSelString(buffer,MaxName);
						strcat(cMessage, buffer);
                  oPlayer[0]->SendMessage(cMessage, strlen(cMessage)+1);

                  //wacht op de namen van de andere spelers
						if (oPlayer[0]->ReadMessage(cMessage, sizeof(cMessage))) {
							if (strncmp(cMessage, "PARTICIPANTS", 12)==0) {
                        //dit bericht wordt later verwerkt als de dialog gecreeerd is.
								}
							else {
								delete oPlayer[0];
								oPlayer[0]=NULL;
								MessageBoxes(15);
								}
							}
						else {
							delete oPlayer[0];
							oPlayer[0]=NULL;
							MessageBoxes(15);
							}
						}
               }
             else {
					//fout bij lezen van bericht.
               delete oPlayer[0];
               oPlayer[0]=NULL;
					MessageBoxes(15);
					}
             }
      	}

      if ((oPlayer[0]!=NULL && !InternetGameStruct.bHost) || InternetGameStruct.bHost) {
         TInternetWaitPlayersDlg* InternetWaitPlayersDlg = new TInternetWaitPlayersDlg(this, (engels ? DlgInternetWaitEN : DlgInternetWaitNL));
         InternetWaitPlayersDlg->bHost = InternetGameStruct.bHost;
			InternetWaitPlayersDlg->oWinSockets = oSockets;
         InternetGameStruct.NameData.GetSelString(buffer,MaxName);
			strcpy(InternetWaitPlayersDlg->cMyName, buffer);
         
			if (InternetGameStruct.bHost) {
            InternetGameStruct.IPData.GetSelString(InternetWaitPlayersDlg->cHostIP, sizeof(InternetWaitPlayersDlg->cHostIP));
				InternetGameStruct.NameData.GetSelString(buffer,MaxName);
				strcpy(InternetWaitPlayersDlg->PlNames[0], buffer);
				}
			else {
				strcpy(InternetWaitPlayersDlg->cHostIP, InternetGameStruct.cHostIP);
				WriteRegistryString("InternetGame","LastHost",InternetGameStruct.cHostIP);

				//last message is participants message
				InternetWaitPlayersDlg->nPlayers = cMessage[12]-65;

				strcpy(InternetWaitPlayersDlg->PlNames[0], cMessage+13); //host
				strcpy(InternetWaitPlayersDlg->PlNames[1], cMessage+30);
				strcpy(InternetWaitPlayersDlg->PlNames[2], cMessage+47);
				strcpy(InternetWaitPlayersDlg->PlNames[3], cMessage+64);

            //socket doorgeven
            InternetWaitPlayersDlg->oPlayerSockets[0] = oPlayer[0];
				}

         if (InternetWaitPlayersDlg->Execute()==IDOK) {
            //game gaat wel door.
            bInternet = true;
            TwoPlayer = true;
   			starting = false;
            Leider = InternetWaitPlayersDlg->bHost;

            //data initialiseren die aangeeft of speler Human is of niet.
            for (int i=0; i<4; i++)
            	{
               HumanPl[i]=false;
               AckArray[i]=0;
               }
            HumanPl[0]=true;

            strcpy(cMessage, "STARTGAME...");

            for (int i=0; i<4; i++) {
               //data overnemen uit dialoog
					if (InternetWaitPlayersDlg->bHost) {
               	oPlayer[i] = InternetWaitPlayersDlg->oPlayerSockets[i];
                  ReadBuffer[i]->Clear();
                  WriteBuffer[i]->Clear();
                  iReadPointer[i]=0;
                  iWritePointer[i]=0;
                  iWaitCycle[i]=0;

                  if (oPlayer[i]!=NULL) {
                     oPlayer[i]->SetReadEvent(HWindow, i+1);
                     oPlayer[i]->SendMessage(cMessage, strlen(cMessage)+1);
               		HumanPl[i]=true;
                  	}
               	strcpy(PlNames[i], InternetWaitPlayersDlg->PlNames[i]);

                  }
               else {
         			oPlayer[0] = InternetWaitPlayersDlg->oPlayerSockets[0];
                  ReadBuffer[0]->Clear();
                  WriteBuffer[0]->Clear();
                  iReadPointer[0]=0;
                  iWritePointer[0]=0;
                  iWaitCycle[0]=0;
                  if (oPlayer[0]!=NULL) {
                  	oPlayer[0]->SetReadEvent(HWindow, 1);
                     }
               	}
            	}
            }
         else {
            //game gaat niet door.
   			starting = false;
            oPlayer[0] = InternetWaitPlayersDlg->oPlayerSockets[0];
            if (oPlayer[0]!=NULL) {
         		delete oPlayer[0];
            	}
				switch (InternetWaitPlayersDlg->iCloseReason) {

					case 1: { //game aborted by host
						MessageBoxes(12);
						break;
						}

					case 2: { //booted by host
						MessageBoxes(11);
						break;
						}
					};
            }

         delete InternetWaitPlayersDlg;
         }
		}
   else {
      play = false;
      starting = false;
   	}

      if (TwoPlayer)
      	{
         if (bInternet) SendBt->Show(true);
			IdStart();
      	}
	}

void TCardGame::SetupNetworkGame()
{
	VariationData VarData;
	#if defined(BI_PLAT_WIN32)
   // HumanPl -> boolean voor menselijk spelers;
   // PlNames -> strings voor namen echte spelers;


   char buffer[MessageSize],tempbuffer[MessageSize];
   char TempOpponent[MAX_COMPUTERNAME_LENGTH + 1];
   bool contact,agree;
   char NameOpp[50];
   bool first=true;

   bInternet = false;
   GameTerminated=false;
   starting=true;

   // Naam computer bepalen
   unsigned long BufferSize=MAX_COMPUTERNAME_LENGTH+1;
   if (GetComputerName(ComputerName, &BufferSize)==0)
   	{
   	MessageBoxes(14); // geen naam
      starting=false;
     	return;
      }

   // Mailslot initieren
	LPSTR lpszSlotName = "\\\\.\\mailslot\\31W9515G";
   LPSTR lpszSlotName2 = "\\\\.\\mailslot\\31W9515M";

   if (hSlot1!= INVALID_HANDLE_VALUE) CloseHandle(hSlot1);
   if (hSlot2!= INVALID_HANDLE_VALUE) CloseHandle(hSlot2);

   hSlot1 = CreateMailslot(lpszSlotName,
     	0,                         	/* no maximum message size         */
     	MAILSLOT_WAIT_FOREVER,     	/* no time-out for read operations */
     	(LPSECURITY_ATTRIBUTES) NULL);/* no security attributes      */

   if (hSlot1 == INVALID_HANDLE_VALUE) {
   	MessageBoxes(7); // geen netwerk-verbinding
      starting=false;
     	return ;}

   hSlot2 = CreateMailslot(lpszSlotName2,
     	784,
     	MAILSLOT_WAIT_FOREVER,     	/* no time-out for read operations */
     	(LPSECURITY_ATTRIBUTES) NULL);/* no security attributes      */

   if (hSlot2 == INVALID_HANDLE_VALUE) {
   	MessageBoxes(7);// geen netwerk-verbinding
      starting=false;
     	return ;}

   agree=false;
	//while (!agree)
   //	{
		NetworkDlg= new TNetworkDlg(this, (engels ? SetupNetwork_DlgEN : SetupNetwork_DlgNL), engels, VariationArray);
		NetworkDlg->Create();

      char string[64];
		strcpy(string, ReadRegistryString(OptionName, "GameType", string, string, 64));
      NetworkDlg->VariationBox->SetSelString(string, 0);
      if (NetworkDlg->VariationBox->GetSelIndex()<0)
      	{
         NetworkDlg->VariationBox->SetSelIndex(0);
         }

   	// Melden aan iedereen dat je er bent
   	strcpy(WriteDataBlock,"HereIAm....");
   	strcat(WriteDataBlock,ComputerName);
      strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, NamePlayer);
   	WriteBlock(0, true); // broadcast

   	contact=false;
      while ((NetworkDlg->Available) && (!contact))
      	{
         if (NetworkDlg->WantPlayers)
         	{
        		strcpy(WriteDataBlock,"GimmeNames.");
        		strcat(WriteDataBlock,ComputerName);
            int i=NetworkDlg->GamesList->GetSelIndex();
            if (i>=0)
            	{
               strcpy(OpponentName, NetworkDlg->ComputerGamesList[i]);
        			WriteBlock(OpponentName);
               NetworkDlg->PlayerList->ClearList();
               }

            NetworkDlg->WantPlayers=false;
            }

         if (NetworkDlg->WantInfo)
         	{
        		strcpy(WriteDataBlock,"GimmeInfo..");
        		strcat(WriteDataBlock,ComputerName);
            int i=NetworkDlg->GamesList->GetSelIndex();
            if (i>=0)
            	{
               strcpy(OpponentName, NetworkDlg->ComputerGamesList[i]);
        			WriteBlock(OpponentName);
               }
            NetworkDlg->WantInfo=false;
            }

     	 	if ((first) && (NetworkDlg->Host))
        		{
            first=false;
        		strcpy(WriteDataBlock,"AddGame....");
        		strcat(WriteDataBlock,ComputerName);
            strcpy(buffer, NamePlayer);
            strcat(buffer,"'s (");
            VariationArray->ReadEntry(NetworkDlg->VariationBox->GetSelIndex(), &VarData);
            strcat(buffer, VarData.VarName);
            strcat(buffer, ")");
  				strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, buffer);
        		WriteBlock(0, true);
            NetworkDlg->PlayerList->ClearList();
            NetworkDlg->AddPossiblePlayer(ComputerName, NamePlayer);
            }
     	 	if ((first) && (NetworkDlg->Joined))
        		{
            first=false;
        		strcpy(WriteDataBlock,"WannaJoin..");
        		strcat(WriteDataBlock,ComputerName);
  				strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, NamePlayer);
            int i=NetworkDlg->GamesList->GetSelIndex();
            if (i<0)
            	{
               NetworkDlg->Joined=false;
               NetworkDlg->EnableControls();
               }
            else
            	{
               strcpy(OpponentName, NetworkDlg->ComputerGamesList[i]);
            	strcpy(HostName, OpponentName);
               NetworkDlg->PlayerList->ClearList();
        			WriteBlock(OpponentName);
               }
            }

			strcpy(buffer,"");
      	if (ReadBlock(0, false)==0)
        		{
				strncat(buffer,ReadDataBlock,11);
            strcpy(OpponentName, "");
            strncat(OpponentName,ReadDataBlock+11, MAX_COMPUTERNAME_LENGTH+1);
     			strcpy(NameOpp, ReadDataBlock+MAX_COMPUTERNAME_LENGTH+12);

            // Dubbele berichten voorkomen
            // Dubbel = zelfde type van zelfde persoon, exact na elkaar...
            if ((strcmp(OpponentName, TempOpponent)==0) && (strcmp(buffer, tempbuffer)==0))
            	{
               strcpy(buffer, "<undef>");
               }
            else
            	{
               strcpy(TempOpponent, OpponentName);
               strcpy(tempbuffer, buffer);
               }

         	if (strcmp(buffer,"AddGame....")==0)
         		{
            	NetworkDlg->AddGame(OpponentName, NameOpp);
            	}
         	if ((strcmp(buffer,"DelGame....")==0) || (strcmp(buffer,"StartGame..")==0))
         		{
            	NetworkDlg->DeleteGame(OpponentName);
            	}
            if (strcmp(buffer,"PlayerName.")==0)
            	{
               if (!NetworkDlg->Host) NetworkDlg->AddPossiblePlayer(OpponentName, NameOpp);
               }

				if (strcmp(buffer,"HereIsInfo.")==0)
						{
                  memcpy(&VarData, ReadDataBlock+MAX_COMPUTERNAME_LENGTH+12, sizeof(VariationData));

						TVariationDlg* VarDlg;

   					VarDlg = new TVariationDlg(NetworkDlg, engels ? VariationDlgEN : VariationDlgNL, engels, VarData);

   					VarDlg->Execute();

   					delete VarDlg;
                  }
            }

        	 	if (NetworkDlg->Host)
         		{
               if (NetworkDlg->Spelen)
               	{
                  if (NetworkDlg->PlayerList->GetCount()>1)
                  	{
                     contact=true;
                     }
                  else
                  	{
                     MessageBoxes(13);
                     NetworkDlg->Spelen=false;
                     }
                  }

					if (strcmp(buffer,"GimmeNames.")==0)
						{
                  int i=NetworkDlg->PlayerList->GetCount();
                  if (i>0)
                  	{
                     for (int ii=0; ii<i; ii++)
                     	{
                        strcpy(WriteDataBlock, "PlayerName.");
                        strcat(WriteDataBlock, NetworkDlg->ComputerList[ii]);
      						strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, NetworkDlg->NameList[ii]);
                        WriteBlock(OpponentName);
                        }
                     }
                  }

					if (strcmp(buffer,"GimmeInfo..")==0)
						{
                  strcpy(WriteDataBlock, "HereIsInfo.");
                  strcat(WriteDataBlock, OpponentName);
            		VariationArray->ReadEntry(NetworkDlg->VariationBox->GetSelIndex(), &VarData);
                  memcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, &VarData, sizeof(VariationData));
                  WriteBlock(OpponentName);
                  }

					if (strcmp(buffer,"HereIAm....")==0)
						{
            		if (strcmp(OpponentName, ComputerName)!=0)
            			{
            			strcpy(WriteDataBlock,"AddGame....");
            			strcat(WriteDataBlock,ComputerName);

                     strcpy(buffer, NamePlayer);
                     strcat(buffer,"'s (");
            			VariationArray->ReadEntry(NetworkDlg->VariationBox->GetSelIndex(), &VarData);
            			strcat(buffer, VarData.VarName);
                     strcat(buffer, ")");
      					strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, buffer);
            			WriteBlock(OpponentName);
               		}
     					}

  					if (strcmp(buffer,"DeleteMe...")==0)
               	{
                  NetworkDlg->DeletePlayer(OpponentName);
                  strcpy(WriteDataBlock, "DelPlayer..");
                  strcat(WriteDataBlock, OpponentName);
                  for (int i=1; i<NetworkDlg->PlayerList->GetCount(); i++)
           				{
                    	strcpy(OpponentName, NetworkDlg->ComputerList[i]);
                     WriteBlock(OpponentName);
                     }
               	}

  					if (strcmp(buffer,"WannaJoin..")==0)
						{
                  if (NetworkDlg->PlayerList->GetCount()==4)
                  	{
                     bool testing=false;
                     for (int i=0; i<4; i++)
                     	{
                        if (strcmp(OpponentName, NetworkDlg->ComputerList[i])==0) testing=true;
                        }
                     if (!testing)
                     	{
                        strcpy(WriteDataBlock, "GameFull...");
            				strcat(WriteDataBlock,ComputerName);
                     	WriteBlock(OpponentName);
                     	}
                     }
                  else
                  	{
            			NetworkDlg->AddPossiblePlayer(OpponentName, NameOpp);
                     for (int i=0; i<NetworkDlg->PlayerList->GetCount(); i++)
            				{
                        strcpy(WriteDataBlock, "AddPlayer..");
                        strcat(WriteDataBlock, NetworkDlg->ComputerList[i]);
      						strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, NetworkDlg->NameList[i]);
                        //strcpy(OpponentName, NetworkDlg->ComputerList[i]);
                        WriteBlock(OpponentName);
                        }
                    	strcpy(WriteDataBlock, "AddPlayer..");
                    	strcat(WriteDataBlock, OpponentName);
     						strcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+12, NameOpp);
                     for (int i=1; i<NetworkDlg->PlayerList->GetCount(); i++)
            				{
                        strcpy(OpponentName, NetworkDlg->ComputerList[i]);
                        WriteBlock(OpponentName);
                        }
                     }
                  }

               if (NetworkDlg->Reject)
               	{
                  NetworkDlg->Reject=false;
            		int i=NetworkDlg->PlayerList->GetSelIndex();
            		if (i>=0)
                  	{
                     strcpy(WriteDataBlock, "Rejected...");
            			strcat(WriteDataBlock,ComputerName);
                     strcpy(OpponentName, NetworkDlg->ComputerList[i]);
        					WriteBlock(OpponentName);
							}
                  }
            	}

         	if (NetworkDlg->Joined)
         		{
  					if (strcmp(buffer,"GameFull...")==0)
						{
                  MessageBoxes(10);
                  NetworkDlg->Joined=false;
                  NetworkDlg->EnableControls();
                  }
  					if (strcmp(buffer,"DelPlayer..")==0)
						{
                 	NetworkDlg->DeletePlayer(OpponentName);
                  }
    				if (strcmp(buffer,"AddPlayer..")==0)
						{
            		NetworkDlg->AddPossiblePlayer(OpponentName, NameOpp);
                  }
         		if (strcmp(buffer,"StartGame..")==0)
         			{
               	if (strcmp(HostName, OpponentName)==0)
               		{
                  	memcpy(&GameStyle, ReadDataBlock+MAX_COMPUTERNAME_LENGTH+13, sizeof(VariationData));
                     contact=true;
                  	}
            		}
  		     		if (strcmp(buffer,"DelGame....")==0)
         			{
               	if (strcmp(HostName, OpponentName)==0)
               		{
                  	MessageBoxes(12);
                  	NetworkDlg->Joined=false;
                  	NetworkDlg->EnableControls();
               		NetworkDlg->PlayerList->ClearList();
                     first=true;
                  	}
            		}
  					if (strcmp(buffer,"Rejected...")==0)
						{
                  NetworkDlg->Joined=false;
                  NetworkDlg->EnableControls();
                  strcpy(WriteDataBlock,"DeleteMe...");
                  strcat(WriteDataBlock,ComputerName);
                  strcpy(OpponentName, HostName);
                  WriteBlock(OpponentName);
                  MessageBoxes(11);
                  first=true;
                  }
            	}
            }

		if (!NetworkDlg->Available)
      	{
         play=starting=false;
         TwoPlayer=false;
         if (NetworkDlg->Host)
      		{
      		strcpy(WriteDataBlock,"DelGame....");
      		strcat(WriteDataBlock,ComputerName);
      		WriteBlock(0, true);
         	}
			if (NetworkDlg->Joined)
      		{
         	strcpy(WriteDataBlock,"DeleteMe...");
         	strcat(WriteDataBlock,ComputerName);
         	strcpy(OpponentName, HostName);
         	WriteBlock(OpponentName);
         	}
         }
      else
      	{
         Leider=false;
         TwoPlayer=true;
			// Who is on???
         if (NetworkDlg->Host)
      		{
            Leider=true;
            for (int ii=0; ii<4; ii++)
            	{
               HumanPl[ii]=false;
               AckArray[ii]=0;
               }
            int j;
	         for (int ii=0; ii<NetworkDlg->PlayerList->GetCount(); ii++)
   	      	{
               j=ii;
               if ((j==1) || (j==2)) j=3-j;

               strcpy(PlNames[j], NetworkDlg->NameList[ii]);
               strcpy(CNames[j], NetworkDlg->ComputerList[ii]);
               HumanPl[j]=true;
      	      }
      		strcpy(WriteDataBlock,"StartGame..");
      		strcat(WriteDataBlock,ComputerName);
            VariationArray->ReadEntry(NetworkDlg->VariationBox->GetSelIndex(), &GameStyle);
            memcpy(WriteDataBlock+MAX_COMPUTERNAME_LENGTH+13, &GameStyle, sizeof(VariationData));
      		WriteBlock(0, true);
            }
         else
         	{
            strcpy(OpponentName, HostName);
            }
         }
		delete NetworkDlg;
		AckNumber=0;
      AckMessage=0;
      starting=false;
      if (TwoPlayer)
      	{
         if (bInternet) SendBt->Show(true);
			IdStart();
      	}
	#endif
}

void TCardGame::EndTwoPlayer()
{
	if (TwoPlayer)
   	{
		TwoPlayer=false;
   	SendBt->Show(false);
      }
}

#if defined(BI_PLAT_WIN32)
void TCardGame::SendMessageToOthers()
{
   char Buffer[512], Buffer2[512];

   MessageDlg->MessageEdit->GetText(Buffer2, sizeof Buffer2);
   strcpy(Buffer, NamePlayer);
   strcat(Buffer,":");
   strcat(Buffer, Buffer2);
	if (!bInternet || (Leider && bInternet)) MessageDlg->AddMessage(Buffer, false);
   MessageDlg->MessageEdit->SetText("");
   AckMessage++;

   if (Leider)
   	{
   	for (int i=1; i<4; i++)
   		{
      	SendMessageToPlayer(i, Buffer);
         }
      }
   else SendMessageToPlayer(0, Buffer);
}

void TCardGame::SendMessageToPlayer(int i, char message[512])
{
	char MesName[MAX_COMPUTERNAME_LENGTH+1], MailSlotName[MAX_PATH];
   char Buffer[512+12];

	HANDLE hFile;
	DWORD cbWritten;

   if (Leider)
   	{
      if (HumanPl[i])
      	{
         strcpy(MesName, CNames[i]);
         }
      else return;
      }
   else
   	{
      strcpy(MesName, OpponentName);
      }

   if (!bInternet) {

      strcpy(MailSlotName,"\\\\");
      strcat(MailSlotName,MesName);
      strcat(MailSlotName,"\\mailslot\\31W9515M");

      hFile = CreateFile(MailSlotName, GENERIC_WRITE, FILE_SHARE_READ,
         (LPSECURITY_ATTRIBUTES) NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
         (HANDLE) NULL);

      if (hFile == INVALID_HANDLE_VALUE) return;

      Buffer[0]=AckMessage%256;
      Buffer[1]=AckMessage/256;

      strcpy(Buffer+2, ComputerName);

      strcpy(Buffer+3+MAX_COMPUTERNAME_LENGTH, message);
      if (!WriteFile(hFile, Buffer, (DWORD) (sizeof Buffer), &cbWritten, (LPOVERLAPPED) NULL)) {
         //::MessageBox(NULL, "error", "error", MB_OK);
      	}

      CloseHandle(hFile);
      }
   else {
      //we zitten in een internet spel

      strcpy(Buffer, "CHATMESSAGE.");
      strcat(Buffer, message);

      if (Leider) {
         if (HumanPl[i]) {
         	oPlayer[i]->SendMessage(Buffer, strlen(Buffer)+1);
         	}
      	}
      else {
         oPlayer[0]->SendMessage(Buffer, strlen(Buffer)+1);
      	}
   	}


	return;
}

bool TCardGame::ReadMessage()
{
   bool fResult;
	char achID[80],MessageComp[MAX_COMPUTERNAME_LENGTH+1];
   DWORD cbMessage, cMessage, cbRead;
   LPSTR lpszBuffer;

   GetApplication()->PumpWaitingMessages();

   cbMessage = cMessage = cbRead = 0;

   // uitlezen berichten mailslot

   fResult = GetMailslotInfo(hSlot2,  /* mailslot handle         */
        (LPDWORD) NULL,               /* no maximum message size */
        &cbMessage,                   /* size of next message    */

        &cMessage,                    /* number of messages      */
        (LPDWORD) NULL);              /* no read time-out        */

   if (fResult)  // foutmelding verbinding mail-slot
   	{
    	if (cbMessage != MAILSLOT_NO_MESSAGE)  // geen berichten in de queue
			{
		    /* Allocate memory for the message. */
    		lpszBuffer = (LPSTR) GlobalAlloc(GPTR, lstrlen((LPSTR) achID) + cbMessage);

         if (lpszBuffer==NULL) return false; // ERROR! Geen netwerkverbinding.

    		lpszBuffer[0] = '\0';

    		fResult = ReadFile(hSlot2, lpszBuffer, cbMessage, &cbRead, (LPOVERLAPPED) NULL);

    		if (fResult)
         	{
            SendMessage();
            WORD Received;
            Received=lpszBuffer[0]+lpszBuffer[1]*256;
            if (Received>AckMessage)
            	{
               AckMessage=Received;
               MessageDlg->AddMessage(lpszBuffer+2+MAX_COMPUTERNAME_LENGTH+1);
            	if (Leider)
            		{
						strcpy(MessageComp,"");
     				 	strncat(MessageComp, lpszBuffer+2, MAX_COMPUTERNAME_LENGTH+1);
               	for (int i=1; i<4; i++)
               		{
                  	if (strcmp(MessageComp, CNames[i])!=0) SendMessageToPlayer(i, lpszBuffer+2+MAX_COMPUTERNAME_LENGTH+1);
                  	}
               	}
               }
            }
         GlobalFree((HGLOBAL) lpszBuffer);
			}
      }
   return true;
}
#endif

#if defined(BI_PLAT_WIN32)
int TCardGame::ReadBlock(int nSocket, bool name)
{
   bool fResult;
	char Buffer[MAX_COMPUTERNAME_LENGTH + 101],achID[80];
   DWORD cbMessage, cMessage, cbRead;
   int	retval;
   LPSTR lpszBuffer;

   GetApplication()->PumpWaitingMessages();
   if (GameTerminated) return 2;


   cbMessage = cMessage = cbRead = 0;

   if (bInternet) {
   	if (Leider) {
         retval = -1;
         if (ReadBuffer[nSocket]->nUsed>iReadPointer[nSocket]) {
         	ReadBuffer[nSocket]->ReadEntry(iReadPointer[nSocket], &Buffer);
            iReadPointer[nSocket]++;
            iWaitCycle[nSocket]=0;
         	AckReceived=Buffer[12+MAX_COMPUTERNAME_LENGTH];
            memcpy(ReadDataBlock, Buffer+13+MAX_COMPUTERNAME_LENGTH, 88);
            retval = 0;
         	}
      	}
      else {
         retval = -1;
         if (ReadBuffer[0]->nUsed>iReadPointer[0]) {
         	ReadBuffer[0]->ReadEntry(iReadPointer[0], &Buffer);
				iReadPointer[0]++;
            iWaitCycle[0]=0;
         	AckReceived=Buffer[12+MAX_COMPUTERNAME_LENGTH];
            memcpy(ReadDataBlock, Buffer+13+MAX_COMPUTERNAME_LENGTH, 88);
            retval = 0;
         	}
      	}

      if (retval == 0) {
        if (bDebug) {
            char cNumber[5];
            FILE* hLogFile;

            hLogFile = fopen("Debug\\ReadBlock.txt", "a");
            itoa(iReadPointer[nSocket], cNumber, 10);

            if (hLogFile!=NULL) {
               fwrite(Buffer, 1, strlen(Buffer)>10 ? 10 : strlen(Buffer), hLogFile);
               fwrite(" - ", 1, 1, hLogFile);
               fwrite(ReadDataBlock, 1, strlen(ReadDataBlock)>12 ? 12 : strlen(ReadDataBlock), hLogFile);
               fwrite(" - ", 1, 1, hLogFile);
               fwrite(cNumber, 1, strlen(cNumber)>4 ? 4 : strlen(cNumber), hLogFile);
               fwrite("\n", 1, 1, hLogFile);
               fclose(hLogFile);
               }
            }
      	}
   	}
   else {

      ReadMessage();

   // lees andere mailslot uit
      fResult = GetMailslotInfo(hSlot1,  /* mailslot handle         */
           (LPDWORD) NULL,               /* no maximum message size */
           &cbMessage,                   /* size of next message    */

           &cMessage,                    /* number of messages      */
           (LPDWORD) NULL);              /* no read time-out        */

       if (!fResult) { // foutmelding verbinding mail-slot
           return 1;}

       if (cbMessage == MAILSLOT_NO_MESSAGE) { // geen berichten in de queue
           return 1;}

       /* Allocate memory for the message. */

       lpszBuffer = (LPSTR) GlobalAlloc(GPTR, lstrlen((LPSTR) achID) + cbMessage);

       if (lpszBuffer==NULL) return 1;
       lpszBuffer[0] = '\0';

       fResult = ReadFile(hSlot1, lpszBuffer, cbMessage, &cbRead, (LPOVERLAPPED) NULL);

       if (!fResult) { // fout bij ophalen bericht
         GlobalFree((HGLOBAL) lpszBuffer);
         return 1;}


        if (bDebug) {
            char cNumber[5];
            FILE* hLogFile;

            hLogFile = fopen("Debug\\ReadBlock.txt", "a");
            itoa(iReadPointer[nSocket], cNumber, 10);

            if (hLogFile!=NULL) {
               fwrite(Buffer, 1, strlen(Buffer)>10 ? 10 : strlen(Buffer), hLogFile);
               fwrite(" - ", 1, 1, hLogFile);
               fwrite(ReadDataBlock, 1, strlen(ReadDataBlock)>12 ? 12 : strlen(ReadDataBlock), hLogFile);
               fwrite(" - ", 1, 1, hLogFile);
               fwrite(cNumber, 1, strlen(cNumber)>4 ? 4 : strlen(cNumber), hLogFile);
               fwrite("\n", 1, 1, hLogFile);
               fclose(hLogFile);
               }
            }

      strcpy(Buffer,"");
      strncat(Buffer,lpszBuffer,11);

      retval=1;
      if (strcmp(Buffer,"31Win95_1.5")==0)
         {
         strcpy(Buffer,"");
         strncat(Buffer, lpszBuffer+11, MAX_COMPUTERNAME_LENGTH+1);
         if (name)
            {
            if (strcmp(Buffer,OpponentName)==0) retval=0;
            }
         else retval=0;

         if (retval==0)
         {
         AckReceived=lpszBuffer[12+MAX_COMPUTERNAME_LENGTH];
         for (int i=0; i<88; i++)
            {
            ReadDataBlock[i]=lpszBuffer[i+12+MAX_COMPUTERNAME_LENGTH+1];
            }
         }

         if (strcmp(ReadDataBlock,"GameEnd")==0)
            {
            if (Leider && TwoPlayer)
               {
               if (bInternet) {
                  HumanPl[nSocket] = false;
                  delete oPlayer[nSocket];
                  oPlayer[nSocket] = NULL;
               	}
               else {
                  for (int i=1; i<4; i++)
                     {
                     if (HumanPl[i] && (strcmp(Buffer, CNames[i])==0))
                        {
                        HumanPl[i]=false;
                        GameTerminated=false;
                        }
                     }
						}
                  //TwoPlayer=false;
                  //SendBt->Show(false);
               }
            else
               {
               GameTerminated=true;
               }
            retval=retval+2;
            //2 -> speler op wie je wacht stopt ermee.
            //3 -> andere speler stopt ermee.
            }
         }
      GlobalFree((HGLOBAL) lpszBuffer);
		}

   return retval;
}
#endif

#if defined(BI_PLAT_WIN32)
void TCardGame::AckWriteAllPlayers()
{
	for (int i=1; i<4; i++)
   	{
     	AckWritePlayer(i);
      }
}

void TCardGame::AckWritePlayer(int i)
{
	if (HumanPl[i])
   	{
      strcpy(OpponentName, CNames[i]);
      AckNumber=AckArray[i];
   	AckWriteBlock(i);
      AckArray[i]=AckNumber;
      }
}

void TCardGame::AckWriteBlock(int i)
{
   AckNumber++;

   WriteBlock(i);

   if (!bInternet) {RecAck(i);}
}
#endif

#if defined(BI_PLAT_WIN32)
int TCardGame::AckReadBlock(char TestString[20], int nSocket)
{
   int retval=0;
   int n=strlen(TestString);
   char buffer[20];
   FILE* hLogFile;

   bool reply=false;

   if (Leider)
   	{
      strcpy(OpponentName, CNames[nSocket]);
      AckNumber=AckArray[nSocket];
      }

	AckNumber++;

   while ((!reply) && (play))
   	{
      retval=ReadBlock(nSocket);
      if (retval==2) reply=true;
		strcpy(buffer,"");
		strncat(buffer,ReadDataBlock,n);
      if (retval!=1 && !bInternet) SendAck(nSocket, AckReceived);


      if (retval==0) {
         if (bDebug) {
            hLogFile = fopen("Debug\\AckReadBlock.txt", "a");

            if (hLogFile!=NULL) {
               fwrite(TestString, 1, strlen(TestString)>12 ? 12 : strlen(TestString), hLogFile);
               fwrite(" - ", 1, 3, hLogFile);
               fwrite(buffer, 1, strlen(buffer)>12 ? 12 : strlen(buffer), hLogFile);
               fwrite("\n", 1, 1, hLogFile);
               fclose(hLogFile);
               }
            }
         }

      if ((strcmp(buffer,TestString)==0) && ((bInternet && retval==0) || (!bInternet && AckReceived==AckNumber)))
      	{
         reply=true;
         retval=0;
         }
      }
   //AckNumber=AckReceived;
   if (Leider)
   	{
      AckArray[nSocket]=AckReceived;
      }
   return retval;
}
#endif

#if defined(BI_PLAT_WIN32)
void TCardGame::SendAck(int nSocket, int ANumber)
{
   strcpy(WriteDataBlock,"Ack");
   WriteDataBlock[4]=(char)ANumber;
   WriteBlock(nSocket);
}
#endif

#if defined(BI_PLAT_WIN32)
void TCardGame::RecAck(int nSocket)
{
  	bool reply=false;

	TimeOutTeller=0;
 	while ((!reply) && (play))
    	{
		if (TimeOutTeller>=20)
      	{
         WriteBlock(nSocket);
   		TimeOutTeller=0;
	      }

      if (ReadBlock(nSocket)==2) reply=true;
   	else
      	{
         if ((strcmp(ReadDataBlock,"Ack")==0) && (ReadDataBlock[4]==(char)AckNumber))
         		reply=true;
         }
     	}
}
#endif

#if defined(BI_PLAT_WIN32)
bool TCardGame::WriteBlock(char* nameMailSlot, bool BroadCast) {
   strcpy (OpponentName, nameMailSlot);
   WriteBlock(0, BroadCast);
	}

bool TCardGame::WriteBlock(int nSocket, bool BroadCast)
{
	char Buffer[MAX_COMPUTERNAME_LENGTH+101],MailSlotName[MAX_PATH];
	bool fResult;
	HANDLE hFile;
   DWORD cbWritten;

//   ::MessageBox(NULL,WriteDataBlock,"WriteBlock",MB_OK);
	strcpy(Buffer,"31Win95_1.5");
	strcat(Buffer,ComputerName);
	Buffer[12+MAX_COMPUTERNAME_LENGTH]=AckNumber;
   memcpy(Buffer+13+MAX_COMPUTERNAME_LENGTH, WriteDataBlock, 88);

   if (bDebug) {
      char cNumber[5];
      FILE* hLogFile;

      hLogFile = fopen("Debug\\WriteBlock.txt", "a");
      itoa(iWritePointer[nSocket], cNumber, 10);

      if (hLogFile!=NULL) {
         fwrite(Buffer, 1, strlen(Buffer)>10 ? 10 : strlen(Buffer), hLogFile);
         fwrite(" - ", 1, 1, hLogFile);
         fwrite(WriteDataBlock, 1, strlen(WriteDataBlock)>12 ? 12 : strlen(WriteDataBlock), hLogFile);
         fwrite(" - ", 1, 1, hLogFile);
         fwrite(cNumber, 1, strlen(cNumber)>4 ? 4 : strlen(cNumber), hLogFile);
         fwrite("\n", 1, 1, hLogFile);
         fclose(hLogFile);
         }
      }

   if (bInternet) {
   	//het is een internet spel: gebruik de sockets, Broadcast is ignored
      //space voor computername wordt gebruikt voor iWritePointer;

      if (Leider) {
      	memcpy(Buffer+12, &iWritePointer[nSocket], sizeof(iWritePointer[nSocket]));
         WriteBuffer[nSocket]->AddEntry(Buffer);
         iWritePointer[nSocket] = WriteBuffer[nSocket]->nUsed;
         oPlayer[nSocket]->SendMessage(Buffer, sizeof(Buffer));
      	}
      else {
      	memcpy(Buffer+12, &iWritePointer[0], sizeof(iWritePointer[0]));
         WriteBuffer[0]->AddEntry(Buffer);
         iWritePointer[0] = WriteBuffer[0]->nUsed;
      	oPlayer[0]->SendMessage(Buffer, sizeof(Buffer));
      	}
   	}
   else {
      //het is een LAN spel: gebruik de mailslots

      strcpy(MailSlotName,"\\\\");
      if (BroadCast)
         {
         strcat(MailSlotName,"*");
         }
      else
         {
         strcat(MailSlotName,OpponentName);
         }
      strcat(MailSlotName,"\\mailslot\\31W9515G");

      hFile = CreateFile(MailSlotName,
         GENERIC_WRITE,
         FILE_SHARE_READ, /* required to write to a mailslot */
         (LPSECURITY_ATTRIBUTES) NULL,
         OPEN_EXISTING,
         FILE_ATTRIBUTE_NORMAL,
         (HANDLE) NULL);

      if (hFile == INVALID_HANDLE_VALUE) {
         return false;}

      fResult = WriteFile(hFile,
         Buffer,
         (DWORD) MessageSize, /* include terminat. null char. */
         &cbWritten,
         (LPOVERLAPPED) NULL);

      if (!fResult) return false; // fout tijdens het schrijven

      CloseHandle(hFile);
		}

	return true;
	}
#endif

#if defined(BI_PLAT_WIN32)
bool TCardGame::WaitingOpponent(int nSocket)
{
	// return true=Game Terminated else return false
   bool contact=false;
   int result;
   char buffer[25];

if (TwoPlayer)
	{
	if (Leider)
   	{
      while (!contact)
      	{
         result=ReadBlock(nSocket);
         if (result==2) contact=true;
         if (result==0)
         	{
				strcpy(buffer,"");
				strncat(buffer,ReadDataBlock,6);
				if (strcmp(buffer,"Ready?")==0) contact=true;
            }
         }
      if (GameTerminated) return true;
      strcpy(WriteDataBlock,"Ready");
      WriteBlock(nSocket);
      return false;
      }
   else
   	{
      strcpy(WriteDataBlock,"Ready?");
      WriteBlock(nSocket);
      while (!contact)
      	{
         result=ReadBlock(nSocket);
         if (result==2) contact=true;
         if (result==0)
         	{
				strcpy(buffer,"");
				strncat(buffer,ReadDataBlock,5);
				if (strcmp(buffer,"Ready")==0) contact=true;
            }
         }
      return GameTerminated;
      }
	}
   return false;
}
#endif

#if defined(BI_PLAT_WIN32)
void TCardGame::SendMessage()
{
	if (!MessageDlg)
   	{
		MessageDlg= new TMessageDlg(this, (engels ? Message_DlgEN : Message_DlgNL), MessageStruct);
   	MessageDlg->Create();
      strcpy(MessageDlg->OpponentName,OpponentName);
      strcpy(MessageDlg->PlayerName,NamePlayer);
      }
   else
   	{
      strcpy(MessageDlg->OpponentName,OpponentName);
      MessageDlg->Show(SW_NORMAL);
      }
}
#endif

void TCardGame::WisselNL()
{
	GetApplication()->GetMainWindow()->AssignMenu(CD_MENU2);
   CheckMenuItem(Parent->GetMenu(), CM_DUTCH, MF_CHECKED);
   CheckMenuItem(Parent->GetMenu(), CM_ENGLISH, MF_UNCHECKED);
   SetMenuItems(nov,adv,exp);
   if (!TestRegistration())
		{
      TMenu Menu(Parent->GetMenu());
		Menu.InsertMenu(3, MF_BYPOSITION, IDC_REGISTRATE, "&Registreren");
		Parent->DrawMenuBar();
      }
 	ChangeBt->SetCaption("&Wissel");
   PassBt->SetCaption("&Pas");
   ChgAllBt->SetCaption("&Neem Pot");
	DealBt->SetCaption("&Delen");
   engels=false;
	WriteRegistryString(OptionName,"Language","Nl");
}

void TCardGame::RegisterThis()
{
	TRegDlg(this, engels ? RegisterDlgEN : RegisterDlgNL , engels).Execute();
	if (TestRegistration())
   	{
      if (engels)
      	{
         WisselEN();
         }
      else
      	{
         WisselNL();
         }
      }
}

void TCardGame::WisselEN()
{
	GetApplication()->GetMainWindow()->AssignMenu(CD_MENU1);
   CheckMenuItem(Parent->GetMenu(), CM_DUTCH, MF_UNCHECKED);
   CheckMenuItem(Parent->GetMenu(), CM_ENGLISH, MF_CHECKED);
   SetMenuItems(nov,adv,exp);
   if (!TestRegistration())
		{
      TMenu Menu(Parent->GetMenu());
		Menu.InsertMenu(3, MF_BYPOSITION, IDC_REGISTRATE, "&Register");
		Parent->DrawMenuBar();
      }
 	ChangeBt->SetCaption("&Change");
   PassBt->SetCaption("&Pass");
   ChgAllBt->SetCaption("&Take Pot");
	DealBt->SetCaption("&Deal");
   engels=true;
	WriteRegistryString(OptionName,"Language","En");
}

void TCardGame::ShowCheat()
{
   CheatField->Show(SW_SHOW);
   OkCheat->Show(SW_SHOW);
}

void TCardGame::CheckCheat()
{
   CheatField->Show(SW_HIDE);
   OkCheat->Show(SW_HIDE);
   Cheat=false;
   char string[7];

   CheatField->GetText(string, 7);
   CheatField->SetText("");
	for (int j=0; j<6; j++)
   	string[j]++;

   if ((strcmp(string,"llyk29")==0) && (strcmp(NamePlayer,"Rainier")==0)) Cheat=true;  //kkxj18
}

void TCardGame::HandleTooltipTextLinks(TTooltipText& tiTxt)
{
    if (!Cheat)
    	{
      tiTxt.CopyText("");
      return;
      }
    char string[50];
    MakeCheatString(string, 3);
    tiTxt.CopyText(string);
}

void TCardGame::HandleTooltipTextBoven(TTooltipText& tiTxt)
{
    if (!Cheat)
    	{
      tiTxt.CopyText("");
      return;
      }
    char string[50];
    MakeCheatString(string, 6);
    tiTxt.CopyText(string);
}

void TCardGame::HandleTooltipTextRechts(TTooltipText& tiTxt)
{
    if (!Cheat)
    	{
      tiTxt.CopyText("");
      return;
      }
    char string[50];
    MakeCheatString(string, 9);
    tiTxt.CopyText(string);
}

void TCardGame::HandleTooltipTextPot(TTooltipText& tiTxt)
{
    if (!Cheat)
    	{
      tiTxt.CopyText("");
      return;
      }
    char string[50];
    MakeCheatString(string, 12);
    tiTxt.CopyText(string);
}

void TCardGame::MakeCheatString(char* string, int n)
{
   char punten[10];
   strcpy(string, "");
	MakeCardString(string, n);
   strcat(string, ", ");
   MakeCardString(string, n+1);
   strcat(string, ", ");
   MakeCardString(string, n+2);
   itoa(CalcPoints(n/3),punten,10);
   strcat(string, ", pt:");
   strcat(string, punten);
}

void TCardGame::MakeCardString(char* string, int n)
{
	switch ((Cards[n]-1)/8)
   	{
      case 0: {strcat(string, "Ruiten "); break;}
      case 1: {strcat(string, "Harten "); break;}
      case 2: {strcat(string, "Schoppen "); break;}
      case 3: {strcat(string, "Klaver "); break;}
      }
	switch (((Cards[n]-1)%8)+7)
      {
      case 7: {strcat(string,"7"); break;}
      case 8: {strcat(string,"8"); break;}
      case 9: {strcat(string,"9"); break;}
      case 10: {strcat(string,"10"); break;}
      case 11: {strcat(string,"Boer"); break;}
      case 12: {strcat(string,"Vrouw"); break;}
      case 13: {strcat(string,"Heer"); break;}
      case 14: {strcat(string,"Aas"); break;}
      }
}

void TCardGame::HandleTooltipText(TTooltipText& tiTxt)
{
	if (play)
   	{
      tiTxt.CopyText(GameStyle.VarName);
      }
   else
   	{
      tiTxt.CopyText("");
      }
}

void TCardGame::PutGameTypeIcon()
{
	if (GameTypeIcon==0) return;
   #if !defined(DenOudstenVersie)
   TClientDC dc(*this);
	TMemoryDC bits(dc);

	TBitmap GameIcon1(*GetApplication(), NormalTypeIcon);
   bits.SelectObject(GameIcon1);
	dc.BitBlt(592,16,32,32,bits,0,0,SRCCOPY);
#endif
}

int TCardGame::MessageBoxes(int ID)
{
	switch (ID)
   	{
 		case 0: {if (engels) return MessageBox("Do you really want to erase the statistics ?","Erase statistics",MB_YESNO | MB_ICONQUESTION);
      					else return MessageBox("Wil je de statistieken echt verwijderen ?","Verwijderen statistieken",MB_YESNO | MB_ICONQUESTION);
         	  }
		case 1: {if (engels) return MessageBox("Terminate game ?","Game in progress",MB_YESNO | MB_ICONQUESTION);
      					else return MessageBox("Spel verlaten ?","Spel is bezig",MB_YESNO | MB_ICONQUESTION);
      			}
      case 2: {if (engels) return MessageBox("Other player left the game, terminating game.","Error", MB_OK);
      					else return MessageBox("Andere speler heeft het spel verlaten, spel wordt gestopt.","Foutmelding", MB_OK);
      			}
      case 4: {if (engels) return MessageBox("Level set to Novice","Change Level",MB_OK);
      					else return MessageBox("Niveau gezet op Beginner","Verander Niveau",MB_OK);
      			}
      case 5: {if (engels) return MessageBox("Level set to Advanced","Change Level",MB_OK);
      					else return MessageBox("Niveau gezet op Gevorderd","Verander Niveau",MB_OK);
      			}
      case 6: {if (engels) return MessageBox("Level set to Expert","Change Level",MB_OK);
      					else return MessageBox("Niveau gezet op Expert","Verander Niveau",MB_OK);
      			}
      case 7: {if (engels) return MessageBox("Can't make a network connection!","Error",MB_OK);
      					else return MessageBox("Kan geen netwerk-verbinding maken!","Foutmelding",MB_OK);
      			}
		case 8: {return MessageBox(engels ? "Link has been terminated by your opponent" :
      							"Connectie is afgebroken door uw tegenstander",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 9: {return MessageBox(engels ? "Error loading backside picture, using default." :
      							"Er is een fout ontstaan bij het inladen van het plaatje voor"
                           " de achterkant van de kaart.",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 10: {return MessageBox(engels ? "This game is full." :
      							"Dit spel is vol.",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 11: {return MessageBox(engels ? "The host rejected you from the game." :
      							"De gastheer heeft u uitgesloten van het spel.",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 12: {return MessageBox(engels ? "The host terminated the game." :
      							"De gastheer heeft het spel afgesloten.",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 13: {return MessageBox(engels ? "You want to play on your own?" :
      							"Wil je in je eentje spelen?",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 14: {return MessageBox(engels ? "Can't get your computer's name! Check your networksettings" :
      							"Kan de computernaam niet inlezen! Controleer deze bij uw netwerkinstellingen",
                           engels ? "Error" : "Foutmelding", MB_OK);}
		case 15: {return MessageBox(engels ? "Cannot connect to host." :
      							"Kan geen verbinding maken met de host",
                           engels ? "Error" : "Foutmelding", MB_OK);}
      }
	return NULL;
}

void TCardGame::IdAbout()
{
 	TPropertySheet* ps = new TMyPropertySheet(this, engels ? "About" : "Info" ,0 ,false,PSH_NOAPPLYNOW);

  	TAboutDialog* FSD= new TAboutDialog(ps, engels ? AboutBoxEN : AboutBoxNL);

  	ps->Execute();
}

