#include "main.h"
#pragma hdrstop

#include "31win.h"
#include "dynarray.h"
#include "31windlg.h"
#include "idh_constants.h"
//#include "htmlhelp.h"




void CenterDialog::SetupWindow()
{
	TDialog::SetupWindow();
	int x=Parent->GetWindowRect().left+
		(Parent->GetWindowRect().Width()-GetWindowRect().Width())/2;
	int y=Parent->GetWindowRect().top+
		(Parent->GetWindowRect().Height()-GetWindowRect().Height())/2;
	MoveWindow(x,y,GetWindowRect().Width(), GetWindowRect().Height());
}
//-----------------------------------------------------------------------------
TInternetButton::TInternetButton(TWindow* parent, int resId) :
	TButton(parent, resId)
{
   InternetFont= new TFont("MS Sans Serif", 8,6,0,0,FW_NORMAL,
   								DEFAULT_PITCH|FF_DONTCARE,false,true,false);
}

TInternetButton::~TInternetButton()
{
	delete InternetFont;
}

void TInternetButton::SetupWindow()
{
	TButton::SetupWindow();

   SetWindowFont(*InternetFont, true);
   SetCursor(GetApplication(), IDC_HAND);
}

void TInternetButton::ODADrawEntire(DRAWITEMSTRUCT far& drawInfo)
{
  char caption[100];
  TDC drawDC(drawInfo.hDC);


  TRect itemRect(drawInfo.rcItem.left, drawInfo.rcItem.top,
                 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
  drawDC.FillRect(itemRect, TBrush(TColor::Sys3dFace));

  SetTextColor(drawDC, TColor::LtBlue);
 
  GetWindowText(caption, sizeof(caption));
  drawDC.SelectObject(TPen(TColor(0,0,255)));
  drawDC.DrawText(caption, -1, itemRect, DT_CENTER | DT_VCENTER);
  drawDC.RestorePen();
}
//-----------------------------------------------------------------------
TWizardDlg::TWizardDlg(TWindow* parent, int ResId, TWizardStruct& transfer)
  : CenterDialog(parent, ResId)

{
   new TRadioButton(this, IDC_STARTSINGLE,0);
   new TRadioButton(this, IDC_STARTNETWORK,0);
   new TRadioButton(this, IDC_STARTINTERNET,0);
	new TCheckBox(this, IDC_DONTSHOW,0);

 	SetTransferBuffer(&transfer);
}
//-----
DEFINE_RESPONSE_TABLE1(TOptieDlg, CenterDialog)
  	EV_LBN_SELCHANGE(IDC_FILELIST, FileClicked),
	EV_COMMAND(IDC_STANDARDPIC, EnableControls),
   EV_COMMAND(IDC_USERPIC, EnableControls),
   EV_COMMAND(IDC_EDITVAR, EditVariations),
   EV_COMMAND(IDC_OPTIEOK, OkPressed),
	EV_COMMAND_ENABLE(IDC_VARIATIONCOMBO, CePlay),
	EV_COMMAND_ENABLE(IDC_EDITVAR, CeRegTest),
	EV_COMMAND_ENABLE(IDC_Name1, CePlay),
	EV_COMMAND_ENABLE(IDC_Name2, CePlay),
	EV_COMMAND_ENABLE(IDC_Name3, CePlay),
	EV_COMMAND_ENABLE(IDC_Name4, CePlay),
	EV_WM_DRAWITEM,
    #if defined(BI_PLAT_WIN32)
   EV_WM_HELP,
   #endif
	EV_LBN_SELCHANGE(IDC_VARIATIONCOMBO, CeRegtest),
END_RESPONSE_TABLE;

TOptieDlg::~TOptieDlg()
{
}

void TOptieDlg::EditVariations()
{
	TVariationDlg* VarDlg;
   VariationData VarData;
   
   VarDlg = new TVariationDlg(this, engels ? VariationDlgEN : VariationDlgNL, engels);

   if (VarDlg->Execute()==IDOK)
   	{
      VarDlg->SaveRules();
      VariationArray->Clear();
      TVariationDlg::LoadRules(VariationArray);
      VariationCombo->ClearList();
   	for (int i=0; i<VariationArray->nUsed; i++)
   		{
      	VariationArray->ReadEntry(i, &VarData);
      	VariationCombo->AddString(VarData.VarName);
      	}
   	VariationCombo->SetSelString(VarSelName, 0);
      if (VariationCombo->GetSelIndex()<0)
      	{
         VariationCombo->SetSelIndex(0);
         }
      }

   delete VarDlg;
}

void TOptieDlg::CeRegtest()
{
	if (!TestRegistration())
   	{
      if (VariationCombo->GetSelIndex()!=0)
      	{
      	TOrderDlg(this, engels ? NotAvailableDlgEN : NotAvailableDlgNL, engels).Execute();
			VariationCombo->SetSelIndex(0);
         }
		}
}

void TOptieDlg::CeRegTest(TCommandEnabler& ce)
{
	ce.Enable((!Play) && (TestRegistration()));
}

void TOptieDlg::CePlay(TCommandEnabler& ce)
{
  	ce.Enable(!Play);
}

void TOptieDlg::OkPressed()
{
   VariationCombo->GetString(VarSelName, VariationCombo->GetSelIndex());
	CenterDialog::CmOk();
}

void TOptieDlg::EvDrawItem(uint ctrlId, DRAWITEMSTRUCT far& drawInfo)
{
  TDib* DibCard;
  char  FileName[MAX_PATH+1];
  char  Buffer[MAX_PATH+1];
  TDC drawDC(drawInfo.hDC);
  TRect itemRect(drawInfo.rcItem.left, drawInfo.rcItem.top,
                 drawInfo.rcItem.right, drawInfo.rcItem.bottom);

   if (ReadRegistryInt(OptionName,"StandardBackside",0)!=0)
   	{
  		strcpy (FileName, ReadRegistryString(OptionName,"Picture","",Buffer,MAX_PATH));
  		DibCard = new TDib(FileName);
      }
   else
   	{
      DibCard= new TDib(*GetApplication(), (TResId)33);
      }

	bool Pal=true;
   TPalette* CardPicPal;

   try
     	{
      CardPicPal= new TPalette(*DibCard);
     	}
   catch (...)
     	{
      Pal=false;
      }

  	if (Pal)
    	{
    	drawDC.SelectObject(*CardPicPal);
  		drawDC.RealizePalette();
    	}

	drawDC.SetDIBitsToDevice(TRect(0,0,71,96), TPoint(0,0), *DibCard);

	if (Pal)
     	{
      drawDC.RestorePalette();
      delete CardPicPal;
     	}

  delete DibCard;
}

TOptieDlg::TOptieDlg(TWindow* parent, int ResId, bool taal, char name[26],
		TOptieStruct& transfer, TDynamicArray* VarArray)
  : CenterDialog(parent, ResId)

{
   VariationArray = VarArray;
  	new TEdit(this, IDC_Name1, sizeof(transfer.PName1));
 	new TEdit(this, IDC_Name2, sizeof(transfer.PName2));
 	new TEdit(this, IDC_Name3, sizeof(transfer.PName3));
	#if defined(BI_PLAT_WIN32)
   Slider=new THSlider(this, IDC_SCROLLBAR1);
   Slider->SetRuler(1,true);
   Slider->SetPageMagnitude(1);
   Slider->SetLineMagnitude(1);
   #else
   SlowButton= new TRadioButton(this, IDC_RADIOSLOW,0);
   MediumButton= new TRadioButton(this, IDC_RADIOMEDIUM,0);
   FastButton= new TRadioButton(this, IDC_RADIOFAST,0);
   #endif
 	new TEdit(this, IDC_Name4, sizeof(transfer.PName4));
   new TRadioButton(this, IDC_SOUNDON,0);
   new TRadioButton(this, IDC_SOUNDOFF,0);

 	SetTransferBuffer(&transfer);
   FileList= new TListBox(this, IDC_FILELIST);
   FileList->DisableTransfer();
   VariationCombo = new TComboBox(this, IDC_VARIATIONCOMBO, 65);
   VariationCombo->DisableTransfer();
   BitmapControl = new TControl(this, IDC_STATICBITMAP1);
	BitmapControl -> DisableTransfer();
   engels=taal;
   strcpy(OptionName, name);
}

#if defined(BI_PLAT_WIN32)
void TOptieDlg::EvHelp(HELPINFO far& h)
{
	int Id=0;

	if (h.iContextType==HELPINFO_WINDOW)
   	{
      switch (h.iCtrlId) {
      	case IDC_SCROLLBAR1: { Id=IDH_AnimationSpeed; break; }
         case IDC_Name1: {Id=IDH_OpponentName; break;}
         case IDC_Name2: {Id=IDH_OpponentName; break;}
         case IDC_Name3: {Id=IDH_OpponentName; break;}
         case IDC_Name4: {Id=IDH_OpponentName; break;}
      	case IDC_VARIATIONCOMBO: { Id=IDH_SelectVariant; break; }
      	case IDC_EDITVAR: { Id=IDH_EditVariation; break; }
      	case IDC_FILELIST: { Id=IDH_BitmapFile; break; }
      	case IDC_SOUNDON: { Id=IDH_SoundOn; break; }
      	case IDC_SOUNDOFF: { Id=IDH_SoundOff; break; }
		};
		if (Id!=0) {

			DWORD ids[3] ;
	  		ids[0] = h.iCtrlId ;
	  		ids[1] = Id ;
	  		ids[2] = 0 ;

			//WinHelp(engels ? "31WIN-EN.CHM" : "31WIN-NL.CHM", HELP_CONTEXTPOPUP, Id);
			/*HtmlHelp(GetItemHandle(h.iCtrlId), engels ? "31WIN-EN.CHM::/TextPopups.txt" : "31WIN-NL.CHM::/TextPopups.txt",
         			HH_TP_HELP_CONTEXTMENU, (DWORD) ids)  ;   */


			}
	}
}
#endif

void TOptieDlg::FileClicked()
{
	char Buffer[MAX_PATH];

  	if (FileList->GetSelString(Buffer, sizeof(Buffer))>1)
   	{
      if (FileList->GetSelIndex()==0)
      	{
			WriteRegistryInt(OptionName,"StandardBackside",0);
         }
      else
      	{
			WriteRegistryInt(OptionName,"StandardBackside",1);
			WriteRegistryString(OptionName, "Picture", Buffer);
         }
      BitmapControl->Invalidate();
      }
}

void TOptieDlg::SetupWindow()
{
  	char  FileName[MAX_PATH+1];
  	char  Buffer[MAX_PATH+1];
   VariationData VarData;

   CenterDialog::SetupWindow();

	FileList->DirectoryList(0, "*.bmp");
	FileList->InsertString(engels ? "(standard)" : "(standaard)", 0);
   if (ReadRegistryInt(OptionName,"StandardBackside",0)!=0)
   	{
  		strcpy (FileName, ReadRegistryString(OptionName,"Picture","",Buffer,MAX_PATH));
      FileList->SetSelString(FileName, 0);
      }
  if (FileList->GetSelIndex()==-1)
   	{
      FileList->SetSelIndex(0);
      }
   FileClicked();

   for (int i=0; i<VariationArray->nUsed; i++)
   	{
      VariationArray->ReadEntry(i, &VarData);
      VariationCombo->AddString(VarData.VarName);
      }
  	VariationCombo->SetSelString(VarSelName, 0);
   if (VariationCombo->GetSelIndex()<0)
    	{
      VariationCombo->SetSelIndex(0);
      }
}

void TOptieDlg::EnableControls()
{
}

//-----------------------------------------------------------------------------
TNameDlg::TNameDlg(TWindow* parent,int ResId,TNameStruct& transfer)
  : CenterDialog(parent, ResId)
{
   TComboBox* NameBox=new TComboBox(this, ID_NAME);
   NameBox->SetTextLimit(15);
 	SetTransferBuffer(&transfer);
}

//-----------------------------------------------------------------------------
TStartInternetDlg::TStartInternetDlg(TWindow* parent,int ResId, TInternetGameStruct& transfer)
  : CenterDialog(parent, ResId)
{
   TComboBox* NameCombo=new TComboBox(this, IDC_NAME);
   NameCombo->SetTextLimit(15);

	radioHost   = new TRadioButton(this, IDC_YESHOST, 0);
   radioClient = new TRadioButton(this, IDC_NOCLIENT, 0);

		TComboBox* IPCombo=new TComboBox(this, IDC_MYIP);
	//IPCombo->SetTextLimit(128);

   IPHost = new TEdit(this, IDC_HOSTIP, sizeof(transfer.cHostIP));

 	SetTransferBuffer(&transfer);

   txtStep1 = new TStatic(this, IDC_TXTSTEP1);
   txtStep2 = new TStatic(this, IDC_TXTSTEP2);
   txtStep3a = new TStatic(this, IDC_TXTSTEP3A);
   txtStep3b = new TStatic(this, IDC_TXTSTEP3B);
   }

TStartInternetDlg::~TStartInternetDlg() {

	delete oBoldFont;
	}

DEFINE_RESPONSE_TABLE1(TStartInternetDlg, CenterDialog)
	EV_COMMAND(IDC_YESHOST, CmRadioHost),
   EV_COMMAND(IDC_NOCLIENT, CmRadioClient),
END_RESPONSE_TABLE;


void TStartInternetDlg::SetupWindow() {

	CenterDialog::SetupWindow();
	oBoldFont = new TFont("MS Sans Serif", 8, 0, 0, 0, FW_BOLD);

	txtStep1->SetWindowFont(*oBoldFont, true);
	txtStep2->SetWindowFont(*oBoldFont, true);
	txtStep3a->SetWindowFont(*oBoldFont, true);
	txtStep3b->SetWindowFont(*oBoldFont, true);
}

void TStartInternetDlg::CmRadioHost() {
   IPHost->Show(SW_HIDE);
	HWND test;
	test = GetDlgItem(IDC_MYIP);

	::ShowWindow(test, SW_SHOW);
	txtStep3a->Show(SW_SHOW);
   txtStep3b->Show(SW_HIDE);
	}

void TStartInternetDlg::CmRadioClient() {
   IPHost->Show(SW_SHOW);

	HWND test;
	test = GetDlgItem(IDC_MYIP);

	::ShowWindow(test, SW_HIDE);

	//IPCombo->Show(SW_HIDE);
   txtStep3a->Show(SW_HIDE);
   txtStep3b->Show(SW_SHOW);
	}

//-----------------------------------------------------------------------------







//-----------------------------------------------------------------------------
TAppWinDlg::TAppWinDlg(TWindow* parent, int resId, TLoserStruct& transfer)
  :	CenterDialog(parent, resId)
{
 TStatic* statxt;
  statxt= new TStatic(this,ID_NameApp,sizeof transfer.AppName);
  statxt->EnableTransfer();
  SetTransferBuffer(&transfer);
}
//-----------------------------------------------------------------------------
TStatDlg::TStatDlg(TWindow* parent, int resId, TStatStruct& transfer)
  :	CenterDialog(parent, resId)
{
 TStatic* statxt;
  statxt= new TStatic(this,ID_SESPER,sizeof transfer.SesPer);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_SESWON,sizeof transfer.SesWon);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_SESLOST,sizeof transfer.SesLost);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_TOTPER,sizeof transfer.TotPer);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_TOTWON,sizeof transfer.TotWon);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_TOTLOST,sizeof transfer.TotLost);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_SERWON,sizeof transfer.SerWon);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_SERLOST,sizeof transfer.SerLost);
  statxt->EnableTransfer();
  statxt= new TStatic(this,ID_SERROW,sizeof transfer.Serrow);
  statxt->EnableTransfer();
  SetTransferBuffer(&transfer);
}
//-----------------------------------------------------------------------------
TOrderDlg::TOrderDlg(TWindow* parent, int resId, bool engels)
  :	CenterDialog(parent, resId)
{
	Engels=engels;
}

DEFINE_RESPONSE_TABLE2(TOrderDlg, CenterDialog, TDialog)
   EV_COMMAND(IDC_REGISTER, RegisterUser),
   EV_COMMAND(IDC_ORDERONLINE, OrderOnline),
END_RESPONSE_TABLE;

void TOrderDlg::OpenRegtxt()
{
	ShellExecute(NULL, "open", "register.txt", NULL, NULL, SW_SHOWNORMAL);
}

void TOrderDlg::RegisterUser()
{
	TRegDlg(this, Engels ? RegisterDlgEN : RegisterDlgNL , Engels).Execute();
   if (TestRegistration()) CloseWindow(IDOK);
}

void TOrderDlg::OrderOnline()
{
	::ShellExecute(NULL, "open", "http://register31.meusesoft.com", NULL, NULL, SW_SHOWNORMAL);
}
//-----------------------------------------------------------------------------
TRegDlg::TRegDlg(TWindow* parent, int resId, bool engels)
  :	CenterDialog(parent, resId)
{
	Engels=engels;
   RegEdit= new TEdit(this, IDC_REGEDIT ,20);
}

DEFINE_RESPONSE_TABLE2(TRegDlg, CenterDialog, TDialog)
   EV_COMMAND(IDC_REGISTERNOW, RegisterNow),
END_RESPONSE_TABLE;

void TRegDlg::RegisterNow()
{
   char Number[9];
	char Buffer[3];
   strcpy(Buffer,"TT");
   Buffer[0]=Buffer[0]-1;
   Buffer[1]=Buffer[1]-2;

   RegEdit->GetText(Number, 8);

	WRegisterInt("",Buffer,atoi(Number));

   if (TestRegistration())
   	{
		::MessageBox(NULL, Engels ? "Thank you for registering 31 for Windows." :
      	"Bedankt voor het registreren van 31 for Windows.", Engels ? "Registration" :
         "Registratie" , MB_ICONINFORMATION|MB_OK);
   	}
   else
   	{
      ::MessageBox(NULL, Engels ? "Invalid registration code" : "Ongeldig registratienummer",
      	Engels ? "Registration" : "Registratie", MB_ICONERROR|MB_OK);
      }
      
   CenterDialog::CmOk();
}
//-----------------------------------------------------------------------------
#if defined(BI_PLAT_WIN32)
DEFINE_RESPONSE_TABLE2(TNetworkDlg, CenterDialog, TDialog)
	EV_LBN_SELCHANGE(IDC_GAMESBOX, GetPlayers),
   EV_COMMAND(IDC_CANCEL, Stop),
   EV_COMMAND(IDC_SELECT, WannaJoin),
   EV_COMMAND(IDC_HOSTGAME, IAmHost),
   EV_COMMAND(IDC_REJECT, PressReject),
   EV_COMMAND(IDC_START, PressStart),
   EV_COMMAND(IDC_INFOBUTTON, Info),
	EV_LBN_SELCHANGE(IDC_GAMETYPEBOX, TestReg),
END_RESPONSE_TABLE;

TNetworkDlg::TNetworkDlg(TWindow* parent, int ResId, bool engels, TDynamicArray* VarArray)
	: CenterDialog(parent, ResId)
{
   VariationArray = VarArray;
	PlayerList = new TListBox(this, IDC_PLAYERBOX);
	GamesList = new TListBox(this, IDC_GAMESBOX);
	JoinBut= new TButton(this, IDC_SELECT);
   HostBut= new TButton(this, IDC_HOSTGAME);
   RejectBut= new TButton(this, IDC_REJECT);
   StartBut= new TButton(this, IDC_START);
   InfoBut= new TButton(this, IDC_INFOBUTTON);
   VariationBox = new TComboBox(this, IDC_GAMETYPEBOX);

   PlSelected=false;
   Available=true;
	Host=Joined=Reject=Spelen=WantPlayers=false;
   Engels=engels;
};

void TNetworkDlg::TestReg()
{
	if (!TestRegistration())
   	{
      if (VariationBox->GetSelIndex()!=0)
      	{
      	TOrderDlg(this, Engels ? NotAvailableDlgEN : NotAvailableDlgNL, Engels).Execute();
         VariationBox->SetSelIndex(0);
         }
		}
}

void TNetworkDlg::Info()
{
	WantInfo=true;
}

void TNetworkDlg::PressReject()
{
	Reject=true;
}

void TNetworkDlg::GetPlayers()
{
	WantPlayers=true;
  	EnableControls();
}

void TNetworkDlg::PressStart()
{
	Spelen=true;
}

void TNetworkDlg::SetupWindow()
{
	VariationData VarData;

	CenterDialog::SetupWindow();

   for (int i=0; i<VariationArray->nUsed; i++)
   	{
      VariationArray->ReadEntry(i, &VarData);
      VariationBox->AddString(VarData.VarName);
      }

  	EnableControls();
}

void	TNetworkDlg::IAmHost()
{
  Host=true;
  EnableControls();
}

void TNetworkDlg::WannaJoin()
{
	Joined=true;
   EnableControls();
}

void TNetworkDlg::EnableControls()
{
	JoinBut->EnableWindow((!Host) && (!Joined) && (GamesList->GetSelIndex()>=0));
	InfoBut->EnableWindow((!Host) && (!Joined) && (GamesList->GetSelIndex()>=0));
   HostBut->EnableWindow((!Host) && (!Joined));
   RejectBut->EnableWindow(Host);
   StartBut->EnableWindow(Host);
   VariationBox->EnableWindow((!Host) && (!Joined));
   PlayerList->EnableWindow(Host);
   GamesList->EnableWindow((!Host) && (!Joined));
}

void TNetworkDlg::AddGame(char name[MAX_COMPUTERNAME_LENGTH], char OppName[50])
{
	bool found=false;
   int n=GamesList->GetCount();

   for (int i=0; i<n; i++)
   	{
      if (strcmp(name, ComputerGamesList[i])==0) found=true;
      }
   if ((n==0) || ((!found)) && (n<100))
   	{
      GamesList->AddString(OppName);
		strcpy(ComputerGamesList[n], name);
      strcpy(NameGamesList[n], OppName);
      }
}

void TNetworkDlg::DeleteGame(char name[MAX_COMPUTERNAME_LENGTH])
{
   int index;
   int n=GamesList->GetCount();

   index=-1;
   for (int i=0; i<n; i++)
   	{
      if (strcmp(name, ComputerGamesList[i])==0) index=i;
      }

	if (index>=0)
   	{
      GamesList->DeleteString(index);
      for (int i=index; i<n-1; i++)
      	{
         strcpy(ComputerGamesList[i], ComputerGamesList[i+1]);
         strcpy(NameGamesList[i], NameGamesList[i+1]);
         }
      }
}

void TNetworkDlg::AddPossiblePlayer(char name[MAX_COMPUTERNAME_LENGTH], char OppName[21])
{
	bool found=false;
   int n=PlayerList->GetCount();

   for (int i=0; i<n; i++)
   	{
      if (strcmp(name, ComputerList[i])==0) found=true;
      }
   if ((n==0) || ((!found)) && (n<4))
   	{
      PlayerList->AddString(OppName);
		strcpy(ComputerList[n], name);
      strcpy(NameList[n], OppName);
      }
}

void TNetworkDlg::DeletePlayer(char name[MAX_COMPUTERNAME_LENGTH])
{
   int index;
   int n=PlayerList->GetCount();

   index=-1;
   for (int i=0; i<n; i++)
   	{
      if (strcmp(name, ComputerList[i])==0) index=i;
      }

	if (index>=0)
   	{
      PlayerList->DeleteString(index);
      for (int i=index; i<n-1; i++)
      	{
         strcpy(ComputerList[i], ComputerList[i+1]);
         strcpy(NameList[i], NameList[i+1]);
         }
      }
}

void TNetworkDlg::Select()
{
   char BufName[21];
   int n=PlayerList->GetCount();
   int i=0;
   bool found=false;;

   if (PlayerList->GetSelString(BufName, sizeof BufName)<1) return;
   while ((i<n) && (!found))
   	{
      if (strcmp(BufName, NameList[i])==0)
      	{
         found=true;
         strcpy(PlName, ComputerList[i]);
         }
      i++;
      }
	PlSelected=true;
}

void TNetworkDlg::Stop()
{
	Available=false;
}
//-----------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(TLinkDlg, TDialog)
	EV_COMMAND(IDC_Cancel,TerminateWaiting),
END_RESPONSE_TABLE;

TLinkDlg::TLinkDlg(TWindow* parent,int ResId)
  : CenterDialog(parent, ResId)
{
	Waiting=true;
}

void TLinkDlg::TerminateWaiting()
{
	Waiting=false;
}
//-----------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(TMessageDlg, TDialog)
   EV_COMMAND(IDC_SEND, SendMessage),
   EV_COMMAND(IDC_CLEAR, ClearListbox),
   EV_COMMAND(IDC_HIDE, HideDialog),
  EV_COMMAND(IDOK, CmOk),
  EV_COMMAND(IDCANCEL, CmCancel),
END_RESPONSE_TABLE;

TMessageDlg::TMessageDlg(TWindow* parent, int ResId, TMessageStruct& transfer)
	: CenterDialog(parent, ResId)
{
	MessageEdit = new TEdit(this, IDC_EDITMESSAGE);
 	SetTransferBuffer(&transfer);
	MessageList = new TListBox(this, IDC_RECMES);
	MessageList->DisableTransfer();
   Parent=parent;
};

void TMessageDlg::SetupWindow()
{
   CenterDialog::SetupWindow();
  	//MessageList->SetHorizontalExtent(1000);
}

void TMessageDlg::AddMessage(char Message[512], bool reply)
{
   MessageList->AddString(Message);

   if (MessageList->GetCount()>8)
   	{
      MessageList->SetTopIndex(MessageList->GetCount()-8);
      }
  	TSize extent = TClientDC(MessageList->HWindow).GetTextExtent(Message, strlen(Message));
   if (extent.cx>MessageList->Attr.W)
     	{
      MessageList->SetHorizontalExtent(extent.cx);
      }
}

void TMessageDlg::HideDialog()
{
	Show(false);
}


void TMessageDlg::SendMessage()
{
   Parent->PostMessage(WM_USER,1,0);

}

void TMessageDlg::ClearListbox()
{
	MessageList->ClearList();
  	MessageList->SetHorizontalExtent(0);
}

void TMessageDlg::CmOk()
{
   char Buffer[512];

   MessageEdit->GetText(Buffer, sizeof Buffer);
   if (strlen(Buffer)>0) SendMessage();
	return;
}

void TMessageDlg::CmCancel()
{
	return;
}

//-------
DEFINE_RESPONSE_TABLE1(TCompanyDialog, TPropertyPage)
    EV_COMMAND(IDC_HOMEPAGE, GoToInternet),
END_RESPONSE_TABLE;

TCompanyDialog::TCompanyDialog(TPropertySheet* parent, int ResId):
	TPropertyPage(parent, ResId, 0, 0)
{
	InetButton = new TInternetButton(this, IDC_HOMEPAGE);
}

TCompanyDialog::~TCompanyDialog()
{
	delete InetButton;
}

void TCompanyDialog::GoToInternet()
{
	::ShellExecute(NULL, "open", "http://www.ultisoft.com", NULL, NULL, SW_SHOWNORMAL);
}
//-------
DEFINE_RESPONSE_TABLE1(TAboutDialog, TPropertyPage)
    EV_WM_DRAWITEM,
    EV_COMMAND(IDC_MEUSESOFT, GoToMeusesoft),
END_RESPONSE_TABLE;

TAboutDialog::TAboutDialog(TPropertySheet* parent, int ResId):
	TPropertyPage(parent, ResId, 0, 0)
{
	Static1= new TStatic(this, IDC_STATIC1);
   MSButton = new TInternetButton(this, IDC_MEUSESOFT);
}

TAboutDialog::~TAboutDialog()
{
   delete MSButton;
}

void TAboutDialog::SetupWindow()
{
	TPropertyPage::SetupWindow();
   Static1->SetWindowFont(TFont("MS Sans Serif", 12), true);
}

void TAboutDialog::EvDrawItem(uint ctrlId, DRAWITEMSTRUCT far& drawInfo)
{
	if (ctrlId==IDC_INFOBITMAP)
   	{
      TDib* InfoImageDib;
  		TDC drawDC(drawInfo.hDC);
  		TRect itemRect(drawInfo.rcItem.left, drawInfo.rcItem.top,
                 drawInfo.rcItem.right, drawInfo.rcItem.bottom);


   InfoImageDib= new TDib(*GetApplication(), (TResId)InfoImage);

	bool Pal=true;
   TPalette* Palette;

   try
     	{
      Palette= new TPalette(*InfoImageDib);
     	}
   catch (...)
     	{
      Pal=false;
      }

  	if (Pal)
    	{
    	drawDC.SelectObject(*Palette);
  		drawDC.RealizePalette();
    	}

	drawDC.SetDIBitsToDevice(TRect(0,0,64,108), TPoint(0,0), *InfoImageDib);

	if (Pal)
     	{
      drawDC.RestorePalette();
      delete Palette;
     	}

  	delete InfoImageDib;
	}

   if (ctrlId==IDC_MEUSESOFT)
   	{
      MSButton->ODADrawEntire(drawInfo);
      }
}

void TAboutDialog::GoToUltisoft()
{
}

void TAboutDialog::GoToMeusesoft()
{
	::ShellExecute(NULL, "open", "http://www.meusesoft.com", NULL, NULL, SW_SHOWNORMAL);
}
//-------
TMyPropertySheet::TMyPropertySheet(TWindow* parent, const char far* title, uint startPage,
    						bool isWizard, uint32 flags,
                     TModule* module):
	TPropertySheet(parent, title, startPage, isWizard, flags, module)
{
}

void TMyPropertySheet::SetupWindow()
{
	TPropertySheet::SetupWindow();
	int x=GetApplication()->GetMainWindow()->GetWindowRect().left+
		(GetApplication()->GetMainWindow()->GetWindowRect().Width()-GetWindowRect().Width())/2;
	int y=GetApplication()->GetMainWindow()->GetWindowRect().top+
		(GetApplication()->GetMainWindow()->GetWindowRect().Height()-GetWindowRect().Height())/2;
	MoveWindow(x,y,GetWindowRect().Width(), GetWindowRect().Height());
}
#endif

//-----
VariationData NewGame = {"New", false, false, false, false, false, 4, false, false};

DEFINE_RESPONSE_TABLE1(TVariationDlg, CenterDialog)
 	EV_LBN_SELCHANGE(IDC_VARIATIONLIST, VariationClicked),
	EV_COMMAND(IDC_NEWVAR, NewVariation),
	EV_COMMAND(IDC_DELVAR, DeleteVariation),
   EV_COMMAND(IDC_SAVEVAR, SaveVariation),
   EV_COMMAND(IDC_OKBUTTON, OkPressed),
    #if defined(BI_PLAT_WIN32)
   EV_WM_HELP,
   #endif
	EV_COMMAND_ENABLE(IDC_SAVEVAR, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_NEWVAR, CeReadOnly2),
	EV_COMMAND_ENABLE(IDC_DELVAR, CeDeleteVariation),
	EV_COMMAND_ENABLE(IDC_FIREMARK, CeFireMark),
	EV_COMMAND_ENABLE(IDC_BONUSMARK, CeBonusMark),
	EV_COMMAND_ENABLE(IDC_VARNAMEEDIT, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_USEFIRE, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_NEVERTIE31, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_NEVERTIEHAND, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_NMARKEDIT, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_ONETURNPASS, CeReadOnly),
	EV_COMMAND_ENABLE(IDC_ALWAYSWINNER, CeReadOnly),
END_RESPONSE_TABLE;

TVariationDlg::TVariationDlg(TWindow* parent, int ResId, bool taal)
  : CenterDialog(parent, ResId)
{
   VariationArray= new TDynamicArray(sizeof(VariationData), 2);
   engels=taal;
   ReadOnly=false;
}

TVariationDlg::TVariationDlg(TWindow* parent, int ResId, bool taal, VariationData VarData)
  : CenterDialog(parent, ResId)
{
   VariationArray= new TDynamicArray(sizeof(VariationData), 2);
	VariationArray->AddEntry(&VarData);
   engels=taal;
   ReadOnly=true;
}

void TVariationDlg::SetupWindow()
{
   VariationList = new TListBox(this, IDC_VARIATIONLIST);

   VarName = new TEdit(this, IDC_VARNAMEEDIT, 40);
   UseFire = new TCheckBox(this, IDC_USEFIRE, 0);
   FireMark = new TCheckBox(this, IDC_FIREMARK, 0);
   NeverTie31 = new TCheckBox(this, IDC_NEVERTIE31, 0);
   NeverTieHand = new TCheckBox(this, IDC_NEVERTIEHAND, 0);

   NMarkEdit = new TEdit(this, IDC_NMARKEDIT, 3);

   BonusMark = new TCheckBox(this, IDC_BONUSMARK, 0);
   OneTurnPass = new TCheckBox(this, IDC_ONETURNPASS, 0);
   AlwaysWinner = new TCheckBox(this, IDC_ALWAYSWINNER, 0);

	VariationData VarEntry;

	CenterDialog::SetupWindow();

  	if (ReadOnly)
  		{
    	::ShowWindow(GetDlgItem(IDOK),SW_HIDE);
    	::EnableWindow(GetDlgItem(IDOK),false);
    	::ShowWindow(GetDlgItem(IDCANCEL),SW_HIDE);
    	::EnableWindow(GetDlgItem(IDCANCEL),false);
   	}
  	else
  		{
    	::ShowWindow(GetDlgItem(IDC_OKBUTTON),SW_HIDE);
    	::EnableWindow(GetDlgItem(IDC_OKBUTTON),false);
		LoadRules(VariationArray);
   	}

	for (int i=0; i<VariationArray->nUsed; i++)
   	{
      VariationArray->ReadEntry(i, &VarEntry);
		VariationList->AddString(VarEntry.VarName);
      }


  VariationList->SetSelIndex(0);
  VariationClicked();
}

TVariationDlg::~TVariationDlg()
{
	delete VariationArray;
   delete VariationList;
}

#if defined(BI_PLAT_WIN32)
//------------------

void TVariationDlg::EvHelp(HELPINFO far& h)
{
	int Id=0;

	if (h.iContextType==HELPINFO_WINDOW)
   	{
      switch (h.iCtrlId) {
      	case IDC_VARNAMEEDIT: { Id=IDH_EditVarName; break; }
      	case IDC_USEFIRE: { Id=IDH_Fire1; break; }
      	case IDC_FIREMARK: { Id=IDH_Fire2; break; }
      	case IDC_NEVERTIE31: { Id=IDH_Tie305; break; }
      	case IDC_NEVERTIEHAND: { Id=IDH_NeverTie; break; }
      	case IDC_NMARKEDIT: { Id=IDH_nMarks; break; }
      	case IDC_BONUSMARK: { Id=IDH_BonusMark; break; }
      	case IDC_ONETURNPASS: { Id=IDH_OneTurnAfterPass; break; }
      	case IDC_ALWAYSWINNER: { Id=IDH_AlwaysWinner; break; }
		};

		if (Id!=0) {

			DWORD ids[3] ;
	  		ids[0] = h.iCtrlId ;
	  		ids[1] = Id ;
	  		ids[2] = 0 ;

			//WinHelp(engels ? "31WIN-EN.CHM" : "31WIN-NL.CHM", HELP_CONTEXTPOPUP, Id);
		 /*	HtmlHelp(GetItemHandle(h.iCtrlId), engels ? "31WIN-EN.CHM::/TextPopups.txt" : "31WIN-NL.CHM::/TextPopups.txt",
         			HH_TP_HELP_CONTEXTMENU, (DWORD) ids)  ;  */


			}
		}
}
#endif

void TVariationDlg::NewVariation()
{
	VariationArray->AddEntry(&NewGame);
	VariationList->AddString(NewGame.VarName);
	VariationList->SetSelIndex(VariationArray->nUsed-1);
   VariationClicked();
}

void TVariationDlg::SaveVariation()
{
   char textbuffer[65];
	int sel=VariationList->GetSelIndex();
   VariationData VarData;

	if (sel>=0)
   	{
   	VarName->GetText(VarData.VarName, 40);

      VarData.Fire = (UseFire->GetCheck()==BF_CHECKED);
      VarData.FireEveryOneLoses = (FireMark->GetCheck()==BF_CHECKED);
      VarData.NeverTieWithLowest31 = (NeverTie31->GetCheck()==BF_CHECKED);
      VarData.NeverTieWithLowestHand = (NeverTieHand->GetCheck()==BF_CHECKED);
      VarData.BonusMark = (BonusMark->GetCheck()==BF_CHECKED);
      VarData.OneTurnAfterPass = (OneTurnPass->GetCheck()==BF_CHECKED);
      VarData.AlwaysAWinner = (AlwaysWinner->GetCheck()==BF_CHECKED);

   	NMarkEdit->GetText(textbuffer, 64);
   	VarData.NumberOfMarks=atoi(textbuffer);

      VariationArray->ModifyEntry(sel, &VarData);
      VariationList->DeleteString(sel);
      VariationList->InsertString(VarData.VarName, sel);
      VariationList->SetSelIndex(sel);
      }
}

void TVariationDlg::VariationClicked()
{
	VariationData VarData;
   int n;
   char nm[3];

   n=VariationList->GetSelIndex();

   VariationArray->ReadEntry(n, &VarData);

   VarName->SetText(VarData.VarName);

   UseFire->SetCheck(VarData.Fire ? BF_CHECKED : BF_UNCHECKED);
   FireMark->SetCheck(VarData.FireEveryOneLoses ? BF_CHECKED : BF_UNCHECKED);
   NeverTie31->SetCheck(VarData.NeverTieWithLowest31 ? BF_CHECKED : BF_UNCHECKED);
   NeverTieHand->SetCheck(VarData.NeverTieWithLowestHand ? BF_CHECKED : BF_UNCHECKED);

   itoa(VarData.NumberOfMarks, nm, 10);
   NMarkEdit->SetText(nm);

   BonusMark->SetCheck(VarData.BonusMark ? BF_CHECKED : BF_UNCHECKED);
   OneTurnPass->SetCheck(VarData.OneTurnAfterPass ? BF_CHECKED : BF_UNCHECKED);
   AlwaysWinner->SetCheck(VarData.AlwaysAWinner ? BF_CHECKED : BF_UNCHECKED);
}

void TVariationDlg::DeleteVariation()
{
	int sel = VariationList->GetSelIndex();

	VariationList->DeleteString(sel);
	VariationArray->RemoveEntry(sel);
	if (VariationList->SetSelIndex(sel)==-1)
   	{
      VariationList->SetSelIndex(sel-1);
      }
   VariationClicked();
}

void TVariationDlg::OkPressed()
{
	CenterDialog::CmOk();
}

void TVariationDlg::CeDeleteVariation(TCommandEnabler& ce)
{
  	ce.Enable((VariationList->GetSelIndex()>1) && (!ReadOnly));
}

void TVariationDlg::CeReadOnly(TCommandEnabler& ce)
{
  	ce.Enable((!ReadOnly) && (VariationList->GetSelIndex()>1));
}

void TVariationDlg::CeReadOnly2(TCommandEnabler& ce)
{
  	ce.Enable(!ReadOnly);
}

void TVariationDlg::CeFireMark(TCommandEnabler& ce)
{
  ce.Enable((UseFire->GetCheck()==BF_CHECKED) && (!ReadOnly) && (VariationList->GetSelIndex()>1));
}

void TVariationDlg::CeBonusMark(TCommandEnabler& ce)
{
	char Marks[4];

   NMarkEdit->GetText(Marks, 4);

   ce.Enable((atoi(Marks)<4) && (!ReadOnly) && (VariationList->GetSelIndex()>1));
}

void TVariationDlg::SaveRules()
{
	FILE* out;
	VariationData VarData;
	char OutputString[1024];
	char NumBuf[5];
	int n;

	n=2;
	if ((out = fopen("31rules.dat", "wt"))!= NULL)
		{
		strcpy(OutputString, "<-- 31 Rulez 5.0 -->");
		fprintf(out, "%s",OutputString);
		fprintf(out, "\n");

  		//Save Files
      if (VariationArray->nUsed>2)
        	{
 			strcpy(OutputString, "[Start Variation]\n");
 			fprintf(out, "%s",OutputString);
    		while (n<VariationArray->nUsed)
    			{
       		fprintf(out, "\n");
				strcpy(OutputString, "[Variation]");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

   			VariationArray->ReadEntry(n, &VarData);
        		strcpy(OutputString, "Name=");
        		strcat(OutputString, VarData.VarName);
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "Fire=");
	    		strcat(OutputString, VarData.Fire ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "FireEveryOneLoses=");
	    		strcat(OutputString, VarData.FireEveryOneLoses ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "NeverTieWithLowestHand=");
	    		strcat(OutputString, VarData.NeverTieWithLowestHand ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "NeverTieWithLowest31=");
	    		strcat(OutputString, VarData.NeverTieWithLowest31 ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "OneTurnAfterPass=");
	    		strcat(OutputString, VarData.OneTurnAfterPass ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "AlwaysAWinner=");
	    		strcat(OutputString, VarData.AlwaysAWinner ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

  				strcpy(OutputString, "BonusMark=");
	    		strcat(OutputString, VarData.BonusMark ? "True" : "False");
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

     		   strcpy(OutputString, "NumberOfMarks=");
      		itoa(VarData.NumberOfMarks, NumBuf, 10);
      		strcat(OutputString, NumBuf);
				fprintf(out, "%s",OutputString);
				fprintf(out, "\n");

 				fprintf(out, "[End]\n");

       		n++;
        		}
         strcpy(OutputString, "[End]\n");
 			fprintf(out, "%s",OutputString);
        	}
		fclose(out);
		}
}

void TVariationDlg::LoadRules(TDynamicArray* VarArray)
{
	FILE* in;
	char InputString[1024];

   VarArray->AddEntry(&EasyGame);
   VarArray->AddEntry(&HardGame);

	if ((in = fopen("31rules.dat", "rt"))!= NULL)
		{
      if (fgets(InputString, 1000, in)!=NULL)
      	{
         if (strncmp(InputString, "<-- 31 Rulez 5.0 -->", strlen(InputString)-1)!=0)
         	{
            fclose (in);
            return;
            }
         }

    while (fgets(InputString, 1024, in)!=NULL)
  		{
    	if (strlen(InputString)>1)
      	{
         if (strncmp(InputString, "[Start Variation]", strlen(InputString)-1)==0) LoadVariationsFromFile(in, VarArray);
        	}
     	}
   fclose (in);
	}
}

void TVariationDlg::LoadVariationsFromFile(FILE* in, TDynamicArray* VarArray)
{
	VariationData VarData;
	char InputString[1024], Entry[1024], Data[1024];
	int n,m;
   bool BusyWithFile;
   bool Found;

   BusyWithFile=false;

   while (fgets(InputString, 1024, in)!=NULL)
   	{
      Found=false;

      // Start toevoegen variation
    	if (strlen(InputString)>1)
      	{
         if (strncmp(InputString, "[Variation]", strlen(InputString)-1)==0)
        		{
				strcpy (VarData.VarName, "");
 				VarData.NumberOfMarks = 1;
				VarData.Fire = false;
				VarData.FireEveryOneLoses = false;
				VarData.NeverTieWithLowestHand = false;
				VarData.NeverTieWithLowest31 = false;
				VarData.OneTurnAfterPass = false;
				VarData.NumberOfMarks = false;
				VarData.BonusMark = false;
				VarData.AlwaysAWinner = false;
         	BusyWithFile=Found=true;
         	}

 			// Button toevoegen of geen buttons meer toevoegen.
      	if (strncmp(InputString, "[End]", strlen(InputString)-1)==0)
      		{
         	Found=true;
         	if (BusyWithFile)
         		{
    				VarArray->AddEntry(&VarData);
	         	BusyWithFile=false;
            	}
         	else
          		{
            	return;
            	}
      		}

        	// Entry's invullen
        	if (!Found)
            {
            n=strlen(InputString)-1;
				m=0;
            while ((n>0) && (InputString[m]!=61))
            	{
                m++;
                n--;
                }

            if ((m>0) && (n>1))
            	{
                strcpy(Entry, "");
                strncat(Entry, InputString, m);
                strcpy(Data, InputString+m+1);
                Data[strlen(Data)-1]=0;
                if (strcmp(Entry, "Name")==0) strcpy (VarData.VarName, Data);
                if (strcmp(Entry, "NumberOfMarks")==0) VarData.NumberOfMarks=atoi(Data);
                if (strcmp(Entry, "Fire")==0) VarData.Fire = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "FireEveryOneLoses")==0) VarData.FireEveryOneLoses = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "NeverTieWithLowestHand")==0) VarData.NeverTieWithLowestHand = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "NeverTieWithLowest31")==0) VarData.NeverTieWithLowest31 = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "OneTurnAfterPass")==0) VarData.OneTurnAfterPass = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "BonusMark")==0) VarData.BonusMark = ((strcmp(Data, "True")==0) ? true : false);
                if (strcmp(Entry, "AlwaysAWinner")==0) VarData.AlwaysAWinner = ((strcmp(Data, "True")==0) ? true : false);
                }
            }
        }
    }
}

