#include "main.h"
#pragma hdrstop

#include "DynArray.h"
TDynamicArray::TDynamicArray(int Size, int PreAlloc)
{
	nPreAlloc=PreAlloc;
    EntrySize=Size;
    nAlloc=0;
    nFree=0;
    MemPointer= (char*) NULL;
    MemHandle= (HGLOBAL) NULL;
    nUsed=0;
}

TDynamicArray::~TDynamicArray()
{
	if (MemPointer!=NULL)
    	{
        ::GlobalUnlock(MemHandle);
        ::GlobalFree(MemHandle);
        }
}

int  TDynamicArray::AddEntry(const void* data)
{
    char *doel;

	if (nFree==0) AllocMore();

    if (nFree!=0)
    	{
        doel=MemPointer+nUsed*EntrySize;
		  memcpy(doel, data, EntrySize);
		  nUsed++;
		  nFree--;
        return nUsed-1;
        }
    else
    	{
        return -1;
        }
}

bool TDynamicArray::ModifyEntry(int Index, const void* data)
{
    if (Index<nUsed)
    	{
        memcpy(MemPointer+Index*EntrySize, data, EntrySize);
        return true;
        }
    else
    	{
        return false;
        }
}

bool TDynamicArray::RemoveEntry(int Index)
{
    if (Index<nUsed)
    	{
        if (nUsed>1)
        	{
            for (int n=Index+1; n<nUsed; n++)
            	{
                memcpy(MemPointer+(n-1)*EntrySize, MemPointer+n*EntrySize, EntrySize);
                }
				}
        nFree++;
        nUsed--;
        return true;
        }
    else
    	{
        return false;
        }
}

bool TDynamicArray::ReadEntry(int Index, void* data)
{
	if (Index<nUsed)
    	{
        memcpy(data, MemPointer+Index*EntrySize, EntrySize);
        return true;
        }
    else
    	{
        return false;
        }
}

void TDynamicArray::Clear()
{
	nFree=nFree+nUsed;
    nUsed=0;
}

bool TDynamicArray::AllocMore()
{
	if (MemHandle==NULL)
		{
        MemHandle = ::GlobalAlloc(GMEM_MOVEABLE, EntrySize*nPreAlloc);
		  }
	 else
    	{
        ::GlobalUnlock(MemHandle);
		  MemHandle = (char *) ::GlobalReAlloc(MemHandle, EntrySize*(nAlloc+nPreAlloc), GMEM_MOVEABLE);
		  }
        
    if (MemHandle!=NULL)
		{
		  nAlloc=nAlloc+nPreAlloc;
		  nFree=nFree+nPreAlloc;
		  MemPointer= (char*) ::GlobalLock(MemHandle);
		  ::ZeroMemory(MemPointer+EntrySize*nUsed, EntrySize*nPreAlloc);
		  return true;
		  }
	 else
		{
		  return false;
		  }
}

