#include "main.h"
#pragma hdrstop

#define Root31Key "Software\\Meusesoft\\31 for Windows\\"
#define Reg31Key "Software\\Meusesoft\\31 for Windows\\"

void WriteRegistryInt(char Key[30], char Entry[25], int Value)
{
	#if defined(BI_PLAT_WIN32)
	char KeyString[MAX_PATH];

   strcpy(KeyString, Root31Key);
   strcat(KeyString, Key);

  	TRegKey(TRegKey::GetCurrentUser(), KeyString).SetValue(Entry,(uint32)Value);
	#endif                                                                           
	#if defined(BI_PLAT_WIN16)
   char ValueString[25];
   itoa(Value, ValueString, 10);
	WritePrivateProfileString(Key, Entry, ValueString,"31win.ini");
	#endif
}

int ReadRegistryInt(char Key[30], char Entry[25], int DefValue)
{
	#if defined(BI_PLAT_WIN32)
	char KeyString[MAX_PATH];
   uint8 RetVal[4];
   unsigned long buflen=sizeof(RetVal);
   unsigned long types=(unsigned long)REG_DWORD;

   strcpy(KeyString, Root31Key);
   strcat(KeyString, Key);

 	if(TRegKey(TRegKey::GetCurrentUser(), KeyString).QueryValue(Entry, &types, RetVal, &buflen)!=0)
      	{RetVal[0]=DefValue;}

   return RetVal[0];
   #endif
	#if defined(BI_PLAT_WIN16)
   char value[25],defvalue[25];
   itoa(DefValue, defvalue, 10);

	GetPrivateProfileString(Key, Entry, defvalue, value, 25, "31win.ini");
   return atoi(value);
	#endif
}

void WRegisterInt(char Key[30], char Entry[25], int Value)
{
	char KeyString[MAX_PATH];

   strcpy(KeyString, Reg31Key);

  	TRegKey(TRegKey::GetLocalMachine(), KeyString).SetValue(Entry,(uint32)Value);
}

int RRegisterInt(char Key[30], char Entry[25], int DefValue)
{
	char KeyString[MAX_PATH];
   uint8 RetVal[4];
   unsigned long buflen=sizeof(RetVal);
   unsigned long types=(unsigned long)REG_DWORD;

   strcpy(KeyString, Reg31Key);

 	if(TRegKey(TRegKey::GetLocalMachine(), KeyString).QueryValue(Entry, &types, RetVal, &buflen)!=0)
      	{RetVal[0]=DefValue;}

   return RetVal[0]+RetVal[1]*256+RetVal[2]*256*256;
}

void WriteRegistryString(char Key[30], char Entry[25], char Value[255])
{
	char KeyString[MAX_PATH];

   strcpy(KeyString, Root31Key);
   strcat(KeyString, Key);
   strcat(KeyString, "\\");
   strcat(KeyString, Entry);

  	TRegKey(TRegKey::GetCurrentUser(), KeyString).SetDefValue(
   		0, REG_SZ, Value, strlen(Value));
}

char* ReadRegistryString(char Key[30], char Entry[25],
					 char DefValue[MAX_PATH], char* Value, int MaxS)
{
	#if defined(BI_PLAT_WIN32)
	char KeyString[MAX_PATH];
   unsigned long reglen=MaxS;

   strcpy(KeyString, Root31Key);
   strcat(KeyString, Key);

   if(TRegKey(TRegKey::GetCurrentUser(), KeyString).QueryDefValue(Entry, Value, &reglen)!=0)
   	{strcpy(Value,DefValue);}
   #endif
	#if defined(BI_PLAT_WIN16)
	GetPrivateProfileString(Key, Entry, DefValue, Value, MaxS, "31win.ini");
	#endif

   return Value;

}

bool TestRegistration()
{
	return true; // registration disabled
	char Buffer[3];
   strcpy(Buffer,"TT");
   Buffer[0]=Buffer[0]-1;
   Buffer[1]=Buffer[1]-2;

	int a=RRegisterInt("",Buffer,0);
   if ((a/1000)!=649) return false;
   if ((a%1000)!=273) return false;
   return true;
}
