#include <winsock2.h>
#include <stdlib.h>
#include <stdio.h>
//-----------------------------------------------------------------------------

class TWinSocket {

    public:
    	TWinSocket();
      ~TWinSocket();

      bool OpenConnection(const char* pcHost, u_short nPort);
      bool SetupListener(const char* pcAddress, u_short nPort);
      bool SetReadEvent(HWND hWindow, int iDelta=0);
      bool SendMessage(char* cMessage, int iMessageSize);
      bool ReadMessage(char* cMessage, int iMaxMessageSize);
      int GetLastWinsockError();
      bool FormatError(int iLastError, char* cMessage, int iMessageSize);

      TWinSocket* AcceptConnection();

      bool CloseConnection();

    	SOCKET hConnection;
    	bool   bDebugMode;

   protected:
   	u_long LookupAddress(const char* pcHost);
      int    iMaxMessageSize;
      void   LogMessage(char* cMessage);
      void   LogError();
      void   LogFunction(char* cFunctionName);

};

//-----------------------------------------------------------------------------

class TWinSockets {

	public:
   	    TWinSockets();
        ~TWinSockets();

        TWinSocket* NewConnection(const char* pcHost, u_short nPort);
        TWinSocket* NewListener(const char* pcAddress, u_short nPort, HWND hWindow=NULL);

        bool   bDebugMode;

   private:
   	    bool bInitialised;

};

//-----------------------------------------------------------------------------


