
#ifndef _AnimHeader
#define _AnimHeader
#include <string>
#include <vector>
#include <fstream>
#include <iostream>


struct sWorldAnimation {
       
	long lAnimation;
	};

#define AW_TRANSPARANCY 0x01
#define AW_POSITION		0x02
#define AW_SIZE			0x04

enum eAnimationType {

	animHandToStack,
	animStackToHand,
	animStackToStack
	};

struct sWindowAnimation {

	long lAnimation;		//which animation
	long lDelay;			//delay before next sequence
	long lSequence;			//sequence within animation
	long lAnimationData;	//extra data
	long lDuration;			//duration of the animation

	long lWindowId;			//id of window to be animated;
	
	float fTransparancyStart; //transparancy
	float fTransparancyEnd;

	vec_f vPositionStart;	  //position
	vec_f vPositionEnd;

	vec_f vSizeStart;		  //size
	vec_f vSizeEnd;
	};


struct sCardAnimation {
       
	eAnimationType eAnimation;		//which animation
	long lSequence;			//sequence within animation
	long lDelay;			//delay before next sequence
	long lAnimationData;	//extra data

	long lCard;				//identifier of card
	long lPlayer;			//identifier of player
	long lStack;			//identifier of stack

	bool bSecret;			//if true don't render the face of the card

	vec_f vAnimationVector;	

	vec_f vStart;				//start position of card
	float vStartRotation[4];
	float fStartTranslation;

	vec_f vDestination;			//end position of card
    float vDestinationRotation[4];
    float fDestinationTranslation;
	};

class cAnimator {

	public:

		cAnimator(cSystem* poSystem, cWorld* poWorld);
		~cAnimator();

		void	AddWorldAnimation(sWorldAnimation poWorldAnimation);
		void	ClearWorldAnimations();

		void	AddCardAnimation(sCardAnimation poCardAnimation);
		void	ClearCardAnimations();
		long	lGetMaxCardAnimationDelay();
		void	SetWaitForCardAnimations();
		bool	CardAnimationsFinished();
		
		void	RegisterFakeCard(sCard* poCard);
		void	UnregisterFakeCard(sCard* poCard);
		void	UnregisterAndDeleteFakeCard(sCard* poCard);
		void	ClearRegisteredFakeCards();

		void	AddWindowAnimation(sWindowAnimation poWindowAnimation);
		void	ClearWindowAnimations();

		void	Process(long lTimePassed);

		float	CalculateShortestRotation(float pFrom, float pTo);

	private:

		void	DoAnimateCards(long lTimePassed);
		void	DoAnimateCard(long lAnimation, long lTimePassed);
		void	DoAnimateCardHandToStack(long lIndex, long lTimePassed);
		void	DoAnimateCardStackToHand(long lIndex, long lTimePassed);
		void	DoAnimateCardStackToStack(long lIndex, long lTimePassed);
		void	DoAnimateWorld(long lTimePassed);
		void	DoAnimateWindows(long lTimePassed);
		void	DoAnimateWindow(long plIndex, long plTimePassed);
		float	CalculateWorldRotation(float fTimePassed, float fRotation, float &fSpeed);

        cSystem*            oSystem;
        cWorld*             oWorld;
	
		std::vector <sCardAnimation> oCardAnimations;
		std::vector <sWorldAnimation> oWorldAnimations;
		std::vector <sWindowAnimation> oWindowAnimations;
		std::vector <sCard*> oFakeCards;

		bool bWaitForCardAnimations;
};

#endif