/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module CardGame
   
   Contains the code code for the cardgame, it manages data between animator, renderer and game logic   
   
*/
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Renderer.h"
#include "Animator.h"
#include "CardGameEngine.h"
#include "CardGame.h"

cCardGame::cCardGame(cSystem* poSystem) {

    oSystem = poSystem;
    oWorld = new cWorld();
    
    oWorld->RenderOptions.iTableType=2;
    
	oAnimator = new cAnimator(oSystem, oWorld);
    oRenderer = new cRenderer(oSystem, oWorld);
    oCardGameEngine = new cCardGameEngine(oSystem, oWorld, oAnimator);
    
    //oCardGameEngine->c_InitGame();
    //oCardGameEngine->c_InitRound();
}

cCardGame::~cCardGame() {

    delete oCardGameEngine;
    delete oRenderer;
	delete oAnimator;
    delete oWorld;
}

//Event handlers

//Handler for sizing the application its window. New size is set in oSystem
void cCardGame::onSize() {
     
     if (oRenderer) oRenderer->onSize();
     }
     

//Handler for moving the mouse
void cCardGame::onMouseMove(long plX, long plY) {
     
     //save the position of the mouse and calculate the delta
    if (oSystem->oMouseState.bLButtonDown == true) {

        oSystem->oMouseState.vMouseLastPosition[0]=plX;
        oSystem->oMouseState.vMouseLastPosition[1]=plY;     
        oSystem->oMouseState.vMouseLastPosition[2]=0; //z
        
        oSystem->oMouseState.vMouseDelta[0] = oSystem->oMouseState.vMouseStartPosition[0] - plX; 
        oSystem->oMouseState.vMouseDelta[1] = oSystem->oMouseState.vMouseStartPosition[1] - plY; 
        oSystem->oMouseState.vMouseDelta[2] = 0;
        
        //change the position of the player its view on the world
        if (abs(oSystem->oMouseState.vMouseDelta[0])>5 || abs(oSystem->oMouseState.vMouseDelta[1])>5) {

            oRenderer->onRotateWorld(oSystem->oMouseState.vMouseDelta[0], oSystem->oMouseState.vMouseDelta[1]);
            }
        }
     }
     

void cCardGame::onLeftButtonDoubleClick(long plX, long plY) {
     
	ResetMouseState();

	//determine the action

	//process the action

	//move all selected cards to the deck
	long lCardIndex;
	long plPlayer = 0;
	long lDelay = 0;

	long lSelectIndex;
	long lButtonIndex;
	long lType;

	sCard* oCard;
	sCardAnimation oCardAnimation;
	
	srand( (unsigned int)GetTickCount());

	//determine if the double click was on a stack
	oRenderer->r_Select(lType, lSelectIndex, lButtonIndex);

	//a stack is double clicked
	if (lSelectIndex>=0 && lType==1) {

		oCardGameEngine->onStackDoubleClick(lSelectIndex);
		}

	//Browse through cards in hand in order to determine selection
	/*for (long lIndex = oWorld->oPlayers[plPlayer].oCards.size()-1; lIndex>=0; lIndex--) {

		oCard = oWorld->oPlayers[plPlayer].oCards[lIndex];
		
		if (oCard->bSelected) {

			oCardAnimation.lCard = oCard->lId;				//identifier of the card
			oCardAnimation.lPlayer = plPlayer;				//which player
			oCardAnimation.eAnimation = animHandToStack;	//from hand to pot
			oCardAnimation.lDelay = lDelay;					//delay before start animation

			lDelay = lDelay + 250;
			
			oCardAnimation.lStack = 3 + ((double)rand() * (double)(oWorld->oStacks.size()-3)) / RAND_MAX;

			oAnimator->AddCardAnimation(oCardAnimation);

			oCard->bSelected = false;
			}
		}*/

	//Browse through cards in stacks in order to determine selection
	lDelay = 0;
	
	for (long lIndex = oWorld->oDeck.oCards.size()-1; lIndex>=0; lIndex--) {

		oCard = oWorld->oDeck.oCards[lIndex];
		
		if (oCard->bSelected && oCard->bVisible && oCard->lStack!=-1) {

			oCard->bSelected = false;

			switch (oWorld->oStacks[oCard->lStack].eDoubleClickAction) {

				case stackNothing: {

					break;
					}

				case stackGetOneCard: {
			
					oCardGameEngine->c_DoGetCardFromStack(plPlayer, lIndex, lDelay);

					lDelay += 250;
					break;
					}
				}
			}
		}
}


void cCardGame::onLeftButtonDown(long plX, long plY) {
     
	long lIndex;
	long lIndex2;
	long lType;
	
	SaveMouseState(plX, plY);

	oRenderer->r_Select(lType, lIndex, lIndex2);

	//a card is selected
	if (lIndex>=0 && (lType==0 || lType==1)) {

		oCardGameEngine->onCardSelect(lType, lIndex);
		ResetMouseState();
	}

	//a button is pressed
	if (lIndex>=0 && lType==3) {

		onWindowButton(lIndex, lIndex2);
		ResetMouseState();
	}
}


void cCardGame::onLeftButtonUp(long plX, long plY) {

    sWorldAnimation oWorldAnimation;
	
	oWorldAnimation.lAnimation = 0;
	oAnimator->AddWorldAnimation(oWorldAnimation);

	ResetMouseState();
    } 
    

//Handler for rendering events    
void cCardGame::onRender() {
     
	 oRenderer->r_RenderScene();

	 float fTimePassed = oRenderer->TimeBetweenLastFrames();
	 oAnimator->Process(fTimePassed);
	 if (oAnimator->CardAnimationsFinished()) oCardGameEngine->onTurn();
	} 

//Handler for key events
void cCardGame::onMoveEye(float fTranslation, float fRotation) {

	oWorld->fEyeDistance += fTranslation;
	oWorld->fEyeRotation += fRotation;

	if (oWorld->fEyeDistance > -7.0f)  oWorld->fEyeDistance = -7.0f;
	if (oWorld->fEyeDistance < -25.0f)  oWorld->fEyeDistance = -25.0f;

	if (oWorld->fEyeRotation > 90.0f) oWorld->fEyeRotation = 90.0f;
	if (oWorld->fEyeRotation < 0.0f) oWorld->fEyeRotation = 0.0f;
}

void cCardGame::onKey(long lKeyCode) {
     
	sWindow oWindow;
	
	switch (lKeyCode) 
    {
       case 27:
            //PostQuitMessage( 0 );
            break;
    
       case 1:
            oWorld->RenderOptions.bRenderLines = !oWorld->RenderOptions.bRenderLines;
            break;
    
       case 2:

			Message("Game over...", "Press the start button to start a new game.", btnStartGame, "Start");
			break;
    
       case 3:
            oWorld->RenderOptions.bRenderEnvironment = !oWorld->RenderOptions.bRenderEnvironment;
            break;
    
       case 4:
            oWorld->RenderOptions.iTableType = (oWorld->RenderOptions.iTableType + 1) % 3;
            break;
    
       case 5:
            oWorld->RenderOptions.bFullLight = !oWorld->RenderOptions.bFullLight;
            break;

       case 6:
			oWorld->RenderOptions.bDrawCardLines = !oWorld->RenderOptions.bDrawCardLines;
			break;
        }
     }
     
void cCardGame::onLineInput(std::string psInput) {

	if (psInput == "rainier") {
		oWorld->bDebug=true;
		Message("Debug mode enabled", "", btnOk, "Ok");
		}	
	}


//Window functions

//This function processes the window buttons. 
	 
void cCardGame::onWindowButton(long plWindowId, long plButtonId) {

	switch (plButtonId) {

		case btnOk: 

			WindowDestroy(plWindowId);
			break;

		case btnStartGame: 

			WindowDestroy(plWindowId);
			oCardGameEngine->c_Clean();
			oCardGameEngine->c_InitGame();
			oRenderer->r_InitGame();

			break;

		case btnDeal:

			WindowDestroy(plWindowId);
			oCardGameEngine->c_InitRound();
			break;

		default:

			//if (plButtonId >= btnUser) 
			oCardGameEngine->onWindowButton(plWindowId, plButtonId);
			
			break;
		}
	 }

//This functions stops the game in progress and starts a new one.

void cCardGame::DoNewGame() {

	oCardGameEngine->c_Clean(); //clear data
	oCardGameEngine->c_InitGame(); //init the game
	oRenderer->r_InitGame(); //init the renderer for the new game
	}

//This function destroys the given window

void cCardGame::WindowDestroy(long plWindowId) {

	oWorld->DeleteWindow(plWindowId);
//	oAnimator->DeleteWindowAnimation(plWindowId);
}

	 
//Mouse functions

//This functions save the state of the mouse. The state is saved when
//the user presses the left mouse button.
void cCardGame::SaveMouseState(long plX, long plY) {

    oSystem->oMouseState.bLButtonDown = true;
     
    oSystem->oMouseState.vMouseLastPosition[0]=plX;
    oSystem->oMouseState.vMouseLastPosition[1]=plY;     
    oSystem->oMouseState.vMouseLastPosition[2]=0; //z
    
    oSystem->oMouseState.vMouseStartPosition[0]=plX;
    oSystem->oMouseState.vMouseStartPosition[1]=plY;     
    oSystem->oMouseState.vMouseStartPosition[2]=0; //z
    
    oSystem->oMouseState.vMouseDelta[0] = 0; 
    oSystem->oMouseState.vMouseDelta[1] = 0; 
    oSystem->oMouseState.vMouseDelta[2] = 0; 
}

//This functions resets the mouse state: no buttons pressed
void cCardGame::ResetMouseState() {

    oSystem->oMouseState.bLButtonDown = false;
}    

//This function creates a window with a button on it
void cCardGame::Message(char* pcCaption, char* pcText, long plButtonId, char* pcButtonCaption) {

	sWindowAnimation oWindowAnimation;
	sWindow oWindow;

	float lCaptionLength;
	float lTextLength;
	float lButtonLength;
	float lMaxLength;

	//let the renderer calculate the textsize
	oRenderer->r_CalculateTextLineRect(pcCaption, wndCaptionFontSize, lCaptionLength);
	oRenderer->r_CalculateTextLineRect(pcText, wndTextFontSize, lTextLength);
	oRenderer->r_CalculateTextLineRect(pcButtonCaption, wndButtonFontSize, lButtonLength);

	lMaxLength = min(oSystem->iGameWindowWidth, max(lCaptionLength+1, max(lTextLength+1, lButtonLength+1)));
	
	//set the attributes of the window
	memset(&oWindow, 0, sizeof(oWindow));
	oWindow.bModal = true;
	oWindow.fTransparancy = 0.0f;
	oWindow.vBackgroundColor[0] = 0.0f;
	oWindow.vBackgroundColor[1] = 0.0f;
	oWindow.vBackgroundColor[2] = 0.0f;
	oWindow.vSize[0] = lMaxLength + 40;
	oWindow.vSize[1] = 200.0f;
	oWindow.vPosition[0] = 0.0f;
	oWindow.vPosition[1] = 0.0f;
	oWindow.eHorizontalPosition = posCenter;
	oWindow.eVerticalPosition = posCenter;
	oWindow.eHorizontalSize = sizeFixed;
	oWindow.eVerticalSize = sizeFixed;

	oWorld->AddTextToWindow(oWindow, pcCaption, 
				wndCaptionFontSize, styleSizeFit + styleAlignCenterH, 
				20, 20, lMaxLength + 20, 70);

	oWorld->AddTextToWindow(oWindow, pcText, 
				wndTextFontSize, styleSizeFixed + styleClipped + styleWordWrap + styleAlignCenterH + styleAlignCenterV, 
				20, 80, lMaxLength + 20, 134);

	oWorld->AddButtonToWindow(oWindow, plButtonId, pcButtonCaption,
				(lMaxLength - lButtonLength)/2, 150, 20 + (lMaxLength - lButtonLength)/2 + lButtonLength + 20, 180);

	oWindow.lWindowId = oWorld->AddWindow(oWindow);

	memset(&oWindowAnimation, 0, sizeof(oWindowAnimation));
	oWindowAnimation.lDelay = 0;
	oWindowAnimation.lDuration = wndAnimationDuration;
	oWindowAnimation.lAnimation = AW_TRANSPARANCY;
	oWindowAnimation.lWindowId = oWindow.lWindowId;
	oWindowAnimation.vSizeStart[0] = 0;	
	oWindowAnimation.vSizeStart[1] = 0;
	oWindowAnimation.vSizeEnd[0] = 200.0f;	
	oWindowAnimation.vSizeEnd[1] = 200.0f;
	oWindowAnimation.fTransparancyStart = 0.0f;
	oWindowAnimation.fTransparancyEnd = 0.8f;

	oAnimator->AddWindowAnimation(oWindowAnimation);
}
