
#ifndef _CardGameEngineHeader
#define _CardGameEngineHeader

struct sMeld {

	eCardType eType;

	long lCardsInStack; //the total number of card on the stack
	long lCardsInHand;  //the total number of cards of this type in the player its hand
	long lFeatureCardsInStack; // the total of feature cards in the stack (2 or Joker)
	long lFeatureCardsInHand; // the total numer of feature cards in for stack from the hand	
	bool bCanasta; //true if the stack has already more than or equal to 7 cards.
	long lStackIndex; //the stack index from the stack the meld is for. Index is -1 if it is a new meld

	std::vector<long> lCardIndex;
	};

struct sCanasta {

	long lStackIndex; //the stack index of the stack which holds a canasta
	bool bClean; //is the canasta clean? It is clean when no 2 or jokers are present
	};

struct sTeam {

	std::vector<sCanasta> oCanastas;
	std::vector<long> oStacks;
	};

enum eTurnState {

	eInitialiseTurn,
	ePickCards,
	eDiscardCards,
	eFinishTurn,
	};

enum eTurnAction {

	eTurnMeld,
	eTurnDiscard,
	eTurnGetCardFromStack,
	eTurnGetPot,
	};

class cCardGameEngine {

      public:

        cCardGameEngine(cSystem* poSystem, cWorld* poWorld, cAnimator* poAnimator);
        ~cCardGameEngine();
        
        void onCardSelect(long plPlayerIndex, long plCardIndex);
		void onStackDoubleClick(long plStackIndex);
		void onWindowButton(long plWindowId, long plButtonId);
		long onCardSort(long plPlayer, long plCard);
		void onTurn();

		void c_Clean();

        void c_InitTournament();
        void c_InitGame();
        void c_InitRound();
		
		void c_DoTurnAction(eTurnAction peAction);
		void c_DoTurnDiscard();
		void c_DoTurnMeld();
		void c_DoPassTurn();

		bool c_CheckMeld(long plPlayer);

		void c_DoGetCardFromStack(long plPlayer, long plCard, long plDelay);
		void c_DoSendCardToStack(long plPlayer, long plStack, long plCard, long plDelay);
		void c_DoCardFromToStack(long plPlayer, long plFromStack, long plToStack, long plCard, long plDelay);
		void c_DoGetCardFromPot(long plPlayer);
		
		int c_CardPoint(sCard* poCard);

	private:

		void c_InitTurn();
		void c_InitTurnCheckRed3();
		void c_CheckCanasta(long plPlayer);
		void c_HussleDeck();

		void c_DoAITurn();
		void c_DoAITurnPickCard();
		void c_DoAITurnMeldOrDiscard();
		void c_ShowPlayerActionWindow();
		eCardType c_GetStackType(long plStackIndex);
		eCardColor c_CastCardColor(int piColor);
		eCardType c_CastCardType(int piType);
		bool c_FeatureCard(sCard* poCard);
        
		eTurnState oState;
		long lActivePlayer;
		long lDealer;
		long lTurnId;

 		long lActionWindow;

		cSystem*	oSystem;
        cWorld*		oWorld;
		cAnimator*	oAnimator;

		std::vector<sTeam> oTeams;
		std::vector<sMeld> oCheckMeldHelper;
};
        
#endif
