/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Module DataStructures
   
   Contains the definitions of the data structures
   
*/

#ifndef _DataStructuresHeader
#define _DataStructuresHeader

#define _WIN32_WINNT 0x0501
#define WINVER 0x0501

#include <windows.h>
#include <vector>

#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glext.h>		//GL extensions
#include <gl/wglext.h>

#include "resource.h"


#define BUFSIZE 512

#define t_cards 0
#define t_backsides 61
#define t_shim 59
#define t_font 60
#define t_materials 70
#define card_thickness 0.003f

#define	pi	3.14159265358979323846
#define pi2 6.28318530717958647692

#define s_table 0
#define s_cardselected 1


//Standard buttons
#define btnOk 0
#define btnStartGame 1
#define btnExit 2
#define btnDeal 3
#define btnDiscard 4
#define btnMeld 5
#define btnChat 6
#define btnQuit 7
#define btnJoin 8
#define btnUser 128

//Window defaults
#define wndCaptionFontSize 30
#define wndTextFontSize 18
#define wndButtonHeight 30
#define wndButtonFontSize 22
#define wndAnimationDuration 500

//Text styles
#define	styleSizeFixed  0
#define	styleSizeFit 1
#define	styleAlignTop 2
#define	styleAlignBottom 4
#define	styleAlignLeft 8
#define	styleAlignRight 16
#define	styleAlignCenterH 32
#define	styleAlignCenterV 64
#define styleClipped 128
#define styleWordWrap 256

typedef float vec_f[3];
typedef int vec_i[3];

enum eCardColor {

	cardHearts,
	cardDiamonds,
	cardSpades,
	cardClubs,
	cardUndefined
	};

enum eCardType {

	card2,
	card3,
	card4,
	card5,
	card6,
	card7,
	card8,
	card9,
	card10,
	cardJack,
	cardQueen,
	cardKing,
	cardAce,
	cardJoker,
	cardTypeUndefined
	};

enum eWindowPosition {

	posCenter,
	posLeft,
	posRight,
	posTop,
	posBottom,
	posFixed,
	posPercentage
	};

enum eShape {

	shapeRectangle,
	shapeRoundedRectangle
	};

enum eWindowSize {

	sizeFixed,
	sizePercentage
	};

enum eStackAction {

	stackNothing,
	stackSelect,
	stackError,
	stackGetOneCard,
	stackGetAllCards,
	stackDeal
	};

enum ePlayerType {
	
	playerHuman,
	playerAI,
	playerNetwork
	};

struct sRect {

	int iLeft;
	int iRight;
	int iTop;
	int iBottom;
	};

struct sShader {

	long lShaderId;
	
	GLhandleARB hProgramObject;
	GLhandleARB hVertexShader;
	GLhandleARB hFragmentShader;
};

struct sCard {
       
	   //ID of card in the deck
	   long lId;
	
		//value
       eCardType  eType;
       eCardColor eColor;
	   long lTexture;
       
       //position
       vec_f vPosition;
       float fTranslation;

       //rotation
       float vRotation[4];
       
       //scale
       float fScale;
       
       //backside
       int iBackside;

	   //front side
	   bool bFlipTexture;
       
       //visible
       bool bVisible;
	   bool bSecret;
	   float fTransparancy;
       
       //draw as selected
       bool bSelected; 

	   //being animated (in mid air somewhere)
	   bool bAnimated;

	   //this card is fake and used to fill some space in the hand of the player
	   bool bFake;
	   long lWidth;
	   bool bWiden; //Increase or decrease width;

	   //animation position
       vec_f vAnimationPosition;
       
       //animation rotation
       vec_f vAnimationRotation;

	   //card is on stack
	   long lStack;

	   //the row of the player its hand where the card is placed
	   long lRow;

};

struct sPlayer {
       
       //position
       vec_f vPosition;
       
       //rotation
       //vec_f vRotation;
	   float fRotationPosition;
	   float fRotationCard;

	   //index of cards in hand
       std::vector<sCard*> oCards;

	   //type
	   ePlayerType oType;
       };

struct sDeck {
       
	float fTransparancy;
	std::vector<sCard*> oCards;
       };

struct sStack {

	std::vector<long> lCards;

	vec_f vPosition;
	vec_f vDelta;
	vec_f vRotation;
	bool bStandardFaceUp;
	eStackAction eClickAction;
	eStackAction eDoubleClickAction;
	};

struct sMaterialConstants {
             
    GLfloat no_mat[4];
    GLfloat mat_ambient[4];
    GLfloat mat_ambient_color[4];
    GLfloat mat_diffuse[4];
    GLfloat mat_specular[4];
    GLfloat no_shininess[1];
    GLfloat low_shininess[1];
    GLfloat high_shininess[1];
    GLfloat mat_emission[4];
};

struct sRenderOptions {
       
       bool bRenderLines; //Render polyons as lines in stead of filling them
       bool bRenderEnvironment; //Render the environment (room)
       bool bPositionEyeFarAway; //Place the camera far away from the scene
       int iTableType; //Type of table, square, round or none
       bool bFullLight; //Lighting: Full lighting on or off
	   bool bDrawCardLines; //Draw base and directions lines of cards
	   bool bAnisotropicFiltering; //Use anisotropicfiltering
       };

struct sMouseState {
    
   bool bLButtonDown;   
   
   vec_i vMouseLastPosition;    
   vec_i vMouseStartPosition;
   vec_i vMouseDelta;
};

struct sText {
       
	   //Position of the text
       int iX; 
       int iY;
	   
	   //Rectangle for clipping/aligning text
	   sRect cTextRect;
       
	   //The text itself
       char cText[128];

	   //Properties of the text
	   vec_f vColor;
	   float fTransparancy;
	   float fSize;

	   //Style elements 
	   DWORD dStyle;
};

struct sButton {
       
	   //Location and size of the button
	   sRect cButtonRect;
       
       //Caption	   
	   char cCaption[32];

	   //Id
	   long lId;

	   //Colors
		float fTransparancy;
		GLfloat vBackgroundColor[4];
		GLfloat vCaptionColor[4];
};

struct sWindow {

	long lWindowId;

	bool bModal;
	
	eWindowPosition eVerticalPosition;
	eWindowPosition eHorizontalPosition;
	eWindowSize eHorizontalSize;
	eWindowSize eVerticalSize;

	vec_f vPosition;
	vec_f vSize;

	float fTransparancy;
	vec_f vBackgroundColor;

	std::vector<sText> oTexts;
	std::vector<sButton> oButtons;
	};

struct sFont {

	long lTextureId;
	
	int iCharacterWidth[256];
	};


#endif //_DataStructuresHeader
