/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module Mesh
   
   Contains the code for loading and rendering mesh objects in OpenGL. This
   module is linked to the Renderer module
   
*/


#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Mesh.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sstream>
#include <limits>

//Constructor and destructor

cMesh::cMesh(cSystem* poSystem, cWorld* poWorld) {

	oSystem = poSystem;
	oWorld = poWorld;

	lMeshDisplayList = 0;

}

cMesh::~cMesh() {

	oPoints.clear();
	oVertexs.clear();
	oNormalPoints.clear();
	oNormalVectors.clear();
	lMaterialList.clear();
	oMaterials.clear();

	if (lMeshDisplayList!=0) glDeleteLists(lMeshDisplayList, 1);
}

//Load Mesh

void cMesh::r_LoadMeshX(std::string psFilename) {

	//this function load the mesh file
    std::string sLine;
	
	oInFile.open(psFilename.c_str(), std::ios_base::in);

	while (getline(oInFile, sLine, '\n')) {
	 
		//determine if this line is the start of a block
		if (sLine.find("{")!=sLine.npos) {
			r_LoadMeshXProcessBlock(sLine);
		}

	} //end while getline

	oInFile.close();
}

void cMesh::r_LoadMeshXProcessBlock(std::string psLine) {

	std::string sBlock;
	std::string sLine;
	size_t lPointer;
	long lBraceOpen;

	//this function process a block of data, the identification of a
	//block isn't nice, but it is functional. A lookup table would be a
	//nice setup of this function

	//remove leading spaces
	sLine = psLine;
	
	while (sLine.find(' ')==0 || sLine.find('\t')==0) {
		sLine.erase(0, 1);
	}

	//determine the type of the block	
	lPointer = sLine.find(" ");
	if (lPointer!=sLine.npos) {

		sBlock = sLine.substr(0, lPointer);
	}

	//the action is based on the block identifier
	if (sBlock=="Mesh") 
		{
		r_LoadMeshXProcessMeshBlock(false);
		return;
		}
	if (sBlock=="MeshNormals") 
		{
		r_LoadMeshXProcessMeshBlock(true);
		return;
		}
	if (sBlock=="MeshMaterialList") 
		{
		r_LoadMeshXProcessMaterialListBlock();
		return;
		}
	if (sBlock=="Material") 
		{
		r_LoadMeshXProcessMaterialBlock();
		return;
		}
	if (sBlock=="Frame") 
		{
		return;
		}

	//no known block detected, walk through the complete block
	lBraceOpen = 1;

	do { 

		getline(oInFile, sLine, '\n');
		
		if (sLine.find("{")!=sLine.npos) {
			lBraceOpen++;
			}
		if (sLine.find("}")!=sLine.npos) {
			lBraceOpen--;
			}
	} while (!oInFile.eof() && lBraceOpen>0);
}

void cMesh::r_LoadMeshXProcessMeshBlock(bool bNormals) {

	//this function process the mesh block in the directx mesh file

	sMeshPoint oMeshPoint;
    sMeshVertex oMeshVertex;
    sMaterial oMaterial;
	std::string sSubString;
	std::istringstream iStream;
    long lDataLines;
	float fValue;
	long lValue;
	long lVertices;
	long lIndex;
	std::string sLine;
	std::string sLine2;

	//read the number of points
	oInFile >> lDataLines;
	oInFile.ignore(1,'\n'); 

	//read the data. The point data consists of 3 float values; x y z
	for (lIndex=0; lIndex<lDataLines; lIndex++) {
	
		for (long lIndex2=0; lIndex2<3; lIndex2++) {

            oInFile >> fValue;
			oInFile.ignore(1,';');

            switch (lIndex2) {
                
                case 0:
                        oMeshPoint.fX = fValue;
                        break;
                case 1:
                        oMeshPoint.fY = fValue;
                        break;
                case 2:
                        oMeshPoint.fZ = fValue;
                        break;
                }
		}
		
		//store the point in the vector for Points or NormalPoints
		if (bNormals) {
			oNormalPoints.push_back(oMeshPoint);
		}
		else {
			oPoints.push_back(oMeshPoint);
		}
		oInFile.ignore(1,'\n');
	}

	//read the number of polygons
	oInFile >> lDataLines;
	oInFile.ignore(1,'\n'); 
	getline(oInFile, sLine, '\n');

	//read the data, the data consist of triangles and quads. The first number determines
	//the type of polygon (3=triangle, 4=quad)
	
	for (long lIndex=0; lIndex<lDataLines; lIndex++) {

		oInFile >> lVertices;
		oInFile.ignore(1,';'); 

		oMeshVertex.lPoints = lVertices;
		
		for (long lIndex2=0; lIndex2<lVertices; lIndex2++) {

			oInFile >> lValue;
			oInFile.ignore(1,','); 
			
			oMeshVertex.lPoint[lIndex2] = lValue;
		}

		//store the point in the vector for Points or NormalPoints
		if (bNormals) {
			oNormalVectors.push_back(oMeshVertex);
		}
		else {
			oVertexs.push_back(oMeshVertex);
		}

		oInFile.ignore(1,';'); 
		oInFile.ignore(1,'\n'); 
	}
}

void cMesh::r_LoadMeshXProcessMaterialListBlock() {

	//this functions reads the material list of the directx file

	long lNumberMaterials;
	long lDataLines;
	long lMaterialIndex;

	//read the number of materials used
	oInFile >> lNumberMaterials;
	oInFile.ignore(1,'\n'); 

	//read the number lines
	oInFile >> lDataLines;
	oInFile.ignore(1,'\n'); 

	//read the indexes of the materials
	for (long lIndex=0; lIndex<lDataLines; lIndex++) {

		oInFile >> lMaterialIndex;
		oInFile.ignore(1,'\n'); 

        lMaterialList.push_back(lMaterialIndex);
	}
}

void cMesh::r_LoadMeshXProcessMaterialBlock() {

	//this functions reads the materials of the directx file

	float fValue;
	sMaterial oMaterial;

	//line 1
		for (long lIndex=0; lIndex<4; lIndex++) {

			oInFile >> fValue;
			oInFile.ignore(1,';'); 

			oMaterial.fValue[lIndex] = fValue;
		}

		oInFile.ignore(1,'\n'); 

	//line 2
		oInFile >> fValue;
		oInFile.ignore(1,'\n'); 
		
		oMaterial.fValue[4] = fValue;
	
	//line 3
		for (long lIndex=0; lIndex<3; lIndex++) {

			oInFile >> fValue;
			oInFile.ignore(1,';'); 

			oMaterial.fValue[lIndex + 5] = fValue;
		}

		oInFile.ignore(1,'\n'); 

	//line 4
		for (long lIndex=0; lIndex<3; lIndex++) {

			oInFile >> fValue;
			oInFile.ignore(1,';'); 

			oMaterial.fValue[lIndex + 8] = fValue;
		}

		oInFile.ignore(1,'\n'); 
	
	//store the material in the vector
	oMaterials.push_back(oMaterial);
}

 
//Render the mesh
void cMesh::r_DrawMesh() {

    
     GLfloat mAmbient[4];
     GLfloat mShininess[1];
     GLfloat mEmission[4];
     GLfloat mSpecular[4];

	if (lMeshDisplayList !=0) {
		glCallList(lMeshDisplayList);                            
		}
	else {

     lMeshDisplayList = glGenLists(1);
     
     glNewList(lMeshDisplayList, GL_COMPILE);

	 glPushMatrix();
     
     glRotatef(-90, 1,0,0);
     glScalef(2,2,2);

     long lMaterial;
     
     glDisable(GL_TEXTURE_2D);

     for (long lIndex=0; lIndex<(long)oVertexs.size(); lIndex++) {
         
			// lMaterial = 2;
         
        lMaterial = lMaterialList[lIndex];
      
         mAmbient[0] = (GLfloat)oMaterials[lMaterial].fValue[0];
         mAmbient[1] = (GLfloat)oMaterials[lMaterial].fValue[1];
         mAmbient[2] = (GLfloat)oMaterials[lMaterial].fValue[2];
         mAmbient[3] = (GLfloat)oMaterials[lMaterial].fValue[3];
         
         mShininess[0] = (GLfloat)oMaterials[lMaterial].fValue[4];
         //mShininess[0] = 0;

         mSpecular[0] = (GLfloat)oMaterials[lMaterial].fValue[5];
         mSpecular[1] = (GLfloat)oMaterials[lMaterial].fValue[6];
         mSpecular[2] = (GLfloat)oMaterials[lMaterial].fValue[7];
         mSpecular[3] = 0;
         
         mEmission[0] = (GLfloat)oMaterials[lMaterial].fValue[8];
         mEmission[1] = (GLfloat)oMaterials[lMaterial].fValue[9];
         mEmission[2] = (GLfloat)oMaterials[lMaterial].fValue[10];
         mEmission[3] = 0;
         

         glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, mAmbient);
         glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, mAmbient);
         glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, mEmission);
         glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mSpecular);
         glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, mShininess);

        if (oVertexs[lIndex].lPoints==3) {
                                               
            glBegin(GL_TRIANGLES);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fZ);
            glVertex3f(oPoints[oVertexs[lIndex].lPoint[0]].fX, oPoints[oVertexs[lIndex].lPoint[0]].fY, oPoints[oVertexs[lIndex].lPoint[0]].fZ);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[1]].fX, oPoints[oVertexs[lIndex].lPoint[1]].fY, oPoints[oVertexs[lIndex].lPoint[1]].fZ);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[2]].fX, oPoints[oVertexs[lIndex].lPoint[2]].fY, oPoints[oVertexs[lIndex].lPoint[2]].fZ);
        	glEnd();
        }
        else {                                       
        
            glBegin(GL_QUADS);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[0]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[0]].fX, oPoints[oVertexs[lIndex].lPoint[0]].fY, oPoints[oVertexs[lIndex].lPoint[0]].fZ);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[1]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[1]].fX, oPoints[oVertexs[lIndex].lPoint[1]].fY, oPoints[oVertexs[lIndex].lPoint[1]].fZ);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[2]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[2]].fX, oPoints[oVertexs[lIndex].lPoint[2]].fY, oPoints[oVertexs[lIndex].lPoint[2]].fZ);
        	glNormal3f(oNormalPoints[oNormalVectors[lIndex].lPoint[3]].fX, oNormalPoints[oNormalVectors[lIndex].lPoint[3]].fY, oNormalPoints[oNormalVectors[lIndex].lPoint[3]].fZ);
        	glVertex3f(oPoints[oVertexs[lIndex].lPoint[3]].fX, oPoints[oVertexs[lIndex].lPoint[3]].fY, oPoints[oVertexs[lIndex].lPoint[3]].fZ);
        	glEnd();
            }
         }
         
     glPopMatrix();
     glEnable(GL_TEXTURE_2D);
     glEndList();
	}
}

