
#ifndef _MeshHeader
#define _MeshHeader
#include <string>
#include <vector>
#include <fstream>
#include <iostream>

struct sMeshPoint {
       
       float fX;
       float fY;
       float fZ;
       
       };
       
struct sMeshVertex {
       
       long lPoints;
       long lPoint[4];
       };
       
struct sMaterial {
       
       GLfloat fValue[20];
       };

class cMesh {

public:

	cMesh(cSystem* poSystem, cWorld* poWorld);
	~cMesh();

	void r_LoadMeshX(std::string psFilename);
	void r_DrawMesh();

private:

	void r_LoadMeshXProcessBlock(std::string psBlock);
	void r_LoadMeshXProcessMeshBlock(bool bNormals = false);
	void r_LoadMeshXProcessMaterialListBlock();
	void r_LoadMeshXProcessMaterialBlock();

	cSystem*            oSystem;
    cWorld*             oWorld;

	std::vector<sMeshPoint> oPoints;
    std::vector<sMeshVertex> oVertexs;
    std::vector<sMeshPoint> oNormalPoints;
    std::vector<sMeshVertex> oNormalVectors;
    std::vector<long> lMaterialList;
    std::vector<sMaterial> oMaterials;

	std::vector<std::string> sPart;

	GLuint lMeshDisplayList;

	std::ifstream oInFile;
};

#endif //_MeshHeader