
#ifndef _RendererHeader
#define _RendererHeader
#include "Mesh.h"
#include <string>
#include <vector>
#include <fstream>
#include <iostream>
      
class cRenderer {

      public:

        cRenderer(cSystem* poSystem, cWorld* poWorld);
        ~cRenderer();
                
        void r_RendererInitStructures();
        void r_RenderScene();
        void r_Select(long &plType, long &plIndex, long &plIndex2);
		void r_InitGame();
        
        void onSize();
        void onRotateWorld(float pfDeltaX, float pfDeltaY);

		void LoadSettings();
		void SaveSettings();
        
        float TimeBetweenLastFrames();
		
		char* r_CalculateTextLineRect(char *pcText, float pfSize, float &plWidth);

      private:
        
        //Initialisation functions
        void r_LoadTextures();
        void r_LoadTexture(long lTextureIndex, char* pcFilename, bool bMipMap);
        void r_LoadTextureAlpha(long lTextureIndex, char* pcFilename, bool bMipMap);
        void r_LoadTextureAlpha2(long lTextureIndex, char* pcFilename, char* pcFilenameAlpha, bool bMipMap);
		void r_LoadTextureFont(long lTextureIndex, char* pcFilename, char* pcFilenameAlpha, char* pcFilenameWidths);
		void r_InitShaders();
		void r_LoadShaders();
		long r_LoadShader(long plShaderId, char* pcVertexFilename, char* pcFragmentFilename);
		GLhandleARB r_LoadShaderObject(char* pcFilename, GLenum shaderType);
		void r_ClearShaders();

        void r_PositionDeck();
        void r_PositionCardsInHand(sPlayer &poPlayer, sDeck &poDeck);


		//Drawing functions        
		void r_DrawScene(GLenum mode);
		void r_DrawTable();
		void r_DrawHud(GLenum mode);
		void r_DrawWindows(GLenum mode);
		void r_Draw2DShape(eShape peShape, sRect poRect, bool bFill);
		void r_DrawCube();
		void r_DrawRoom();
		void r_DrawSquare();
		void r_DrawStacks();
		void r_DrawMesh();
		void r_DrawCard(sCard* poCard, GLenum mode, bool pbDrawFront);
		void r_DrawCards(sDeck &poDeck, GLenum mode);
		void r_DrawPlayerHand(sPlayer &poPlayer, sDeck &poDeck, GLenum mode, bool pbDrawFront);
		void r_DrawText(sText &poText);
		void r_DrawButton(sButton &poButton);
		void r_DrawQuadsRecursive(vec_f v1, vec_f v2, long lDepth);
		void r_DrawTrianglesRecursive(vec_f v1, vec_f v2, vec_f v3, long lDepth);
		void r_SetLighting();
		bool r_UseShader(long plShaderId);
		void r_TurnOffShader();

        //Calculation functions
        void CrossProduct(vec_f pV1, vec_f pV2, vec_f pVcross);
        void NormalizeVector(vec_f pVin, vec_f pVnormal);
        void r_TimeFrame();
        float r_CalculateFPS();
		void r_CalculateTextRect(sText &poText, long &plWidth, long &plHeight, long &plNumberLines);
		bool r_CalculateTextClipping(sText &poText, long x1, long y1, float fCharacterWidth, float fSize, float &pfDeltaX1, float &pfDeltaX2, float &pfDeltaY1, float &pfDeltaY2);

		char* textFileRead(char *fn);

		
		cSystem*            oSystem;
        cWorld*             oWorld;
        sText               oText;
        
        cMesh *oMesh; 
		cMesh *oRoom;
        
        float theta;
		long  lIncrement;
        GLUquadricObj* guDisk;
        DWORD               dTickCount;

		long lCurrentFont;
        std::vector<DWORD> dFrameTickCount;
		std::vector<sFont> oFonts;
		std::vector<sShader> oShaders;

        GLuint fontOffset;

		
		//Function pointer for shaders
		bool bShaders;
		PFNGLCREATESHADEROBJECTARBPROC glCreateShaderObjectARB;
		PFNGLSHADERSOURCEARBPROC glShaderSourceARB;
		PFNGLCOMPILESHADERARBPROC glCompileShaderARB;
		PFNGLCREATEPROGRAMOBJECTARBPROC glCreateProgramObjectARB;
		PFNGLATTACHOBJECTARBPROC glAttachObjectARB;
		PFNGLLINKPROGRAMARBPROC glLinkProgramARB;
		PFNGLUSEPROGRAMOBJECTARBPROC glUseProgramObjectARB;
		PFNGLUNIFORM1IARBPROC glUniform1iARB;
		PFNGLUNIFORM1FARBPROC glUniform1fARB;
		PFNGLUNIFORM2FARBPROC glUniform2fARB;
		PFNGLUNIFORM3FARBPROC glUniform3fARB;
		PFNGLUNIFORM4FARBPROC glUniform4fARB;
		PFNGLGETUNIFORMLOCATIONARBPROC glGetUniformLocationARB;
		PFNGLDETACHOBJECTARBPROC glDetachObjectARB;
		PFNGLDELETEOBJECTARBPROC glDeleteObjectARB;
		PFNGLGETOBJECTPARAMETERIVARBPROC glGetObjectParameterivARB;
		PFNGLGETINFOLOGARBPROC glGetInfoLogARB;
		PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;

};

#endif //_RendererHeader
