#define RegistryBase "software\\meusesoft\\CardGame3D\\"

class cSystem {
       
       public:
           
           cSystem();
           ~cSystem();   

           DWORD GetTickCount();
		   
			bool PumpWaitingMessage();

			bool LoadSettings();
			bool SaveSettings();
           
			//methods for reading/writing from/to the registry (or another way of storing preferences
			//and settings)
			int ReadInteger(std::string pKey, std::string pEntry, int piDefaultValue);
			void WriteInteger(std::string pKey, std::string pEntry, int piValue);
			
			void WriteString(std::string pKey, std::string pEntry, std::string psValue);
			void ReadString(std::string pKey, std::string pEntry, std::string psDefaultValue, std::string &psValue);

	
		   sMouseState oMouseState;               //the data structure containing the position and state of the mouse buttons
           
           HWND hWndMainWindow;                   //The handle to the main window
           HWND hWndGameWindow;                   //The handle to the game window
           HWND hWndTaskBar;					  //The handle to the window its taskbar
           HDC hDC;                               //Handle to the windows its DC
           HGLRC hRC;                             //Handle to the OpenGL Rendering Context
		   HACCEL hAcceleratorMain;				  //Handle to accelerator table of main window
		   HMENU hMenuMain;						  //Handle to the main menu
		   WINDOWPLACEMENT oWindowPlacement;	  //Windowplacement structure
		   WPARAM wParam;						  //Last message its wParam
		   LPARAM lParam;						  //Last message its lParam

           int iGameWindowWidth;                  //The width of the window
           int iGameWindowHeight;                 //The height of the window
           int iTaskWindowWidth;                  //The width of the window
           int iTaskWindowHeight;                 //The height of the window
           int iWindowWidth;                      //The width of the window
           int iWindowHeight;                     //The height of the window
		   int iWindowState;					  //State of window; normal, maximized or even full screen?
		   int iOldWindowState;					  //Backup of the window state
		   int iWindowPositionX;				  //Position of main window on X-axis
		   int iWindowPositionY;				  //Position of main window on Y-axis
           int iPixelFormatMultiSample;           //Is there a pixelformat for multisample? 0=no
           
           DWORD dTickBeforeRenderingScene;       //The tick count measured beforing starting rendering the scene
           
       };       
