/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module WinApplication
   
   Platform depend module. Contains the applications main routine and 
   performs the translation between platform dependent calls/events to
   events for the game   
   
*/
#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Renderer.h"
#include "Animator.h"
#include "CardGameEngine.h"
#include "CardGame.h"
#include "WindowGame.h"
#include "WindowTask.h"
#include "WindowMain.h"

#include <stdio.h>
#include <string.h>

cSystem* oSystem;
cWindowMain* oMainWindow;

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

//The main routine of the application. It processes the messages and
//does the rendering of the scene

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int iCmdShow)
{
    BOOL bQuit = false;
	WPARAM wParam;    
    
    oSystem = new cSystem();
	oMainWindow = new cWindowMain(oSystem);
    
    //Create window and the initiate the OpenGL driver
    oMainWindow->CreateMainWindow(hInstance, WndProc);
    
    //Application its main loop
	while (!bQuit) 
		{
		//Check for messages, and if present then process them
		bQuit = oSystem->PumpWaitingMessage();
			
		oMainWindow->onRender();
          
		SwapBuffers( oSystem->hDC );
		}
    
    //Close and destroy the windows
    delete oMainWindow;
	
	wParam = oSystem->wParam;
	delete oSystem;
    
    return wParam;
}

//Process messages
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {

	return oMainWindow->WndProc(hWnd, message, wParam, lParam);
	}

