/*
   
   CardGame3D Engine
   Copyright 2005 - Meusesoft
   
   Version 0.1: November 2005 - 
   
   
   
   Module WindowGame
   
   Contains the code code of the game window   
   
*/

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "DataStructures.h"
#include "System.h"
#include "World.h"
#include "Renderer.h"
#include "Animator.h"
#include "CardGameEngine.h"
#include "CardGame.h"
#include "WindowGame.h"

//Constructor and destructor

cWindowGame::cWindowGame(cSystem* poSystem) {

	oSystem = poSystem;
	oCardGame = NULL;

	}

cWindowGame::~cWindowGame() {

	wglMakeCurrent( NULL, NULL );
	wglDeleteContext( oSystem->hRC );
	ReleaseDC( oSystem->hWndGameWindow, oSystem->hDC );
  
	DestroyWindow( oSystem->hWndGameWindow);

	delete oCardGame;
}

//Window creation

bool cWindowGame::CreateGameWindow(HINSTANCE hInstance, WNDPROC WndProc) {
	
	WNDCLASS wc;
	DWORD dWindowStyle;
    int iFormat;
    int iPixelFormat;
    bool bReturn;
   
    // register window class
    wc.style = CS_OWNDC | CS_DBLCLKS;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "MeusesoftCardGame_Game";
    RegisterClass( &wc );

	dWindowStyle = WS_CHILD | WS_VISIBLE;

	oSystem->hWndGameWindow = CreateWindow( 
          "MeusesoftCardGame_Game", "CardGameWindow", dWindowStyle,
          0, 0, oSystem->iGameWindowWidth, oSystem->iGameWindowHeight, oSystem->hWndMainWindow, NULL, hInstance, NULL);

	if (oSystem->hWndGameWindow != NULL) {
	
		// get the device context (DC)
		oSystem->hDC = GetDC(oSystem->hWndGameWindow);
    
		// set the pixel format for the DC
		PIXELFORMATDESCRIPTOR pfd =											// pfd Tells Windows How We Want Things To Be
		{
    		sizeof (PIXELFORMATDESCRIPTOR),									// Size Of This Pixel Format Descriptor
    		1,																// Version Number
    		PFD_DRAW_TO_WINDOW |											// Format Must Support Window
    		PFD_SUPPORT_OPENGL |											// Format Must Support OpenGL
    		PFD_DOUBLEBUFFER,												// Must Support Double Buffering
    		PFD_TYPE_RGBA,													// Request An RGBA Format
    		32,										                        // Select Our Color Depth
    		0, 0, 0, 0, 0, 0,												// Color Bits Ignored
    		1,																// Alpha Buffer
    		0,																// Shift Bit Ignored
    		0,																// No Accumulation Buffer
    		0, 0, 0, 0,														// Accumulation Bits Ignored
    		16,																// 16Bit Z-Buffer (Depth Buffer)  
    		0,																// No Stencil Buffer
    		0,																// No Auxiliary Buffer
    		PFD_MAIN_PLANE,													// Main Drawing Layer
    		0,																// Reserved
    		0, 0, 0															// Layer Masks Ignored
		};
    
		if (oSystem->iPixelFormatMultiSample == 0) {
    
			iPixelFormat = ChoosePixelFormat(oSystem->hDC, &pfd );
			}
		else {
       
			iPixelFormat = oSystem->iPixelFormatMultiSample;
			}
    
       
		if (SetPixelFormat(oSystem->hDC, iPixelFormat, &pfd)==FALSE) {
                       
			MessageBox(NULL, "error setting pixelformat", "error", MB_OK);             
                           
		LPVOID lpMsgBuf;
		if (!FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL )) {
				// Handle the error.
				return false;
				}

			// Display the string.
			MessageBox( NULL, (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );

			// Free the buffer.
			LocalFree( lpMsgBuf );
			return false;                    
			}
    
		oSystem->hRC = wglCreateContext(oSystem->hDC);
		wglMakeCurrent(oSystem->hDC, oSystem->hRC );
    
		if (oSystem->iPixelFormatMultiSample==0) {
    
			PROC wglGetExtensionsStringARB = wglGetProcAddress("wglGetExtensionsStringARB");
      
			if (wglGetExtensionsStringARB!=NULL) {
                                          
				const char * wgl_ext_string = ((char*(__stdcall*)(HDC))wglGetExtensionsStringARB)(wglGetCurrentDC());
           
				float fAttributes[] = {0, 0};
				int pixelFormat;
				UINT numFormats;
    
        		int iAttributes[] =
        		{
        			WGL_DRAW_TO_WINDOW_ARB,GL_TRUE,
        			WGL_SUPPORT_OPENGL_ARB,GL_TRUE,
        			WGL_ACCELERATION_ARB,WGL_FULL_ACCELERATION_ARB,
        			WGL_COLOR_BITS_ARB,24,
        			WGL_ALPHA_BITS_ARB,0,
        			WGL_DEPTH_BITS_ARB,16,
        			WGL_STENCIL_BITS_ARB,0,
        			WGL_DOUBLE_BUFFER_ARB,GL_TRUE,
        			WGL_SAMPLE_BUFFERS_ARB,GL_TRUE,
        			WGL_SAMPLES_ARB,4,
        			0,0
        			};
       
				PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB = (PFNWGLCHOOSEPIXELFORMATARBPROC)wglGetProcAddress("wglChoosePixelFormatARB");	
    
				int status = wglChoosePixelFormatARB(GetDC(oSystem->hWndGameWindow), iAttributes, fAttributes, 1, &pixelFormat, &numFormats);                                    
                                           
				if (status && numFormats >= 1) {
           
					oSystem->iPixelFormatMultiSample = pixelFormat;
        
					wglMakeCurrent( NULL, NULL );
					wglDeleteContext( oSystem->hRC );
					ReleaseDC( oSystem->hWndGameWindow, oSystem->hDC );
           
					DestroyWindow(oSystem->hWndGameWindow );
           
					CreateGameWindow(hInstance, WndProc);
					}
				}                                       
			}
		}

    if (oCardGame==NULL) oCardGame = new cCardGame(oSystem);

	return true;
}

void cWindowGame::onSize() {

	oCardGame->onSize();
	}

void cWindowGame::onRender() {

	oCardGame->onRender();
	}

void cWindowGame::onKey(long lKeyCode) {

	oCardGame->onKey(lKeyCode);
	}

void cWindowGame::onLineInput(std::string psInput) {

	oCardGame->onLineInput(psInput);
	}



LRESULT cWindowGame::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  //return DefWindowProc(hWnd, message, wParam, lParam);
  
  POINT cursorPos;
  long lIndex;
  short dMovement;

  switch (message) 
  {
      case WM_CREATE:
           return 0;

      case WM_DESTROY:
           return 0;
        
	  case WM_LBUTTONDBLCLK:
			GetCursorPos(&cursorPos);
			ScreenToClient(oSystem->hWndGameWindow, &cursorPos);

			if (oCardGame) oCardGame->onLeftButtonDoubleClick(cursorPos.x, cursorPos.y);
			return 0;

	  case WM_LBUTTONUP:
           GetCursorPos(&cursorPos);
           ScreenToClient(oSystem->hWndGameWindow, &cursorPos);

           if (oCardGame) oCardGame->onLeftButtonUp(cursorPos.x, cursorPos.y);
           ReleaseCapture();
           return 0;
      
      case WM_MOUSEMOVE:
           GetCursorPos(&cursorPos);
           ScreenToClient(oSystem->hWndGameWindow, &cursorPos);

           if (oCardGame) oCardGame->onMouseMove(cursorPos.x, cursorPos.y);
           return 0;

      case WM_LBUTTONDOWN:
           GetCursorPos(&cursorPos);
           ScreenToClient(oSystem->hWndGameWindow, &cursorPos);

           if (oCardGame) oCardGame->onLeftButtonDown(cursorPos.x, cursorPos.y);

           SetCapture(oSystem->hWndGameWindow);
           return 0;

	  case WM_MOUSEWHEEL:

			dMovement = GET_WHEEL_DELTA_WPARAM(wParam);

			oCardGame->onMoveEye(0.25f * ((int)dMovement / 120), 0);
			return 0;


      default:
           return DefWindowProc(hWnd, message, wParam, lParam);
           }
}

bool cWindowGame::onCommand(WPARAM wParam, LPARAM lParam) {

	bool bReturn;

	bReturn = false;
	
	switch(LOWORD(wParam)) {

		case ID_GAME_NEWGAME: {

			oCardGame->DoNewGame();
			bReturn = true;
			break;
			}

		case ID_MOVEAWAY: {

			oCardGame->onMoveEye(-0.25f, 0);
			bReturn = true;
			break;
			}

		case ID_MOVECLOSER: {

			oCardGame->onMoveEye(+0.25f, 0);
			bReturn = true;
			break;
			}

		case ID_ROTATEFORWARD: {

			oCardGame->onMoveEye(0, -0.5f);
			bReturn = true;
			break;
			}

		case ID_ROTATEBACKWARD: {

			oCardGame->onMoveEye(0, +0.5f);
			bReturn = true;
			break;
			}
		default: {

				}
	}
	
	return bReturn;
}

