#ifndef _WorldHeader
#define _WorldHeader

class cWorld {       

	public:
       
		cWorld();
		~cWorld();

		long AddWindow(sWindow &poWindow);
		long FindWindow(long lWindowId);
		long AddTextToWindow(sWindow &poWindow, char* pcText, float pfSize, DWORD pdStyle, int piLeft, int piTop, int piRight, int piBottom); 
		long AddButtonToWindow(sWindow &poWindow, long lButtonId, char* pcCaption, int piLeft, int piTop, int piRight, int piBottom); 
		bool DeleteWindow(long lWindowId);

        void w_PositionPlayers();
        void CrossProduct(vec_f pV1, vec_f pV2, vec_f pVcross);
        void NormalizeVector(vec_f pVin, vec_f pVnormal);

		long GetNumberCardSelected(long plPlayer);
		sCard* GetSelectedCard(long plPlayer, long plNumber);

		sMaterialConstants MaterialConstants;   
		sRenderOptions RenderOptions;

		GLuint* lTextures;

		float fRotateWorldXAxis;    
		float fRotateWorldYAxis;

		float fVx;
		float fVy;

		float fEyeDistance;
		float fEyeRotation;

		GLuint lRoomDisplayList;
		GLuint lCardDisplayList;
		float fTextureRepeat;

		//a card is part of the deck (on the table) part of the player its hand or is animated (floating in mid air)
		sDeck   oDeck;
		std::vector <sPlayer> oPlayers;
		std::vector <sStack> oStacks;
		std::vector <sWindow> oWindows;

		bool bDebug;
};

#endif